"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _layers = require("@deck.gl/layers");

var _excluded = ["updateTriggers"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var LEFT = 0,
    TOP = 1,
    RIGHT = 2,
    BOTTOM = 3;

var EnhancedTextBackgroundLayer = function (_TextBackgroundLayer) {
  (0, _inherits2.default)(EnhancedTextBackgroundLayer, _TextBackgroundLayer);

  var _super = _createSuper(EnhancedTextBackgroundLayer);

  function EnhancedTextBackgroundLayer() {
    (0, _classCallCheck2.default)(this, EnhancedTextBackgroundLayer);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(EnhancedTextBackgroundLayer, [{
    key: "getShaders",
    value: function getShaders() {
      var shaders = (0, _get2.default)((0, _getPrototypeOf2.default)(EnhancedTextBackgroundLayer.prototype), "getShaders", this).call(this);
      var vs = shaders.vs;
      vs = vs.replaceAll('padding.', '_padding.');
      vs = vs.replace('void main(void) {', 'void main(void) {\n  vec4 _padding = padding + instancePixelOffsets.xyxy * vec4(1.0, 1.0, -1.0, -1.0);');
      return _objectSpread(_objectSpread({}, shaders), {}, {
        vs: vs
      });
    }
  }]);
  return EnhancedTextBackgroundLayer;
}(_layers._TextBackgroundLayer);

(0, _defineProperty2.default)(EnhancedTextBackgroundLayer, "layerName", 'EnhancedTextBackgroundLayer');

var EnhancedTextLayer = function (_TextLayer) {
  (0, _inherits2.default)(EnhancedTextLayer, _TextLayer);

  var _super2 = _createSuper(EnhancedTextLayer);

  function EnhancedTextLayer() {
    (0, _classCallCheck2.default)(this, EnhancedTextLayer);
    return _super2.apply(this, arguments);
  }

  (0, _createClass2.default)(EnhancedTextLayer, [{
    key: "filterSubLayer",
    value: function filterSubLayer(_ref) {
      var layer = _ref.layer,
          renderPass = _ref.renderPass;
      var background = layer.id.includes('primary-background');

      if (renderPass === 'collision') {
        return background;
      }

      return !background;
    }
  }]);
  return EnhancedTextLayer;
}(_layers.TextLayer);

(0, _defineProperty2.default)(EnhancedTextLayer, "layerName", 'EnhancedTextLayer');

var defaultProps = _objectSpread(_objectSpread({}, _layers.TextLayer.defaultProps), {}, {
  getRadius: {
    type: 'accessor',
    value: 1
  },
  radiusScale: {
    type: 'number',
    min: 0,
    value: 1
  }
});

var PointLabelLayer = function (_CompositeLayer) {
  (0, _inherits2.default)(PointLabelLayer, _CompositeLayer);

  var _super3 = _createSuper(PointLabelLayer);

  function PointLabelLayer() {
    (0, _classCallCheck2.default)(this, PointLabelLayer);
    return _super3.apply(this, arguments);
  }

  (0, _createClass2.default)(PointLabelLayer, [{
    key: "calculatePixelOffset",
    value: function calculatePixelOffset(secondary) {
      var _this$props = this.props,
          anchor = _this$props.getTextAnchor,
          alignment = _this$props.getAlignmentBaseline,
          getRadius = _this$props.getRadius,
          getSecondaryText = _this$props.getSecondaryText,
          radiusScale = _this$props.radiusScale,
          secondarySizeScale = _this$props.secondarySizeScale,
          sizeScale = _this$props.sizeScale;
      var xMult = anchor === 'middle' ? 0 : anchor === 'start' ? 1 : -1;
      var yMult = alignment === 'center' ? 0 : alignment === 'bottom' ? 1 : -1;
      var xPadding = sizeScale / 4;
      var yPadding = sizeScale * (1 + 1 / 4);
      var secondaryOffset = 0.6 * (1 - yMult) * sizeScale;
      var yOffset = secondary ? secondaryOffset : 0;

      if (anchor === 'middle' && alignment === 'top' && getSecondaryText) {
        yOffset -= secondaryOffset;
        yOffset -= secondarySizeScale;
        yOffset += sizeScale;
      }

      var radiusPadding = 1 + 1 / 4;
      return typeof getRadius === 'function' ? function (d, info) {
        var r = (info ? getRadius(d, info) : 1) * radiusScale * radiusPadding;
        return [xMult * (r + xPadding), yMult * (r + yPadding) + yOffset];
      } : [xMult * (getRadius * radiusScale * radiusPadding + xPadding), yMult * (getRadius * radiusScale * radiusPadding + yPadding) + yOffset];
    }
  }, {
    key: "calculateBackgroundPadding",
    value: function calculateBackgroundPadding() {
      var _this$props2 = this.props,
          anchor = _this$props2.getTextAnchor,
          alignment = _this$props2.getAlignmentBaseline,
          sizeScale = _this$props2.sizeScale;
      var paddingX = 12 * sizeScale;
      var paddingY = 3 * sizeScale;
      var backgroundPadding = [0, 0, 0, 0];

      if (alignment === 'top') {
        backgroundPadding[TOP] = paddingY;
      } else if (alignment === 'bottom') {
        backgroundPadding[BOTTOM] = paddingY;
      } else {
        backgroundPadding[TOP] = 0.5 * paddingY;
        backgroundPadding[BOTTOM] = 0.5 * paddingY;
      }

      if (anchor === 'start') {
        backgroundPadding[LEFT] = paddingX;
      } else if (anchor === 'end') {
        backgroundPadding[RIGHT] = paddingX;
      } else {
        backgroundPadding[LEFT] = 0.5 * paddingX;
        backgroundPadding[RIGHT] = 0.5 * paddingX;
      }

      return backgroundPadding;
    }
  }, {
    key: "renderTextLayer",
    value: function renderTextLayer(id, _ref2) {
      var _ref2$updateTriggers = _ref2.updateTriggers,
          updateTriggersOverride = _ref2$updateTriggers === void 0 ? {} : _ref2$updateTriggers,
          props = (0, _objectWithoutProperties2.default)(_ref2, _excluded);
      var _this$props3 = this.props,
          data = _this$props3.data,
          characterSet = _this$props3.characterSet,
          fontFamily = _this$props3.fontFamily,
          fontSettings = _this$props3.fontSettings,
          fontWeight = _this$props3.fontWeight,
          outlineColor = _this$props3.outlineColor,
          outlineWidth = _this$props3.outlineWidth,
          sizeScale = _this$props3.sizeScale,
          radiusScale = _this$props3.radiusScale,
          getAlignmentBaseline = _this$props3.getAlignmentBaseline,
          getColor = _this$props3.getColor,
          getPosition = _this$props3.getPosition,
          getTextAnchor = _this$props3.getTextAnchor,
          updateTriggers = _this$props3.updateTriggers;
      return new EnhancedTextLayer(this.getSubLayerProps({
        id: id,
        data: data,
        characterSet: characterSet,
        fontFamily: fontFamily,
        fontSettings: fontSettings,
        fontWeight: fontWeight,
        outlineColor: outlineColor,
        outlineWidth: outlineWidth,
        sizeScale: sizeScale,
        getAlignmentBaseline: getAlignmentBaseline,
        getColor: getColor,
        getPosition: getPosition,
        getTextAnchor: getTextAnchor,
        updateTriggers: _objectSpread(_objectSpread(_objectSpread({}, updateTriggers), updateTriggersOverride), {}, {
          getPixelOffset: [updateTriggers.getRadius, updateTriggers.getTextAnchor, updateTriggers.getAlignmentBaseline, radiusScale, sizeScale]
        })
      }), {
        getSize: 1,
        _subLayerProps: {
          background: {
            type: EnhancedTextBackgroundLayer
          }
        }
      }, props);
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      var _this$props4 = this.props,
          getText = _this$props4.getText,
          getSecondaryColor = _this$props4.getSecondaryColor,
          getSecondaryText = _this$props4.getSecondaryText,
          secondaryOutlineColor = _this$props4.secondaryOutlineColor,
          secondarySizeScale = _this$props4.secondarySizeScale,
          updateTriggers = _this$props4.updateTriggers;
      var getPixelOffset = this.calculatePixelOffset(false);
      var backgroundPadding = this.calculateBackgroundPadding();
      var out = [this.renderTextLayer("".concat(updateTriggers.getText, "-primary"), {
        backgroundPadding: backgroundPadding,
        getText: getText,
        getPixelOffset: getPixelOffset,
        background: true
      }), Boolean(getSecondaryText) && this.renderTextLayer("".concat(updateTriggers.getSecondaryText, "-secondary"), _objectSpread(_objectSpread(_objectSpread({
        getText: getSecondaryText,
        getPixelOffset: this.calculatePixelOffset(true),
        getAlignmentBaseline: 'top'
      }, getSecondaryColor && {
        getColor: getSecondaryColor
      }), secondarySizeScale && {
        sizeScale: secondarySizeScale
      }), secondaryOutlineColor && {
        outlineColor: secondaryOutlineColor
      }))];
      return out;
    }
  }]);
  return PointLabelLayer;
}(_core.CompositeLayer);

exports.default = PointLabelLayer;
(0, _defineProperty2.default)(PointLabelLayer, "layerName", 'PointLabelLayer');
(0, _defineProperty2.default)(PointLabelLayer, "defaultProps", defaultProps);
//# sourceMappingURL=point-label-layer.js.map