"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.renderSubLayers = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _quadbinLayer = _interopRequireDefault(require("./quadbin-layer"));

var _quadbinTileset2d = _interopRequireDefault(require("./quadbin-tileset-2d"));

var _spatialIndexTileLayer = _interopRequireDefault(require("./spatial-index-tile-layer"));

var _quadbin = require("quadbin");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var renderSubLayers = function renderSubLayers(props) {
  var data = props.data;
  if (!data || !data.length) return null;
  var isBigInt = typeof data[0].id === 'bigint';
  return new _quadbinLayer.default(props, {
    getQuadbin: isBigInt ? function (d) {
      return d.id;
    } : function (d) {
      return (0, _quadbin.hexToBigInt)(d.id);
    }
  });
};

exports.renderSubLayers = renderSubLayers;
var defaultProps = {
  aggregationResLevel: 6
};

var QuadbinTileLayer = function (_CompositeLayer) {
  (0, _inherits2.default)(QuadbinTileLayer, _CompositeLayer);

  var _super = _createSuper(QuadbinTileLayer);

  function QuadbinTileLayer() {
    var _this;

    (0, _classCallCheck2.default)(this, QuadbinTileLayer);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", void 0);
    return _this;
  }

  (0, _createClass2.default)(QuadbinTileLayer, [{
    key: "initializeState",
    value: function initializeState() {
      this.setState({
        data: null,
        tileJSON: null
      });
    }
  }, {
    key: "updateState",
    value: function updateState(_ref) {
      var changeFlags = _ref.changeFlags;

      if (changeFlags.dataChanged) {
        var data = this.props.data;
        var tileJSON = data;
        data = tileJSON.tiles;
        this.setState({
          data: data,
          tileJSON: tileJSON
        });
      }
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      var _this$state = this.state,
          data = _this$state.data,
          tileJSON = _this$state.tileJSON;
      var maxZoom = parseInt(tileJSON === null || tileJSON === void 0 ? void 0 : tileJSON.maxresolution);
      return [new _spatialIndexTileLayer.default(this.props, {
        id: "quadbin-tile-layer-".concat(this.props.id),
        data: data,
        TilesetClass: _quadbinTileset2d.default,
        renderSubLayers: renderSubLayers,
        maxZoom: maxZoom,
        loadOptions: _objectSpread(_objectSpread({}, this.getLoadOptions()), {}, {
          cartoSpatialTile: {
            scheme: 'quadbin'
          }
        })
      })];
    }
  }]);
  return QuadbinTileLayer;
}(_core.CompositeLayer);

exports.default = QuadbinTileLayer;
(0, _defineProperty2.default)(QuadbinTileLayer, "layerName", 'QuadbinTileLayer');
(0, _defineProperty2.default)(QuadbinTileLayer, "defaultProps", defaultProps);
//# sourceMappingURL=quadbin-tile-layer.js.map