"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.quadbinToOffset = quadbinToOffset;
exports.quadbinToWorldBounds = quadbinToWorldBounds;
exports.getQuadbinPolygon = getQuadbinPolygon;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _webMercator = require("@math.gl/web-mercator");

var _quadbin = require("quadbin");

var TILE_SIZE = 512;

function quadbinToOffset(quadbin) {
  var _cellToTile = (0, _quadbin.cellToTile)(quadbin),
      x = _cellToTile.x,
      y = _cellToTile.y,
      z = _cellToTile.z;

  var scale = TILE_SIZE / (1 << z);
  return [x * scale, TILE_SIZE - y * scale, scale];
}

function quadbinToWorldBounds(quadbin, coverage) {
  var _quadbinToOffset = quadbinToOffset(quadbin),
      _quadbinToOffset2 = (0, _slicedToArray2.default)(_quadbinToOffset, 3),
      xOffset = _quadbinToOffset2[0],
      yOffset = _quadbinToOffset2[1],
      scale = _quadbinToOffset2[2];

  return [[xOffset, yOffset], [xOffset + coverage * scale, yOffset - coverage * scale]];
}

function getQuadbinPolygon(quadbin) {
  var coverage = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;

  var _quadbinToWorldBounds = quadbinToWorldBounds(quadbin, coverage),
      _quadbinToWorldBounds2 = (0, _slicedToArray2.default)(_quadbinToWorldBounds, 2),
      topLeft = _quadbinToWorldBounds2[0],
      bottomRight = _quadbinToWorldBounds2[1];

  var _worldToLngLat = (0, _webMercator.worldToLngLat)(topLeft),
      _worldToLngLat2 = (0, _slicedToArray2.default)(_worldToLngLat, 2),
      w = _worldToLngLat2[0],
      n = _worldToLngLat2[1];

  var _worldToLngLat3 = (0, _webMercator.worldToLngLat)(bottomRight),
      _worldToLngLat4 = (0, _slicedToArray2.default)(_worldToLngLat3, 2),
      e = _worldToLngLat4[0],
      s = _worldToLngLat4[1];

  return [e, n, e, s, w, s, w, n, e, n];
}
//# sourceMappingURL=quadbin-utils.js.map