"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = "#version 300 es\n#define SHADER_NAME raster-layer-vertex-shader\n\nin vec3 positions;\nin vec3 normals;\n\nin float instanceElevations;\nin vec4 instanceFillColors;\nin vec4 instanceLineColors;\n\nin vec3 instancePickingColors;\nuniform float opacity;\nuniform bool extruded;\nuniform bool stroked;\nuniform bool isStroke;\nuniform float coverage;\nuniform float elevationScale;\nuniform float widthScale;\nuniform vec3 offset;\nout vec4 vColor;\n#ifdef FLAT_SHADING\nout vec4 position_commonspace;\n#endif\n\nvoid main(void) {\n  vec2 common_position = offset.xy;\n  float scale = offset.z;\n\n  int yIndex = - (gl_InstanceID / 256);\n  int xIndex = gl_InstanceID + (yIndex * 256);\n  common_position += scale * vec2(float(xIndex), float(yIndex));\n\n  vec4 color = isStroke ? instanceLineColors : instanceFillColors;\n  float shouldRender = float(color.a > 0.0 && instanceElevations >= 0.0);\n  float cellWidth = coverage * scale;\n  geometry.position = vec4(common_position, 0.0, 1.0);\n  if (project_uProjectionMode == PROJECTION_MODE_WEB_MERCATOR_AUTO_OFFSET) {\n    geometry.position.xyz -= project_uCommonOrigin;\n  }\n  float elevation = 0.0;\n  float strokeOffsetRatio = 1.0;\n\n  if (extruded) {\n    elevation = instanceElevations * (positions.z + 1.0) / 2.0 * elevationScale;\n  } else if (stroked) {\n    float halfOffset = project_pixel_size(widthScale) / cellWidth;\n    if (isStroke) {\n      strokeOffsetRatio -= sign(positions.z) * halfOffset;\n    } else {\n      strokeOffsetRatio -= halfOffset;\n    }\n  }\n\n  geometry.pickingColor = instancePickingColors;\n  vec2 offset = (vec2(0.5) + positions.xy * strokeOffsetRatio) * cellWidth * shouldRender;\n  vec3 pos = vec3(offset, project_size(elevation));\n  DECKGL_FILTER_SIZE(pos, geometry);\n\n  geometry.position.xyz += pos;\n  gl_Position = project_common_position_to_clipspace(geometry.position);\n\n  geometry.normal = project_normal(normals);\n  DECKGL_FILTER_GL_POSITION(gl_Position, geometry);\n  if (extruded && !isStroke) {\n#ifdef FLAT_SHADING\n    position_commonspace = geometry.position;\n    vColor = vec4(color.rgb, color.a * opacity);\n#else\n    vec3 lightColor = lighting_getLightColor(color.rgb, project_uCameraPosition, geometry.position.xyz, geometry.normal);\n    vColor = vec4(lightColor, color.a * opacity);\n#endif\n  } else {\n    vColor = vec4(color.rgb, color.a * opacity);\n  }\n\n  DECKGL_FILTER_COLOR(vColor, geometry);\n}\n";
exports.default = _default;
//# sourceMappingURL=raster-layer-vertex.glsl.js.map