"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _layers = require("@deck.gl/layers");

var _quadbinUtils = require("./quadbin-utils");

var _rasterLayerVertex = _interopRequireDefault(require("./raster-layer-vertex.glsl"));

var _utils = require("../utils");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var defaultProps = _objectSpread(_objectSpread({}, _layers.ColumnLayer.defaultProps), {}, {
  extruded: false,
  diskResolution: 4,
  vertices: [[-0.5, -0.5], [0.5, -0.5], [0.5, 0.5], [-0.5, 0.5]]
});

var RasterColumnLayer = function (_ColumnLayer) {
  (0, _inherits2.default)(RasterColumnLayer, _ColumnLayer);

  var _super = _createSuper(RasterColumnLayer);

  function RasterColumnLayer() {
    (0, _classCallCheck2.default)(this, RasterColumnLayer);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(RasterColumnLayer, [{
    key: "getShaders",
    value: function getShaders() {
      var shaders = (0, _get2.default)((0, _getPrototypeOf2.default)(RasterColumnLayer.prototype), "getShaders", this).call(this);
      return _objectSpread(_objectSpread({}, shaders), {}, {
        vs: _rasterLayerVertex.default
      });
    }
  }, {
    key: "initializeState",
    value: function initializeState() {
      var attributeManager = this.getAttributeManager();
      attributeManager.addInstanced({
        instanceElevations: {
          size: 1,
          transition: true,
          accessor: 'getElevation'
        },
        instanceFillColors: {
          size: this.props.colorFormat.length,
          type: 5121,
          normalized: true,
          transition: true,
          accessor: 'getFillColor',
          defaultValue: [0, 0, 0, 255]
        },
        instanceLineColors: {
          size: this.props.colorFormat.length,
          type: 5121,
          normalized: true,
          transition: true,
          accessor: 'getLineColor',
          defaultValue: [255, 255, 255, 255]
        }
      });
    }
  }]);
  return RasterColumnLayer;
}(_layers.ColumnLayer);

(0, _defineProperty2.default)(RasterColumnLayer, "layerName", 'RasterColumnLayer');

var RasterLayer = function (_CompositeLayer) {
  (0, _inherits2.default)(RasterLayer, _CompositeLayer);

  var _super2 = _createSuper(RasterLayer);

  function RasterLayer() {
    (0, _classCallCheck2.default)(this, RasterLayer);
    return _super2.apply(this, arguments);
  }

  (0, _createClass2.default)(RasterLayer, [{
    key: "renderLayers",
    value: function renderLayers() {
      var _this$props = this.props,
          data = _this$props.data,
          getElevation = _this$props.getElevation,
          getFillColor = _this$props.getFillColor,
          getLineColor = _this$props.getLineColor,
          getLineWidth = _this$props.getLineWidth,
          tileIndex = _this$props.tileIndex,
          updateTriggers = _this$props.updateTriggers;
      if (!data || !tileIndex) return null;
      var _ref = data,
          blockWidth = _ref.blockWidth,
          blockHeight = _ref.blockHeight;
      (0, _utils.assert)(blockWidth === blockHeight, "blockWidth (".concat(blockWidth, ") must equal blockHeight (").concat(blockHeight, ")"));

      var _quadbinToOffset = (0, _quadbinUtils.quadbinToOffset)(tileIndex),
          _quadbinToOffset2 = (0, _slicedToArray2.default)(_quadbinToOffset, 3),
          xOffset = _quadbinToOffset2[0],
          yOffset = _quadbinToOffset2[1],
          scale = _quadbinToOffset2[2];

      var offset = [xOffset, yOffset, scale / blockWidth];
      var CellLayer = this.getSubLayerClass('column', RasterColumnLayer);
      return new CellLayer(this.props, this.getSubLayerProps({
        id: 'cell',
        updateTriggers: updateTriggers,
        getElevation: this.getSubLayerAccessor(getElevation),
        getFillColor: this.getSubLayerAccessor(getFillColor),
        getLineColor: this.getSubLayerAccessor(getLineColor),
        getLineWidth: this.getSubLayerAccessor(getLineWidth)
      }), {
        data: {
          data: data,
          length: blockWidth * blockHeight
        },
        offset: offset
      });
    }
  }, {
    key: "getSubLayerAccessor",
    value: function getSubLayerAccessor(accessor) {
      if (typeof accessor !== 'function') {
        return (0, _get2.default)((0, _getPrototypeOf2.default)(RasterLayer.prototype), "getSubLayerAccessor", this).call(this, accessor);
      }

      return function (object, info) {
        var data = info.data,
            index = info.index;
        var binaryData = data.data;
        var proxy = (0, _utils.createBinaryProxy)(binaryData.cells, index);
        return accessor({
          properties: proxy
        }, info);
      };
    }
  }]);
  return RasterLayer;
}(_core.CompositeLayer);

exports.default = RasterLayer;
(0, _defineProperty2.default)(RasterLayer, "layerName", 'RasterLayer');
(0, _defineProperty2.default)(RasterLayer, "defaultProps", defaultProps);
//# sourceMappingURL=raster-layer.js.map