"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.renderSubLayers = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _rasterLayer = _interopRequireDefault(require("./raster-layer"));

var _quadbinTileset2d = _interopRequireDefault(require("./quadbin-tileset-2d"));

var _spatialIndexTileLayer = _interopRequireDefault(require("./spatial-index-tile-layer"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var renderSubLayers = function renderSubLayers(props) {
  var _props$tile, _props$tile$index;

  var tileIndex = (_props$tile = props.tile) === null || _props$tile === void 0 ? void 0 : (_props$tile$index = _props$tile.index) === null || _props$tile$index === void 0 ? void 0 : _props$tile$index.q;
  if (!tileIndex) return null;
  return new _rasterLayer.default(props, {
    tileIndex: tileIndex
  });
};

exports.renderSubLayers = renderSubLayers;

var RasterTileLayer = function (_CompositeLayer) {
  (0, _inherits2.default)(RasterTileLayer, _CompositeLayer);

  var _super = _createSuper(RasterTileLayer);

  function RasterTileLayer() {
    var _this;

    (0, _classCallCheck2.default)(this, RasterTileLayer);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", void 0);
    return _this;
  }

  (0, _createClass2.default)(RasterTileLayer, [{
    key: "initializeState",
    value: function initializeState() {
      this.setState({
        data: null,
        tileJSON: null
      });
    }
  }, {
    key: "updateState",
    value: function updateState(_ref) {
      var changeFlags = _ref.changeFlags;

      if (changeFlags.dataChanged) {
        var data = this.props.data;
        var tileJSON = data;
        data = tileJSON.tiles;
        this.setState({
          data: data,
          tileJSON: tileJSON
        });
      }
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      var _this$state = this.state,
          data = _this$state.data,
          tileJSON = _this$state.tileJSON;
      var minZoom = parseInt(tileJSON === null || tileJSON === void 0 ? void 0 : tileJSON.minzoom);
      var maxZoom = parseInt(tileJSON === null || tileJSON === void 0 ? void 0 : tileJSON.maxzoom);
      return [new _spatialIndexTileLayer.default(this.props, {
        id: "raster-tile-layer-".concat(this.props.id),
        data: data,
        TilesetClass: _quadbinTileset2d.default,
        renderSubLayers: renderSubLayers,
        minZoom: minZoom,
        maxZoom: maxZoom
      })];
    }
  }]);
  return RasterTileLayer;
}(_core.CompositeLayer);

exports.default = RasterTileLayer;
(0, _defineProperty2.default)(RasterTileLayer, "layerName", 'RasterTileLayer');
(0, _defineProperty2.default)(RasterTileLayer, "defaultProps", {});
//# sourceMappingURL=raster-tile-layer.js.map