"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _cartoRasterTile = require("./carto-raster-tile");

var _tileLoaderUtils = require("./tile-loader-utils");

var _utils = require("../../utils");

var VERSION = typeof "8.9.36" !== 'undefined' ? "8.9.36" : 'latest';
var id = 'cartoRasterTile';
var DEFAULT_OPTIONS = {
  cartoRasterTile: {
    workerUrl: (0, _utils.getWorkerUrl)(id, VERSION)
  }
};
var CartoRasterTileLoader = {
  name: 'CARTO Raster Tile',
  version: VERSION,
  id: id,
  module: 'carto',
  extensions: ['pbf'],
  mimeTypes: ['application/vnd.carto-raster-tile'],
  category: 'geometry',
  parse: function () {
    var _parse = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee(arrayBuffer, options) {
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              return _context.abrupt("return", parseCartoRasterTile(arrayBuffer, options));

            case 1:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    function parse(_x, _x2) {
      return _parse.apply(this, arguments);
    }

    return parse;
  }(),
  parseSync: parseCartoRasterTile,
  worker: true,
  options: DEFAULT_OPTIONS
};

function parseCartoRasterTile(arrayBuffer, options) {
  if (!arrayBuffer) return null;
  var tile = (0, _tileLoaderUtils.parsePbf)(arrayBuffer, _cartoRasterTile.TileReader);
  var bands = tile.bands,
      blockHeight = tile.blockHeight,
      blockWidth = tile.blockWidth;
  var numericProps = {};

  for (var i = 0; i < bands.length; i++) {
    var _bands$i = bands[i],
        name = _bands$i.name,
        data = _bands$i.data;
    numericProps[name] = data;
  }

  return {
    blockWidth: blockWidth,
    blockHeight: blockHeight,
    cells: {
      numericProps: numericProps,
      properties: []
    }
  };
}

var _default = CartoRasterTileLoader;
exports.default = _default;
//# sourceMappingURL=carto-raster-tile-loader.js.map