"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TileReader = exports.BandReader = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _fastPbf = require("./fast-pbf");

var ARRAY_TYPES = {
  uint8: Uint8Array,
  uint16: Uint16Array,
  uint32: Uint32Array,
  uint64: BigUint64Array,
  int8: Int8Array,
  int16: Int16Array,
  int32: Int32Array,
  int64: BigInt64Array,
  float32: Float32Array,
  float64: Float64Array
};

var BandReader = function () {
  function BandReader() {
    (0, _classCallCheck2.default)(this, BandReader);
  }

  (0, _createClass2.default)(BandReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(BandReader._readField, {
        name: '',
        type: '',
        data: null
      }, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) obj.name = pbf.readString();else if (tag === 2) obj.type = pbf.readString();else if (tag === 3) {
        var TypedArray = ARRAY_TYPES[obj.type];

        if (!TypedArray) {
          throw Error("Invalid data type: ".concat(obj.type));
        }

        obj.data = {};
        (0, _fastPbf.readPackedTypedArray)(TypedArray, pbf, obj.data);
      }
    }
  }]);
  return BandReader;
}();

exports.BandReader = BandReader;

var TileReader = function () {
  function TileReader() {
    (0, _classCallCheck2.default)(this, TileReader);
  }

  (0, _createClass2.default)(TileReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(TileReader._readField, {
        blockWidth: 0,
        blockHeight: 0,
        bands: []
      }, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) obj.blockWidth = pbf.readVarint();else if (tag === 2) obj.blockHeight = pbf.readVarint();else if (tag === 3) obj.bands.push(BandReader.read(pbf, pbf.readVarint() + pbf.pos));
    }
  }]);
  return TileReader;
}();

exports.TileReader = TileReader;
//# sourceMappingURL=carto-raster-tile.js.map