"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _cartoSpatialTile = require("./carto-spatial-tile");

var _tileLoaderUtils = require("./tile-loader-utils");

var _utils = require("../../utils");

var _spatialjsonUtils = require("./spatialjson-utils");

var VERSION = typeof "8.9.36" !== 'undefined' ? "8.9.36" : 'latest';
var id = 'cartoSpatialTile';
var DEFAULT_OPTIONS = {
  cartoSpatialTile: {
    scheme: 'quadbin',
    workerUrl: (0, _utils.getWorkerUrl)(id, VERSION)
  }
};
var CartoSpatialTileLoader = {
  name: 'CARTO Spatial Tile',
  version: VERSION,
  id: id,
  module: 'carto',
  extensions: ['pbf'],
  mimeTypes: ['application/vnd.carto-spatial-tile'],
  category: 'geometry',
  parse: function () {
    var _parse = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee(arrayBuffer, options) {
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              return _context.abrupt("return", parseCartoSpatialTile(arrayBuffer, options));

            case 1:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    function parse(_x, _x2) {
      return _parse.apply(this, arguments);
    }

    return parse;
  }(),
  parseSync: parseCartoSpatialTile,
  worker: true,
  options: DEFAULT_OPTIONS
};

function parseCartoSpatialTile(arrayBuffer, options) {
  var _options$cartoSpatial;

  if (!arrayBuffer) return null;
  var tile = (0, _tileLoaderUtils.parsePbf)(arrayBuffer, _cartoSpatialTile.TileReader);
  var cells = tile.cells;
  var scheme = options === null || options === void 0 ? void 0 : (_options$cartoSpatial = options.cartoSpatialTile) === null || _options$cartoSpatial === void 0 ? void 0 : _options$cartoSpatial.scheme;
  var data = {
    cells: cells,
    scheme: scheme
  };
  return (0, _spatialjsonUtils.binaryToSpatialjson)(data);
}

var _default = CartoSpatialTileLoader;
exports.default = _default;
//# sourceMappingURL=carto-spatial-tile-loader.js.map