"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TileReader = exports.IndicesReader = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _fastPbf = require("./fast-pbf");

var _cartoTile = require("./carto-tile");

var IndicesReader = function () {
  function IndicesReader() {
    (0, _classCallCheck2.default)(this, IndicesReader);
  }

  (0, _createClass2.default)(IndicesReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(IndicesReader._readField, {
        value: []
      }, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) (0, _fastPbf.readPackedTypedArray)(BigUint64Array, pbf, obj);
    }
  }]);
  return IndicesReader;
}();

exports.IndicesReader = IndicesReader;

var CellsReader = function () {
  function CellsReader() {
    (0, _classCallCheck2.default)(this, CellsReader);
  }

  (0, _createClass2.default)(CellsReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(CellsReader._readField, {
        indices: null,
        properties: [],
        numericProps: {}
      }, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) obj.indices = IndicesReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 2) obj.properties.push(_cartoTile.PropertiesReader.read(pbf, pbf.readVarint() + pbf.pos));else if (tag === 3) {
        var entry = _cartoTile.NumericPropKeyValueReader.read(pbf, pbf.readVarint() + pbf.pos);

        obj.numericProps[entry.key] = entry.value;
      }
    }
  }]);
  return CellsReader;
}();

var TileReader = function () {
  function TileReader() {
    (0, _classCallCheck2.default)(this, TileReader);
  }

  (0, _createClass2.default)(TileReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(TileReader._readField, {
        scheme: 0,
        cells: null
      }, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) obj.scheme = pbf.readVarint();else if (tag === 2) obj.cells = CellsReader.read(pbf, pbf.readVarint() + pbf.pos);
    }
  }]);
  return TileReader;
}();

exports.TileReader = TileReader;
//# sourceMappingURL=carto-spatial-tile.js.map