"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TileReader = exports.NumericPropKeyValueReader = exports.PropertiesReader = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _fastPbf = require("./fast-pbf");

var KeyValueObjectReader = function () {
  function KeyValueObjectReader() {
    (0, _classCallCheck2.default)(this, KeyValueObjectReader);
  }

  (0, _createClass2.default)(KeyValueObjectReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(KeyValueObjectReader._readField, {
        key: '',
        value: null
      }, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) obj.key = pbf.readString();else if (tag === 2) obj.value = pbf.readString();
    }
  }]);
  return KeyValueObjectReader;
}();

var PropertiesReader = function () {
  function PropertiesReader() {
    (0, _classCallCheck2.default)(this, PropertiesReader);
  }

  (0, _createClass2.default)(PropertiesReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(PropertiesReader._readField, {}, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) {
        var _KeyValueObjectReader = KeyValueObjectReader.read(pbf, pbf.readVarint() + pbf.pos),
            key = _KeyValueObjectReader.key,
            value = _KeyValueObjectReader.value;

        obj[key] = value;
      }
    }
  }]);
  return PropertiesReader;
}();

exports.PropertiesReader = PropertiesReader;

var DoublesReader = function () {
  function DoublesReader() {
    (0, _classCallCheck2.default)(this, DoublesReader);
  }

  (0, _createClass2.default)(DoublesReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      var _pbf$readFields = pbf.readFields(DoublesReader._readField, {
        value: [],
        size: 0
      }, end),
          value = _pbf$readFields.value,
          size = _pbf$readFields.size;

      return {
        value: new Float32Array(value),
        size: size
      };
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) (0, _fastPbf.readPackedTypedArray)(Float64Array, pbf, obj);else if (tag === 2) obj.size = pbf.readVarint(true);
    }
  }]);
  return DoublesReader;
}();

var IntsReader = function () {
  function IntsReader() {
    (0, _classCallCheck2.default)(this, IntsReader);
  }

  (0, _createClass2.default)(IntsReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      var _pbf$readFields2 = pbf.readFields(IntsReader._readField, {
        value: [],
        size: 0
      }, end),
          value = _pbf$readFields2.value,
          size = _pbf$readFields2.size;

      return {
        value: new Uint32Array(value),
        size: size
      };
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) pbf.readPackedVarint(obj.value);else if (tag === 2) obj.size = pbf.readVarint(true);
    }
  }]);
  return IntsReader;
}();

var FieldsReader = function () {
  function FieldsReader() {
    (0, _classCallCheck2.default)(this, FieldsReader);
  }

  (0, _createClass2.default)(FieldsReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(FieldsReader._readField, {
        id: 0
      }, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) obj.id = pbf.readVarint();
    }
  }]);
  return FieldsReader;
}();

var NumericPropReader = function () {
  function NumericPropReader() {
    (0, _classCallCheck2.default)(this, NumericPropReader);
  }

  (0, _createClass2.default)(NumericPropReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(NumericPropReader._readField, {
        value: []
      }, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) (0, _fastPbf.readPackedTypedArray)(Float64Array, pbf, obj);
    }
  }]);
  return NumericPropReader;
}();

var NumericPropKeyValueReader = function () {
  function NumericPropKeyValueReader() {
    (0, _classCallCheck2.default)(this, NumericPropKeyValueReader);
  }

  (0, _createClass2.default)(NumericPropKeyValueReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(NumericPropKeyValueReader._readField, {
        key: '',
        value: null
      }, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) obj.key = pbf.readString();else if (tag === 2) obj.value = NumericPropReader.read(pbf, pbf.readVarint() + pbf.pos);
    }
  }]);
  return NumericPropKeyValueReader;
}();

exports.NumericPropKeyValueReader = NumericPropKeyValueReader;

var PointsReader = function () {
  function PointsReader() {
    (0, _classCallCheck2.default)(this, PointsReader);
  }

  (0, _createClass2.default)(PointsReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(PointsReader._readField, {
        positions: null,
        globalFeatureIds: null,
        featureIds: null,
        properties: [],
        numericProps: {},
        fields: []
      }, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) obj.positions = DoublesReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 2) obj.globalFeatureIds = IntsReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 3) obj.featureIds = IntsReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 4) obj.properties.push(PropertiesReader.read(pbf, pbf.readVarint() + pbf.pos));else if (tag === 5) {
        var entry = NumericPropKeyValueReader.read(pbf, pbf.readVarint() + pbf.pos);
        obj.numericProps[entry.key] = entry.value;
      } else if (tag === 6) obj.fields.push(FieldsReader.read(pbf, pbf.readVarint() + pbf.pos));
    }
  }]);
  return PointsReader;
}();

var LinesReader = function () {
  function LinesReader() {
    (0, _classCallCheck2.default)(this, LinesReader);
  }

  (0, _createClass2.default)(LinesReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(LinesReader._readField, {
        positions: null,
        pathIndices: null,
        globalFeatureIds: null,
        featureIds: null,
        properties: [],
        numericProps: {},
        fields: []
      }, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) obj.positions = DoublesReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 2) obj.pathIndices = IntsReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 3) obj.globalFeatureIds = IntsReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 4) obj.featureIds = IntsReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 5) obj.properties.push(PropertiesReader.read(pbf, pbf.readVarint() + pbf.pos));else if (tag === 6) {
        var entry = NumericPropKeyValueReader.read(pbf, pbf.readVarint() + pbf.pos);
        obj.numericProps[entry.key] = entry.value;
      } else if (tag === 7) obj.fields.push(FieldsReader.read(pbf, pbf.readVarint() + pbf.pos));
    }
  }]);
  return LinesReader;
}();

var PolygonsReader = function () {
  function PolygonsReader() {
    (0, _classCallCheck2.default)(this, PolygonsReader);
  }

  (0, _createClass2.default)(PolygonsReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(PolygonsReader._readField, {
        positions: null,
        polygonIndices: null,
        globalFeatureIds: null,
        featureIds: null,
        primitivePolygonIndices: null,
        triangles: null,
        properties: [],
        numericProps: {},
        fields: []
      }, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) obj.positions = DoublesReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 2) obj.polygonIndices = IntsReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 3) obj.globalFeatureIds = IntsReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 4) obj.featureIds = IntsReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 5) obj.primitivePolygonIndices = IntsReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 6) obj.triangles = IntsReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 7) obj.properties.push(PropertiesReader.read(pbf, pbf.readVarint() + pbf.pos));else if (tag === 8) {
        var entry = NumericPropKeyValueReader.read(pbf, pbf.readVarint() + pbf.pos);
        obj.numericProps[entry.key] = entry.value;
      } else if (tag === 9) obj.fields.push(FieldsReader.read(pbf, pbf.readVarint() + pbf.pos));
    }
  }]);
  return PolygonsReader;
}();

var TileReader = function () {
  function TileReader() {
    (0, _classCallCheck2.default)(this, TileReader);
  }

  (0, _createClass2.default)(TileReader, null, [{
    key: "read",
    value: function read(pbf, end) {
      return pbf.readFields(TileReader._readField, {
        points: null,
        lines: null,
        polygons: null
      }, end);
    }
  }, {
    key: "_readField",
    value: function _readField(tag, obj, pbf) {
      if (tag === 1) obj.points = PointsReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 2) obj.lines = LinesReader.read(pbf, pbf.readVarint() + pbf.pos);else if (tag === 3) obj.polygons = PolygonsReader.read(pbf, pbf.readVarint() + pbf.pos);
    }
  }]);
  return TileReader;
}();

exports.TileReader = TileReader;
//# sourceMappingURL=carto-tile.js.map