"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _earcut = _interopRequireDefault(require("earcut"));

var _cartoTile = require("./carto-tile");

var _tileLoaderUtils = require("./tile-loader-utils");

var _utils = require("../../utils");

var VERSION = typeof "8.9.36" !== 'undefined' ? "8.9.36" : 'latest';
var id = 'cartoVectorTile';
var DEFAULT_OPTIONS = {
  cartoVectorTile: {
    workerUrl: (0, _utils.getWorkerUrl)(id, VERSION)
  }
};
var CartoVectorTileLoader = {
  name: 'CARTO Vector Tile',
  version: VERSION,
  id: id,
  module: 'carto',
  extensions: ['pbf'],
  mimeTypes: ['application/vnd.carto-vector-tile'],
  category: 'geometry',
  parse: function () {
    var _parse = (0, _asyncToGenerator2.default)(_regenerator.default.mark(function _callee(arrayBuffer, options) {
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              return _context.abrupt("return", parseCartoVectorTile(arrayBuffer, options));

            case 1:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    function parse(_x, _x2) {
      return _parse.apply(this, arguments);
    }

    return parse;
  }(),
  parseSync: parseCartoVectorTile,
  worker: true,
  options: DEFAULT_OPTIONS
};

function triangulatePolygon(polygons, target, _ref) {
  var startPosition = _ref.startPosition,
      endPosition = _ref.endPosition,
      indices = _ref.indices;
  var coordLength = polygons.positions.size;
  var start = startPosition * coordLength;
  var end = endPosition * coordLength;
  var polygonPositions = polygons.positions.value.subarray(start, end);
  var holes = indices.slice(1).map(function (n) {
    return n - startPosition;
  });
  var triangles = (0, _earcut.default)(polygonPositions, holes, coordLength);

  for (var t = 0, tl = triangles.length; t < tl; ++t) {
    target.push(startPosition + triangles[t]);
  }
}

function triangulate(polygons) {
  var polygonIndices = polygons.polygonIndices,
      positions = polygons.positions,
      primitivePolygonIndices = polygons.primitivePolygonIndices;
  var triangles = [];
  var rangeStart = 0;

  for (var i = 0; i < polygonIndices.value.length - 1; i++) {
    var startPosition = polygonIndices.value[i];
    var endPosition = polygonIndices.value[i + 1];
    var rangeEnd = primitivePolygonIndices.value.indexOf(endPosition);
    var indices = primitivePolygonIndices.value.subarray(rangeStart, rangeEnd);
    rangeStart = rangeEnd;
    triangulatePolygon(polygons, triangles, {
      startPosition: startPosition,
      endPosition: endPosition,
      indices: indices
    });
  }

  polygons.triangles = {
    value: new Uint32Array(triangles),
    size: 1
  };
}

function parseCartoVectorTile(arrayBuffer, options) {
  if (!arrayBuffer) return null;
  var tile = (0, _tileLoaderUtils.parsePbf)(arrayBuffer, _cartoTile.TileReader);

  if (tile.polygons && !tile.polygons.triangles) {
    triangulate(tile.polygons);
  }

  return tile;
}

var _default = CartoVectorTileLoader;
exports.default = _default;
//# sourceMappingURL=carto-vector-tile-loader.js.map