"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.binaryToSpatialjson = binaryToSpatialjson;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _quadbin = require("quadbin");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function binaryToSpatialjson(binary) {
  var cells = binary.cells,
      scheme = binary.scheme;
  var count = cells.indices.value.length;
  var spatial = [];

  for (var i = 0; i < count; i++) {
    var id = scheme === 'h3' ? (0, _quadbin.bigIntToHex)(cells.indices.value[i]) : cells.indices.value[i];

    var properties = _objectSpread({}, cells.properties[i]);

    for (var _i = 0, _Object$keys = Object.keys(cells.numericProps); _i < _Object$keys.length; _i++) {
      var key = _Object$keys[_i];
      properties[key] = cells.numericProps[key].value[i];
    }

    spatial.push({
      id: id,
      properties: properties
    });
  }

  return spatial;
}
//# sourceMappingURL=spatialjson-utils.js.map