"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@loaders.gl/core");

var _cartoRasterTileLoader = _interopRequireDefault(require("./schema/carto-raster-tile-loader"));

var _cartoSpatialTileLoader = _interopRequireDefault(require("./schema/carto-spatial-tile-loader"));

var _geoLayers = require("@deck.gl/geo-layers");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

(0, _core.registerLoaders)([_cartoRasterTileLoader.default, _cartoSpatialTileLoader.default]);

function isFeatureIdDefined(value) {
  return value !== undefined && value !== null && value !== '';
}

var defaultProps = {
  aggregationResLevel: 4
};

var SpatialIndexTileLayer = function (_TileLayer) {
  (0, _inherits2.default)(SpatialIndexTileLayer, _TileLayer);

  var _super = _createSuper(SpatialIndexTileLayer);

  function SpatialIndexTileLayer() {
    var _this;

    (0, _classCallCheck2.default)(this, SpatialIndexTileLayer);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", void 0);
    return _this;
  }

  (0, _createClass2.default)(SpatialIndexTileLayer, [{
    key: "updateState",
    value: function updateState(params) {
      var props = params.props,
          oldProps = params.oldProps;

      if (props.aggregationResLevel !== oldProps.aggregationResLevel) {
        this.setState({
          tileset: null
        });
      }

      (0, _get2.default)((0, _getPrototypeOf2.default)(SpatialIndexTileLayer.prototype), "updateState", this).call(this, params);
    }
  }, {
    key: "_updateAutoHighlight",
    value: function _updateAutoHighlight(info) {
      var hoveredFeatureId = this.state.hoveredFeatureId;
      var hoveredFeature = info.object;
      var newHoveredFeatureId = null;

      if (hoveredFeature) {
        newHoveredFeatureId = hoveredFeature.id;
      }

      if (hoveredFeatureId !== newHoveredFeatureId) {
        var highlightColor = this.props.highlightColor;

        if (typeof highlightColor === 'function') {
          highlightColor = highlightColor(info);
        }

        this.setState({
          highlightColor: highlightColor,
          hoveredFeatureId: newHoveredFeatureId
        });
      }
    }
  }, {
    key: "getSubLayerPropsByTile",
    value: function getSubLayerPropsByTile(tile) {
      return {
        highlightedObjectIndex: this.getHighlightedObjectIndex(tile),
        highlightColor: this.state.highlightColor
      };
    }
  }, {
    key: "getHighlightedObjectIndex",
    value: function getHighlightedObjectIndex(tile) {
      var hoveredFeatureId = this.state.hoveredFeatureId;
      var data = tile.content;
      var isFeatureIdPresent = isFeatureIdDefined(hoveredFeatureId);

      if (!isFeatureIdPresent || !Array.isArray(data) || !this._featureInTile(tile, hoveredFeatureId)) {
        return -1;
      }

      return data.findIndex(function (feature) {
        return feature.id === hoveredFeatureId;
      });
    }
  }, {
    key: "_featureInTile",
    value: function _featureInTile(tile, featureId) {
      var tileset = this.state.tileset;
      var tileZoom = tileset.getTileZoom(tile.index);
      var KEY = tile.index.q ? 'q' : 'i';
      var featureIndex = (0, _defineProperty2.default)({}, KEY, featureId);
      var featureZoom = tileset.getTileZoom(featureIndex);

      while (!(featureZoom <= tileZoom)) {
        featureIndex = tileset.getParentIndex(featureIndex);
        featureZoom = tileset.getTileZoom(featureIndex);
      }

      return featureIndex[KEY] === tile.index[KEY];
    }
  }]);
  return SpatialIndexTileLayer;
}(_geoLayers.TileLayer);

exports.default = SpatialIndexTileLayer;
(0, _defineProperty2.default)(SpatialIndexTileLayer, "layerName", 'SpatialIndexTileLayer');
(0, _defineProperty2.default)(SpatialIndexTileLayer, "defaultProps", defaultProps);
//# sourceMappingURL=spatial-index-tile-layer.js.map