"use strict";

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = colorContinuous;

var _d3Scale = require("d3-scale");

var _palette = _interopRequireWildcard(require("./palette"));

var _utils = require("./utils");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function colorContinuous(_ref) {
  var attr = _ref.attr,
      domain = _ref.domain,
      _ref$colors = _ref.colors,
      colors = _ref$colors === void 0 ? _palette.DEFAULT_PALETTE : _ref$colors,
      _ref$nullColor = _ref.nullColor,
      nullColor = _ref$nullColor === void 0 ? _palette.NULL_COLOR : _ref$nullColor;
  (0, _utils.assert)(Array.isArray(domain), 'Expected "domain" to be an array of numbers');
  var palette = typeof colors === 'string' ? (0, _palette.default)(colors, domain.length) : colors;
  var color = (0, _d3Scale.scaleLinear)().domain(domain).range(palette);
  return function (d) {
    var value = (0, _utils.getAttrValue)(attr, d);
    return typeof value === 'number' && Number.isFinite(value) ? color(value) : nullColor;
  };
}
//# sourceMappingURL=color-continuous-style.js.map