"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getPalette;
exports.hexToRgb = hexToRgb;
exports.OTHERS_COLOR = exports.NULL_COLOR = exports.DEFAULT_PALETTE = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var cartoColors = _interopRequireWildcard(require("cartocolor"));

var _utils = require("./utils");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var DEFAULT_PALETTE = 'PurpOr';
exports.DEFAULT_PALETTE = DEFAULT_PALETTE;
var NULL_COLOR = [204, 204, 204];
exports.NULL_COLOR = NULL_COLOR;
var OTHERS_COLOR = [119, 119, 119];
exports.OTHERS_COLOR = OTHERS_COLOR;

function getPalette(name, numCategories) {
  var palette = cartoColors[name];
  var paletteIndex = numCategories;
  (0, _utils.assert)(palette, "Palette \"".concat(name, "\" not found. Expected a CARTOColors string"));
  var palettesColorVariants = Object.keys(palette).filter(function (p) {
    return p !== 'tags';
  }).map(Number);
  var longestPaletteIndex = Math.max.apply(Math, (0, _toConsumableArray2.default)(palettesColorVariants));
  var smallestPaletteIndex = Math.min.apply(Math, (0, _toConsumableArray2.default)(palettesColorVariants));

  if (!Number.isInteger(numCategories) || numCategories > longestPaletteIndex) {
    paletteIndex = longestPaletteIndex;
  } else if (numCategories < smallestPaletteIndex) {
    paletteIndex = smallestPaletteIndex;
  }

  var colors = palette[paletteIndex];

  if (palette.tags && palette.tags.includes('qualitative')) {
    colors = colors.slice(0, -1);
  }

  return colors.map(function (c) {
    return hexToRgb(c);
  });
}

function hexToRgb(hex) {
  var result = /^#?([a-f\d]{1})([a-f\d]{1})([a-f\d]{1})$/i.exec(hex);

  if (result) {
    return [parseInt(result[1] + result[1], 16), parseInt(result[2] + result[2], 16), parseInt(result[3] + result[3], 16), 255];
  }

  result = /^#?([a-f\d]{1})([a-f\d]{1})([a-f\d]{1})([a-f\d]{1})$/i.exec(hex);

  if (result) {
    return [parseInt(result[1] + result[1], 16), parseInt(result[2] + result[2], 16), parseInt(result[3] + result[3], 16), parseInt(result[4] + result[4], 16)];
  }

  result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);

  if (result) {
    return [parseInt(result[1], 16), parseInt(result[2], 16), parseInt(result[3], 16), 255];
  }

  result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
  (0, _utils.assert)(result, "Hexadecimal color \"".concat(hex, "\" was not parsed correctly"));
  return [parseInt(result[1], 16), parseInt(result[2], 16), parseInt(result[3], 16), parseInt(result[4], 16)];
}
//# sourceMappingURL=palette.js.map