"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttrValue = getAttrValue;
exports.assert = assert;

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var ALLOWED_ATTR_TYPES = Object.freeze(['function', 'string']);

function getAttrValue(attr, d) {
  var _properties;

  assert((0, _typeof2.default)(d) === 'object', 'Expected "data" to be an object');
  assert(ALLOWED_ATTR_TYPES.includes((0, _typeof2.default)(attr)), 'Expected "attr" to be a function or string');

  if (typeof attr === 'function') {
    return attr(d);
  }

  return d === null || d === void 0 ? void 0 : (_properties = d.properties) === null || _properties === void 0 ? void 0 : _properties[attr];
}

function assert(condition) {
  var message = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';

  if (!condition) {
    throw new Error("CARTO style error: ".concat(message));
  }
}
//# sourceMappingURL=utils.js.map