"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assert = assert;
exports.createBinaryProxy = createBinaryProxy;
exports.getWorkerUrl = getWorkerUrl;
exports.scaleIdentity = scaleIdentity;

var _core = require("@deck.gl/core");

function assert(condition, message) {
  _core.log.assert(condition, message);
}

function createBinaryProxy(data, index) {
  var properties = data.properties,
      numericProps = data.numericProps;
  return new Proxy(properties[index] || {}, {
    get: function get(target, property, receiver) {
      if (property in numericProps) {
        return numericProps[property].value[index];
      }

      return target[property];
    },
    has: function has(target, property) {
      return property in numericProps || property in target;
    }
  });
}

function getWorkerUrl(id, version) {
  return "https://unpkg.com/@deck.gl/carto@".concat(version, "/dist/").concat(id, "-worker.js");
}

function scaleIdentity() {
  var unknown;

  function scale(x) {
    return x === null ? unknown : x;
  }

  scale.invert = scale;

  scale.domain = scale.range = function (d) {
    return d;
  };

  scale.unknown = function (u) {
    if (u) {
      unknown = u;
    }

    return unknown;
  };

  scale.copy = function () {
    return scaleIdentity().unknown(unknown);
  };

  return scale;
}
//# sourceMappingURL=utils.js.map