import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
export class CartoAPIError extends Error {
  constructor(error, errorContext, response) {
    let responseString = 'Failed to connect';

    if (response) {
      responseString = 'Server returned: ';

      if (response.status === 400) {
        responseString += 'Bad request';
      } else if (response.status === 401 || response.status === 403) {
        responseString += 'Unauthorized access';
      } else if (response.status === 404) {
        responseString += 'Not found';
      } else {
        responseString += 'Error';
      }

      responseString += " (".concat(response.status, "):");
    }

    responseString += " ".concat(error.message || error);
    let message = "".concat(errorContext.requestType, " API request failed");
    message += "\n".concat(responseString);

    for (const key of Object.keys(errorContext)) {
      if (key === 'requestType') continue;
      message += "\n".concat(formatErrorKey(key), ": ").concat(errorContext[key]);
    }

    message += '\n';
    super(message);

    _defineProperty(this, "error", void 0);

    _defineProperty(this, "errorContext", void 0);

    _defineProperty(this, "response", void 0);

    this.name = 'CartoAPIError';
    this.response = response;
    this.error = error;
    this.errorContext = errorContext;
  }

}

function formatErrorKey(key) {
  return key.replace(/([A-Z])/g, ' $1').replace(/^./, s => s.toUpperCase());
}
//# sourceMappingURL=carto-api-error.js.map