export const DEFAULT_USER_COMPONENT_IN_URL = '{user}';
export const DEFAULT_REGION_COMPONENT_IN_URL = '{region}';
export const API_VERSIONS = {
  V1: 'v1',
  V2: 'v2',
  V3: 'v3'
};
export const DEFAULT_MAPS_URL_FORMAT = {
  [API_VERSIONS.V1]: "https://".concat(DEFAULT_USER_COMPONENT_IN_URL, ".carto.com/api/v1/map"),
  [API_VERSIONS.V2]: "https://maps-api-v2.".concat(DEFAULT_REGION_COMPONENT_IN_URL, ".carto.com/user/").concat(DEFAULT_USER_COMPONENT_IN_URL)
};
export const MAP_TYPES = {
  QUERY: 'query',
  TABLE: 'table',
  TILESET: 'tileset',
  RASTER: 'raster'
};
export const COLUMNS_SUPPORT = [MAP_TYPES.QUERY, MAP_TYPES.TABLE];
export const GEO_COLUMN_SUPPORT = [MAP_TYPES.QUERY, MAP_TYPES.TABLE];
export const FORMATS = {
  GEOJSON: 'geojson',
  NDJSON: 'ndjson',
  TILEJSON: 'tilejson',
  JSON: 'json'
};
export const TILE_FORMATS = {
  MVT: 'mvt',
  JSON: 'json',
  GEOJSON: 'geojson',
  BINARY: 'binary'
};
export let SchemaFieldType;

(function (SchemaFieldType) {
  SchemaFieldType["Number"] = "number";
  SchemaFieldType["Bigint"] = "bigint";
  SchemaFieldType["String"] = "string";
  SchemaFieldType["Geometry"] = "geometry";
  SchemaFieldType["Timestamp"] = "timestamp";
  SchemaFieldType["Object"] = "object";
  SchemaFieldType["Boolean"] = "boolean";
  SchemaFieldType["Variant"] = "variant";
  SchemaFieldType["Unknown"] = "unknown";
})(SchemaFieldType || (SchemaFieldType = {}));

export const REQUEST_TYPES = {
  DATA: 'Map data',
  INSTANTIATION: 'Map instantiation',
  PUBLIC_MAP: 'Public map',
  TILE_STATS: 'Tile stats'
};
export function encodeParameter(name, value) {
  return "".concat(name, "=").concat(encodeURIComponent(value));
}
export let FilterTypes;

(function (FilterTypes) {
  FilterTypes["In"] = "in";
  FilterTypes["Between"] = "between";
  FilterTypes["ClosedOpen"] = "closed_open";
  FilterTypes["Time"] = "time";
  FilterTypes["StringSearch"] = "stringSearch";
})(FilterTypes || (FilterTypes = {}));
//# sourceMappingURL=maps-api-common.js.map