import { API_VERSIONS } from './api/maps-api-common';
export const defaultClassicCredentials = {
  apiKey: 'default_public',
  region: 'us',
  username: 'public'
};
export const defaultCloudNativeCredentials = {
  apiBaseUrl: 'https://gcp-us-east1.api.carto.com'
};
let credentials = {};
setDefaultCredentials({});
export function setDefaultCredentials({
  apiVersion,
  ...rest
}) {
  apiVersion = apiVersion || API_VERSIONS.V3;

  switch (apiVersion) {
    case API_VERSIONS.V1:
    case API_VERSIONS.V2:
      credentials = {
        apiVersion,
        ...defaultClassicCredentials,
        ...rest
      };
      break;

    case API_VERSIONS.V3:
      credentials = {
        apiVersion,
        ...defaultCloudNativeCredentials,
        ...rest
      };
      break;

    default:
      throw new Error("Invalid API version ".concat(apiVersion, ". Use API_VERSIONS enum."));
  }
}
export function getDefaultCredentials() {
  return credentials;
}

function buildUrlFromBase(apiBaseUrl, endpoint) {
  let suffix = "/v3/".concat(endpoint);

  if (apiBaseUrl.endsWith('/')) {
    suffix = suffix.substring(1);
  }

  return "".concat(apiBaseUrl).concat(suffix);
}

export function buildMapsUrlFromBase(apiBaseUrl) {
  return buildUrlFromBase(apiBaseUrl, 'maps');
}
export function buildStatsUrlFromBase(apiBaseUrl) {
  return buildUrlFromBase(apiBaseUrl, 'stats');
}
//# sourceMappingURL=config.js.map