import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { registerLoaders } from '@loaders.gl/core';
import CartoVectorTileLoader from './schema/carto-vector-tile-loader';
registerLoaders([CartoVectorTileLoader]);
import { ClipExtension } from '@deck.gl/extensions';
import { MVTLayer, _getURLFromTemplate } from '@deck.gl/geo-layers';
import { GeoJsonLayer } from '@deck.gl/layers';
import { binaryToGeojson } from '@loaders.gl/gis';
import { TILE_FORMATS } from '../api/maps-api-common';
const defaultTileFormat = TILE_FORMATS.BINARY;
const defaultProps = { ...MVTLayer.defaultProps,
  formatTiles: defaultTileFormat
};
export default class CartoTileLayer extends MVTLayer {
  initializeState() {
    super.initializeState();
    const binary = this.props.formatTiles === TILE_FORMATS.BINARY;
    this.setState({
      binary
    });
  }

  getTileData(tile) {
    const url = _getURLFromTemplate(this.state.data, tile);

    if (!url) {
      return Promise.reject('Invalid URL');
    }

    const loadOptions = this.getLoadOptions();
    const {
      fetch
    } = this.props;
    const {
      signal
    } = tile;
    return fetch(url, {
      propName: 'data',
      layer: this,
      loadOptions,
      signal
    });
  }

  renderSubLayers(props) {
    if (props.data === null) {
      return null;
    }

    const tileBbox = props.tile.bbox;
    const {
      west,
      south,
      east,
      north
    } = tileBbox;
    const subLayerProps = { ...props,
      autoHighlight: false,
      extensions: [new ClipExtension(), ...(props.extensions || [])],
      clipBounds: [west, south, east, north]
    };
    const subLayer = new GeoJsonLayer(subLayerProps);
    return subLayer;
  }

  getPickingInfo(params) {
    const info = super.getPickingInfo(params);

    if (this.state.binary && info.index !== -1) {
      const {
        data
      } = params.sourceLayer.props;
      info.object = binaryToGeojson(data, {
        globalFeatureId: info.index
      });
    }

    return info;
  }

}

_defineProperty(CartoTileLayer, "layerName", 'CartoTileLayer');

_defineProperty(CartoTileLayer, "defaultProps", defaultProps);
//# sourceMappingURL=carto-tile-layer.js.map