import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { CompositeLayer } from '@deck.gl/core';
import { H3HexagonLayer } from '@deck.gl/geo-layers';
import H3Tileset2D, { getHexagonResolution } from './h3-tileset-2d';
import SpatialIndexTileLayer from './spatial-index-tile-layer';

const renderSubLayers = props => {
  const {
    data
  } = props;
  const {
    index
  } = props.tile;
  if (!data || !data.length) return null;
  return new H3HexagonLayer(props, {
    getHexagon: d => d.id,
    centerHexagon: index,
    highPrecision: true
  });
};

const defaultProps = {
  aggregationResLevel: 4
};
export default class H3TileLayer extends CompositeLayer {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", void 0);
  }

  initializeState() {
    H3HexagonLayer._checkH3Lib();

    this.setState({
      data: null,
      tileJSON: null
    });
  }

  updateState({
    changeFlags
  }) {
    if (changeFlags.dataChanged) {
      let {
        data
      } = this.props;
      const tileJSON = data;
      data = tileJSON.tiles;
      this.setState({
        data,
        tileJSON
      });
    }
  }

  renderLayers() {
    const {
      data,
      tileJSON
    } = this.state;
    let minresolution = parseInt(tileJSON.minresolution);
    let maxresolution = parseInt(tileJSON.maxresolution);

    if (this.props.minZoom) {
      minresolution = Math.max(minresolution, getHexagonResolution({
        zoom: this.props.minZoom,
        latitude: 0
      }));
    }

    if (this.props.maxZoom) {
      maxresolution = Math.min(maxresolution, getHexagonResolution({
        zoom: this.props.maxZoom,
        latitude: 0
      }));
    }

    return [new SpatialIndexTileLayer(this.props, {
      id: "h3-tile-layer-".concat(this.props.id),
      data,
      TilesetClass: H3Tileset2D,
      renderSubLayers,
      minZoom: minresolution,
      maxZoom: maxresolution,
      loadOptions: { ...this.getLoadOptions(),
        cartoSpatialTile: {
          scheme: 'h3'
        }
      }
    })];
  }

}

_defineProperty(H3TileLayer, "layerName", 'H3TileLayer');

_defineProperty(H3TileLayer, "defaultProps", defaultProps);
//# sourceMappingURL=h3-tile-layer.js.map