import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { CompositeLayer } from '@deck.gl/core';
import { TextLayer, _TextBackgroundLayer as TextBackgroundLayer } from '@deck.gl/layers';
const [LEFT, TOP, RIGHT, BOTTOM] = [0, 1, 2, 3];

class EnhancedTextBackgroundLayer extends TextBackgroundLayer {
  getShaders() {
    const shaders = super.getShaders();
    let vs = shaders.vs;
    vs = vs.replaceAll('padding.', '_padding.');
    vs = vs.replace('void main(void) {', 'void main(void) {\n  vec4 _padding = padding + instancePixelOffsets.xyxy * vec4(1.0, 1.0, -1.0, -1.0);');
    return { ...shaders,
      vs
    };
  }

}

_defineProperty(EnhancedTextBackgroundLayer, "layerName", 'EnhancedTextBackgroundLayer');

class EnhancedTextLayer extends TextLayer {
  filterSubLayer({
    layer,
    renderPass
  }) {
    const background = layer.id.includes('primary-background');

    if (renderPass === 'collision') {
      return background;
    }

    return !background;
  }

}

_defineProperty(EnhancedTextLayer, "layerName", 'EnhancedTextLayer');

const defaultProps = { ...TextLayer.defaultProps,
  getRadius: {
    type: 'accessor',
    value: 1
  },
  radiusScale: {
    type: 'number',
    min: 0,
    value: 1
  }
};
export default class PointLabelLayer extends CompositeLayer {
  calculatePixelOffset(secondary) {
    const {
      getTextAnchor: anchor,
      getAlignmentBaseline: alignment,
      getRadius,
      getSecondaryText,
      radiusScale,
      secondarySizeScale,
      sizeScale
    } = this.props;
    const xMult = anchor === 'middle' ? 0 : anchor === 'start' ? 1 : -1;
    const yMult = alignment === 'center' ? 0 : alignment === 'bottom' ? 1 : -1;
    const xPadding = sizeScale / 4;
    const yPadding = sizeScale * (1 + 1 / 4);
    const secondaryOffset = 0.6 * (1 - yMult) * sizeScale;
    let yOffset = secondary ? secondaryOffset : 0;

    if (anchor === 'middle' && alignment === 'top' && getSecondaryText) {
      yOffset -= secondaryOffset;
      yOffset -= secondarySizeScale;
      yOffset += sizeScale;
    }

    const radiusPadding = 1 + 1 / 4;
    return typeof getRadius === 'function' ? (d, info) => {
      const r = (info ? getRadius(d, info) : 1) * radiusScale * radiusPadding;
      return [xMult * (r + xPadding), yMult * (r + yPadding) + yOffset];
    } : [xMult * (getRadius * radiusScale * radiusPadding + xPadding), yMult * (getRadius * radiusScale * radiusPadding + yPadding) + yOffset];
  }

  calculateBackgroundPadding() {
    const {
      getTextAnchor: anchor,
      getAlignmentBaseline: alignment,
      sizeScale
    } = this.props;
    const paddingX = 12 * sizeScale;
    const paddingY = 3 * sizeScale;
    const backgroundPadding = [0, 0, 0, 0];

    if (alignment === 'top') {
      backgroundPadding[TOP] = paddingY;
    } else if (alignment === 'bottom') {
      backgroundPadding[BOTTOM] = paddingY;
    } else {
      backgroundPadding[TOP] = 0.5 * paddingY;
      backgroundPadding[BOTTOM] = 0.5 * paddingY;
    }

    if (anchor === 'start') {
      backgroundPadding[LEFT] = paddingX;
    } else if (anchor === 'end') {
      backgroundPadding[RIGHT] = paddingX;
    } else {
      backgroundPadding[LEFT] = 0.5 * paddingX;
      backgroundPadding[RIGHT] = 0.5 * paddingX;
    }

    return backgroundPadding;
  }

  renderTextLayer(id, {
    updateTriggers: updateTriggersOverride = {},
    ...props
  }) {
    const {
      data,
      characterSet,
      fontFamily,
      fontSettings,
      fontWeight,
      outlineColor,
      outlineWidth,
      sizeScale,
      radiusScale,
      getAlignmentBaseline,
      getColor,
      getPosition,
      getTextAnchor,
      updateTriggers
    } = this.props;
    return new EnhancedTextLayer(this.getSubLayerProps({
      id,
      data,
      characterSet,
      fontFamily,
      fontSettings,
      fontWeight,
      outlineColor,
      outlineWidth,
      sizeScale,
      getAlignmentBaseline,
      getColor,
      getPosition,
      getTextAnchor,
      updateTriggers: { ...updateTriggers,
        ...updateTriggersOverride,
        getPixelOffset: [updateTriggers.getRadius, updateTriggers.getTextAnchor, updateTriggers.getAlignmentBaseline, radiusScale, sizeScale]
      }
    }), {
      getSize: 1,
      _subLayerProps: {
        background: {
          type: EnhancedTextBackgroundLayer
        }
      }
    }, props);
  }

  renderLayers() {
    const {
      getText,
      getSecondaryColor,
      getSecondaryText,
      secondaryOutlineColor,
      secondarySizeScale,
      updateTriggers
    } = this.props;
    const getPixelOffset = this.calculatePixelOffset(false);
    const backgroundPadding = this.calculateBackgroundPadding();
    const out = [this.renderTextLayer("".concat(updateTriggers.getText, "-primary"), {
      backgroundPadding,
      getText,
      getPixelOffset,
      background: true
    }), Boolean(getSecondaryText) && this.renderTextLayer("".concat(updateTriggers.getSecondaryText, "-secondary"), {
      getText: getSecondaryText,
      getPixelOffset: this.calculatePixelOffset(true),
      getAlignmentBaseline: 'top',
      ...(getSecondaryColor && {
        getColor: getSecondaryColor
      }),
      ...(secondarySizeScale && {
        sizeScale: secondarySizeScale
      }),
      ...(secondaryOutlineColor && {
        outlineColor: secondaryOutlineColor
      })
    })];
    return out;
  }

}

_defineProperty(PointLabelLayer, "layerName", 'PointLabelLayer');

_defineProperty(PointLabelLayer, "defaultProps", defaultProps);
//# sourceMappingURL=point-label-layer.js.map