import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { _GeoCellLayer as GeoCellLayer } from '@deck.gl/geo-layers';
import { getQuadbinPolygon } from './quadbin-utils';
const defaultProps = {
  getQuadbin: {
    type: 'accessor',
    value: d => d.quadbin
  }
};
export default class QuadbinLayer extends GeoCellLayer {
  indexToBounds() {
    const {
      data,
      extruded,
      getQuadbin
    } = this.props;
    const coverage = extruded ? 0.99 : 1;
    return {
      data,
      _normalize: false,
      positionFormat: 'XY',
      getPolygon: (x, objectInfo) => getQuadbinPolygon(getQuadbin(x, objectInfo), coverage),
      updateTriggers: {
        getPolygon: coverage
      }
    };
  }

}

_defineProperty(QuadbinLayer, "layerName", 'QuadbinLayer');

_defineProperty(QuadbinLayer, "defaultProps", defaultProps);
//# sourceMappingURL=quadbin-layer.js.map