import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { CompositeLayer } from '@deck.gl/core';
import QuadbinLayer from './quadbin-layer';
import QuadbinTileset2D from './quadbin-tileset-2d';
import SpatialIndexTileLayer from './spatial-index-tile-layer';
import { hexToBigInt } from 'quadbin';
export const renderSubLayers = props => {
  const {
    data
  } = props;
  if (!data || !data.length) return null;
  const isBigInt = typeof data[0].id === 'bigint';
  return new QuadbinLayer(props, {
    getQuadbin: isBigInt ? d => d.id : d => hexToBigInt(d.id)
  });
};
const defaultProps = {
  aggregationResLevel: 6
};
export default class QuadbinTileLayer extends CompositeLayer {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", void 0);
  }

  initializeState() {
    this.setState({
      data: null,
      tileJSON: null
    });
  }

  updateState({
    changeFlags
  }) {
    if (changeFlags.dataChanged) {
      let {
        data
      } = this.props;
      const tileJSON = data;
      data = tileJSON.tiles;
      this.setState({
        data,
        tileJSON
      });
    }
  }

  renderLayers() {
    const {
      data,
      tileJSON
    } = this.state;
    const maxZoom = parseInt(tileJSON === null || tileJSON === void 0 ? void 0 : tileJSON.maxresolution);
    return [new SpatialIndexTileLayer(this.props, {
      id: "quadbin-tile-layer-".concat(this.props.id),
      data,
      TilesetClass: QuadbinTileset2D,
      renderSubLayers,
      maxZoom,
      loadOptions: { ...this.getLoadOptions(),
        cartoSpatialTile: {
          scheme: 'quadbin'
        }
      }
    })];
  }

}

_defineProperty(QuadbinTileLayer, "layerName", 'QuadbinTileLayer');

_defineProperty(QuadbinTileLayer, "defaultProps", defaultProps);
//# sourceMappingURL=quadbin-tile-layer.js.map