import { _Tileset2D as Tileset2D } from '@deck.gl/geo-layers';
import { bigIntToHex, cellToParent, cellToTile, getResolution, tileToCell } from 'quadbin';
export default class QuadbinTileset2D extends Tileset2D {
  getTileIndices(opts) {
    return super.getTileIndices(opts).map(tileToCell).map(q => ({
      q,
      i: bigIntToHex(q)
    }));
  }

  getTileId({
    q,
    i
  }) {
    return i || bigIntToHex(q);
  }

  getTileMetadata({
    q
  }) {
    return super.getTileMetadata(cellToTile(q));
  }

  getTileZoom({
    q
  }) {
    return Number(getResolution(q));
  }

  getParentIndex({
    q
  }) {
    return {
      q: cellToParent(q)
    };
  }

}
//# sourceMappingURL=quadbin-tileset-2d.js.map