import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { CompositeLayer } from '@deck.gl/core';
import RasterLayer from './raster-layer';
import QuadbinTileset2D from './quadbin-tileset-2d';
import SpatialIndexTileLayer from './spatial-index-tile-layer';
export const renderSubLayers = props => {
  var _props$tile, _props$tile$index;

  const tileIndex = (_props$tile = props.tile) === null || _props$tile === void 0 ? void 0 : (_props$tile$index = _props$tile.index) === null || _props$tile$index === void 0 ? void 0 : _props$tile$index.q;
  if (!tileIndex) return null;
  return new RasterLayer(props, {
    tileIndex
  });
};
export default class RasterTileLayer extends CompositeLayer {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", void 0);
  }

  initializeState() {
    this.setState({
      data: null,
      tileJSON: null
    });
  }

  updateState({
    changeFlags
  }) {
    if (changeFlags.dataChanged) {
      let {
        data
      } = this.props;
      const tileJSON = data;
      data = tileJSON.tiles;
      this.setState({
        data,
        tileJSON
      });
    }
  }

  renderLayers() {
    const {
      data,
      tileJSON
    } = this.state;
    const minZoom = parseInt(tileJSON === null || tileJSON === void 0 ? void 0 : tileJSON.minzoom);
    const maxZoom = parseInt(tileJSON === null || tileJSON === void 0 ? void 0 : tileJSON.maxzoom);
    return [new SpatialIndexTileLayer(this.props, {
      id: "raster-tile-layer-".concat(this.props.id),
      data,
      TilesetClass: QuadbinTileset2D,
      renderSubLayers,
      minZoom,
      maxZoom
    })];
  }

}

_defineProperty(RasterTileLayer, "layerName", 'RasterTileLayer');

_defineProperty(RasterTileLayer, "defaultProps", {});
//# sourceMappingURL=raster-tile-layer.js.map