import { TileReader } from './carto-raster-tile';
import { parsePbf } from './tile-loader-utils';
import { getWorkerUrl } from '../../utils';
const VERSION = typeof "8.9.36" !== 'undefined' ? "8.9.36" : 'latest';
const id = 'cartoRasterTile';
const DEFAULT_OPTIONS = {
  cartoRasterTile: {
    workerUrl: getWorkerUrl(id, VERSION)
  }
};
const CartoRasterTileLoader = {
  name: 'CARTO Raster Tile',
  version: VERSION,
  id,
  module: 'carto',
  extensions: ['pbf'],
  mimeTypes: ['application/vnd.carto-raster-tile'],
  category: 'geometry',
  parse: async (arrayBuffer, options) => parseCartoRasterTile(arrayBuffer, options),
  parseSync: parseCartoRasterTile,
  worker: true,
  options: DEFAULT_OPTIONS
};

function parseCartoRasterTile(arrayBuffer, options) {
  if (!arrayBuffer) return null;
  const tile = parsePbf(arrayBuffer, TileReader);
  const {
    bands,
    blockHeight,
    blockWidth
  } = tile;
  const numericProps = {};

  for (let i = 0; i < bands.length; i++) {
    const {
      name,
      data
    } = bands[i];
    numericProps[name] = data;
  }

  return {
    blockWidth,
    blockHeight,
    cells: {
      numericProps,
      properties: []
    }
  };
}

export default CartoRasterTileLoader;
//# sourceMappingURL=carto-raster-tile-loader.js.map