import { TileReader } from './carto-spatial-tile';
import { parsePbf } from './tile-loader-utils';
import { getWorkerUrl } from '../../utils';
import { binaryToSpatialjson } from './spatialjson-utils';
const VERSION = typeof "8.9.36" !== 'undefined' ? "8.9.36" : 'latest';
const id = 'cartoSpatialTile';
const DEFAULT_OPTIONS = {
  cartoSpatialTile: {
    scheme: 'quadbin',
    workerUrl: getWorkerUrl(id, VERSION)
  }
};
const CartoSpatialTileLoader = {
  name: 'CARTO Spatial Tile',
  version: VERSION,
  id,
  module: 'carto',
  extensions: ['pbf'],
  mimeTypes: ['application/vnd.carto-spatial-tile'],
  category: 'geometry',
  parse: async (arrayBuffer, options) => parseCartoSpatialTile(arrayBuffer, options),
  parseSync: parseCartoSpatialTile,
  worker: true,
  options: DEFAULT_OPTIONS
};

function parseCartoSpatialTile(arrayBuffer, options) {
  var _options$cartoSpatial;

  if (!arrayBuffer) return null;
  const tile = parsePbf(arrayBuffer, TileReader);
  const {
    cells
  } = tile;
  const scheme = options === null || options === void 0 ? void 0 : (_options$cartoSpatial = options.cartoSpatialTile) === null || _options$cartoSpatial === void 0 ? void 0 : _options$cartoSpatial.scheme;
  const data = {
    cells,
    scheme
  };
  return binaryToSpatialjson(data);
}

export default CartoSpatialTileLoader;
//# sourceMappingURL=carto-spatial-tile-loader.js.map