import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { registerLoaders } from '@loaders.gl/core';
import CartoRasterTileLoader from './schema/carto-raster-tile-loader';
import CartoSpatialTileLoader from './schema/carto-spatial-tile-loader';
registerLoaders([CartoRasterTileLoader, CartoSpatialTileLoader]);
import { TileLayer } from '@deck.gl/geo-layers';

function isFeatureIdDefined(value) {
  return value !== undefined && value !== null && value !== '';
}

const defaultProps = {
  aggregationResLevel: 4
};
export default class SpatialIndexTileLayer extends TileLayer {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", void 0);
  }

  updateState(params) {
    const {
      props,
      oldProps
    } = params;

    if (props.aggregationResLevel !== oldProps.aggregationResLevel) {
      this.setState({
        tileset: null
      });
    }

    super.updateState(params);
  }

  _updateAutoHighlight(info) {
    const {
      hoveredFeatureId
    } = this.state;
    const hoveredFeature = info.object;
    let newHoveredFeatureId = null;

    if (hoveredFeature) {
      newHoveredFeatureId = hoveredFeature.id;
    }

    if (hoveredFeatureId !== newHoveredFeatureId) {
      let {
        highlightColor
      } = this.props;

      if (typeof highlightColor === 'function') {
        highlightColor = highlightColor(info);
      }

      this.setState({
        highlightColor,
        hoveredFeatureId: newHoveredFeatureId
      });
    }
  }

  getSubLayerPropsByTile(tile) {
    return {
      highlightedObjectIndex: this.getHighlightedObjectIndex(tile),
      highlightColor: this.state.highlightColor
    };
  }

  getHighlightedObjectIndex(tile) {
    const {
      hoveredFeatureId
    } = this.state;
    const data = tile.content;
    const isFeatureIdPresent = isFeatureIdDefined(hoveredFeatureId);

    if (!isFeatureIdPresent || !Array.isArray(data) || !this._featureInTile(tile, hoveredFeatureId)) {
      return -1;
    }

    return data.findIndex(feature => feature.id === hoveredFeatureId);
  }

  _featureInTile(tile, featureId) {
    const tileset = this.state.tileset;
    const tileZoom = tileset.getTileZoom(tile.index);
    const KEY = tile.index.q ? 'q' : 'i';
    let featureIndex = {
      [KEY]: featureId
    };
    let featureZoom = tileset.getTileZoom(featureIndex);

    while (!(featureZoom <= tileZoom)) {
      featureIndex = tileset.getParentIndex(featureIndex);
      featureZoom = tileset.getTileZoom(featureIndex);
    }

    return featureIndex[KEY] === tile.index[KEY];
  }

}

_defineProperty(SpatialIndexTileLayer, "layerName", 'SpatialIndexTileLayer');

_defineProperty(SpatialIndexTileLayer, "defaultProps", defaultProps);
//# sourceMappingURL=spatial-index-tile-layer.js.map