const ALLOWED_ATTR_TYPES = Object.freeze(['function', 'string']);
export function getAttrValue(attr, d) {
  var _properties;

  assert(typeof d === 'object', 'Expected "data" to be an object');
  assert(ALLOWED_ATTR_TYPES.includes(typeof attr), 'Expected "attr" to be a function or string');

  if (typeof attr === 'function') {
    return attr(d);
  }

  return d === null || d === void 0 ? void 0 : (_properties = d.properties) === null || _properties === void 0 ? void 0 : _properties[attr];
}
export function assert(condition, message = '') {
  if (!condition) {
    throw new Error("CARTO style error: ".concat(message));
  }
}
//# sourceMappingURL=utils.js.map