import { log } from '@deck.gl/core';
export function assert(condition, message) {
  log.assert(condition, message);
}
export function createBinaryProxy(data, index) {
  const {
    properties,
    numericProps
  } = data;
  return new Proxy(properties[index] || {}, {
    get(target, property, receiver) {
      if (property in numericProps) {
        return numericProps[property].value[index];
      }

      return target[property];
    },

    has(target, property) {
      return property in numericProps || property in target;
    }

  });
}
export function getWorkerUrl(id, version) {
  return "https://unpkg.com/@deck.gl/carto@".concat(version, "/dist/").concat(id, "-worker.js");
}
export function scaleIdentity() {
  let unknown;

  function scale(x) {
    return x === null ? unknown : x;
  }

  scale.invert = scale;

  scale.domain = scale.range = d => d;

  scale.unknown = u => {
    if (u) {
      unknown = u;
    }

    return unknown;
  };

  scale.copy = () => scaleIdentity().unknown(unknown);

  return scale;
}
//# sourceMappingURL=utils.js.map