import { DefaultProps } from '@deck.gl/core/typed';
import { MVTLayer, MVTLayerProps, TileLayer, _Tile2DHeader, _TileLoadProps as TileLoadProps } from '@deck.gl/geo-layers/typed';
import { GeoJsonLayer } from '@deck.gl/layers/typed';
import { TileFormat } from '../api/maps-api-common';
/** All properties supported by CartoTileLayer. */
export declare type CartoTileLayerProps = _CartoTileLayerProps & MVTLayerProps;
/** Properties added by CartoTileLayer. */
declare type _CartoTileLayerProps = {
    /** Use to override the default tile data format.
     *
     * Possible values are: `TILE_FORMATS.BINARY`, `TILE_FORMATS.GEOJSON` and `TILE_FORMATS.MVT`.
     *
     * Only supported when `apiVersion` is `API_VERSIONS.V3` and `format` is `FORMATS.TILEJSON`.
     */
    formatTiles?: TileFormat;
};
export default class CartoTileLayer<ExtraProps extends {} = {}> extends MVTLayer<Required<_CartoTileLayerProps> & ExtraProps> {
    static layerName: string;
    static defaultProps: DefaultProps<CartoTileLayerProps>;
    initializeState(): void;
    getTileData(tile: TileLoadProps): any;
    renderSubLayers(props: TileLayer['props'] & {
        id: string;
        data: any;
        _offset: number;
        tile: _Tile2DHeader;
    }): GeoJsonLayer | null;
    getPickingInfo(params: any): import("modules/geo-layers/src/tile-layer/tile-layer").TiledPickingInfo<any>;
}
export {};
//# sourceMappingURL=carto-tile-layer.d.ts.map