import { Accessor, Color, CompositeLayer, CompositeLayerProps, DefaultProps, Layer, LayersList } from '@deck.gl/core/typed';
import { TextLayer, TextLayerProps } from '@deck.gl/layers/typed';
declare class EnhancedTextLayer extends TextLayer {
    static layerName: string;
    filterSubLayer({ layer, renderPass }: {
        layer: any;
        renderPass: any;
    }): any;
}
/** All properties supported by PointLabelLayer. */
export declare type PointLabelLayerProps<DataT = any> = _PointLabelLayerProps<DataT> & TextLayerProps & CompositeLayerProps;
/** Properties added by PointLabelLayer. */
declare type _PointLabelLayerProps<DataT> = TextLayerProps<DataT> & {
    /**
     * Radius multiplier.
     * @default 1
     */
    radiusScale?: number;
    /**
     * Radius accessor.
     * @default 1
     */
    getRadius?: Accessor<DataT, number>;
    /**
     * Secondary label text accessor
     */
    getSecondaryText?: Accessor<DataT, string>;
    /**
     * Secondary label color accessor
     * @default [0, 0, 0, 255]
     */
    getSecondaryColor?: Accessor<DataT, Color>;
    /**
     * Secondary label color of outline around the text, in `[r, g, b, [a]]`. Each channel is a number between 0-255 and `a` is 255 if not supplied.
     * @default [0, 0, 0, 255]
     */
    secondaryOutlineColor?: Color;
    /**
     * Secondary label text size multiplier.
     * @default 1
     */
    secondarySizeScale?: number;
};
export default class PointLabelLayer<DataT = any, ExtraProps extends {} = {}> extends CompositeLayer<ExtraProps & Required<_PointLabelLayerProps<DataT>>> {
    static layerName: string;
    static defaultProps: DefaultProps<PointLabelLayerProps<any>>;
    calculatePixelOffset(secondary: any): number[] | ((d: any, info: any) => number[]);
    calculateBackgroundPadding(): number[];
    renderTextLayer(id: any, { updateTriggers: updateTriggersOverride, ...props }: {
        [x: string]: any;
        updateTriggers?: {} | undefined;
    }): EnhancedTextLayer;
    renderLayers(): Layer | null | LayersList;
}
export {};
//# sourceMappingURL=point-label-layer.d.ts.map