declare const _default: "#version 300 es\n#define SHADER_NAME raster-layer-vertex-shader\n\nin vec3 positions;\nin vec3 normals;\n\nin float instanceElevations;\nin vec4 instanceFillColors;\nin vec4 instanceLineColors;\n\nin vec3 instancePickingColors;\n\n// Custom uniforms\nuniform float opacity;\nuniform bool extruded;\nuniform bool stroked;\nuniform bool isStroke;\nuniform float coverage;\nuniform float elevationScale;\nuniform float widthScale;\nuniform vec3 offset;\n\n// Result\nout vec4 vColor;\n#ifdef FLAT_SHADING\nout vec4 position_commonspace;\n#endif\n\nvoid main(void) {\n  // Rather than positioning using attribute, layout pixel grid using gl_InstanceID\n  vec2 common_position = offset.xy;\n  float scale = offset.z;\n\n  int yIndex = - (gl_InstanceID / 256);\n  int xIndex = gl_InstanceID + (yIndex * 256);\n  common_position += scale * vec2(float(xIndex), float(yIndex));\n\n  vec4 color = isStroke ? instanceLineColors : instanceFillColors;\n\n  // if alpha == 0.0 or z < 0.0, do not render element\n  float shouldRender = float(color.a > 0.0 && instanceElevations >= 0.0);\n  float cellWidth = coverage * scale;\n\n  // Get position directly from quadbin, rather than projecting\n  // Important to set geometry.position before using project_ methods below\n  // as geometry.worldPosition is not set (we don't know our lat/long)\n  geometry.position = vec4(common_position, 0.0, 1.0);\n  if (project_uProjectionMode == PROJECTION_MODE_WEB_MERCATOR_AUTO_OFFSET) {\n    geometry.position.xyz -= project_uCommonOrigin;\n  }\n\n  // calculate elevation, if 3d not enabled set to 0\n  // cylindar geometry height are between -1.0 to 1.0, transform it to between 0, 1\n  float elevation = 0.0;\n  // calculate stroke offset\n  float strokeOffsetRatio = 1.0;\n\n  if (extruded) {\n    elevation = instanceElevations * (positions.z + 1.0) / 2.0 * elevationScale;\n  } else if (stroked) {\n    float halfOffset = project_pixel_size(widthScale) / cellWidth;\n    if (isStroke) {\n      strokeOffsetRatio -= sign(positions.z) * halfOffset;\n    } else {\n      strokeOffsetRatio -= halfOffset;\n    }\n  }\n\n  geometry.pickingColor = instancePickingColors;\n\n  // project center of column\n  vec2 offset = (vec2(0.5) + positions.xy * strokeOffsetRatio) * cellWidth * shouldRender;\n  vec3 pos = vec3(offset, project_size(elevation));\n  DECKGL_FILTER_SIZE(pos, geometry);\n\n  geometry.position.xyz += pos;\n  gl_Position = project_common_position_to_clipspace(geometry.position);\n\n  geometry.normal = project_normal(normals);\n  DECKGL_FILTER_GL_POSITION(gl_Position, geometry);\n\n  // Light calculations\n  if (extruded && !isStroke) {\n#ifdef FLAT_SHADING\n    position_commonspace = geometry.position;\n    vColor = vec4(color.rgb, color.a * opacity);\n#else\n    vec3 lightColor = lighting_getLightColor(color.rgb, project_uCameraPosition, geometry.position.xyz, geometry.normal);\n    vColor = vec4(lightColor, color.a * opacity);\n#endif\n  } else {\n    vColor = vec4(color.rgb, color.a * opacity);\n  }\n\n  DECKGL_FILTER_COLOR(vColor, geometry);\n}\n";
export default _default;
//# sourceMappingURL=raster-layer-vertex.glsl.d.ts.map