import { Accessor, CompositeLayer, CompositeLayerProps, Layer, LayersList, DefaultProps } from '@deck.gl/core/typed';
import { ColumnLayerProps } from '@deck.gl/layers/typed';
/** All properties supported by RasterLayer. */
export declare type RasterLayerProps<DataT = any> = _RasterLayerProps & ColumnLayerProps<DataT> & CompositeLayerProps;
/** Properties added by RasterLayer. */
declare type _RasterLayerProps = {
    /**
     * Quadbin index of tile
     */
    tileIndex: bigint;
};
export default class RasterLayer<DataT = any, ExtraProps = {}> extends CompositeLayer<Required<RasterLayerProps<DataT>> & ExtraProps> {
    static layerName: string;
    static defaultProps: DefaultProps<RasterLayerProps<any>>;
    renderLayers(): Layer | null | LayersList;
    protected getSubLayerAccessor<In, Out>(accessor: Accessor<In, Out>): Accessor<In, Out>;
}
export {};
//# sourceMappingURL=raster-layer.d.ts.map