import { DefaultProps, UpdateParameters } from '@deck.gl/core/typed';
import { PickingInfo } from '@deck.gl/core/typed';
import { TileLayer, _Tile2DHeader as Tile2DHeader, TileLayerProps } from '@deck.gl/geo-layers/typed';
/** All properties supported by SpatialIndexTileLayer. */
export declare type SpatialIndexTileLayerProps<DataT = any> = _SpatialIndexTileLayerProps<DataT> & TileLayerProps<DataT>;
/** Properties added by SpatialIndexTileLayer. */
declare type _SpatialIndexTileLayerProps<DataT = any> = {
    aggregationResLevel?: number;
};
export default class SpatialIndexTileLayer<DataT = any, ExtraProps extends {} = {}> extends TileLayer<DataT, ExtraProps & Required<_SpatialIndexTileLayerProps<DataT>>> {
    static layerName: string;
    static defaultProps: DefaultProps<SpatialIndexTileLayerProps<any>>;
    state: TileLayer<DataT>['state'] & {
        hoveredFeatureId: BigInt | number | null;
        highlightColor?: number[];
    };
    updateState(params: UpdateParameters<this>): void;
    protected _updateAutoHighlight(info: PickingInfo): void;
    getSubLayerPropsByTile(tile: Tile2DHeader): {
        highlightedObjectIndex: number;
        highlightColor: number[] | undefined;
    };
    getHighlightedObjectIndex(tile: Tile2DHeader): number;
    _featureInTile(tile: Tile2DHeader, featureId: BigInt | number): boolean;
}
export {};
//# sourceMappingURL=spatial-index-tile-layer.d.ts.map