(function webpackUniversalModuleDefinition(root, factory) {
  if (typeof exports === 'object' && typeof module === 'object')
    module.exports = factory();
  else if (typeof define === 'function' && define.amd) define([], factory);
        else if (typeof exports === 'object') exports['deck'] = factory();
  else root['deck'] = factory();})(globalThis, function () {
"use strict";
var __exports__ = (() => {
  var __create = Object.create;
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
  var __commonJS = (cb, mod) => function __require() {
    return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __export = (target, all) => {
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));
  var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
    mod
  ));
  var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
  var __publicField = (obj, key, value) => {
    __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
    return value;
  };

  // external-global-plugin:@deck.gl/core
  var require_core = __commonJS({
    "external-global-plugin:@deck.gl/core"(exports, module) {
      module.exports = globalThis.deck;
    }
  });

  // external-global-plugin:@luma.gl/core
  var require_core2 = __commonJS({
    "external-global-plugin:@luma.gl/core"(exports, module) {
      module.exports = globalThis.luma;
    }
  });

  // bundle.ts
  var bundle_exports = {};
  __export(bundle_exports, {
    BrushingExtension: () => BrushingExtension,
    ClipExtension: () => ClipExtension,
    CollisionFilterExtension: () => CollisionFilterExtension,
    DataFilterExtension: () => DataFilterExtension,
    FillStyleExtension: () => FillStyleExtension,
    Fp64Extension: () => Fp64Extension,
    MaskExtension: () => MaskExtension,
    PathStyleExtension: () => PathStyleExtension,
    _TerrainExtension: () => TerrainExtension,
    project64: () => project64_default
  });

  // ../core/bundle/peer-dependency.ts
  var peer_dependency_exports = {};
  var import_core = __toESM(require_core());
  __reExport(peer_dependency_exports, __toESM(require_core()));
  if (!import_core.Layer) {
    throw new Error("@deck.gl/core is not found");
  }

  // bundle.ts
  __reExport(bundle_exports, peer_dependency_exports);

  // src/brushing/brushing-extension.ts
  var import_core3 = __toESM(require_core());

  // src/brushing/shader-module.ts
  var import_core2 = __toESM(require_core());
  var vs = `
  uniform bool brushing_enabled;
  uniform int brushing_target;
  uniform vec2 brushing_mousePos;
  uniform float brushing_radius;

  #ifdef NON_INSTANCED_MODEL
  attribute vec2 brushingTargets;
  #else
  attribute vec2 instanceBrushingTargets;
  #endif

  varying float brushing_isVisible;

  bool brushing_isPointInRange(vec2 position) {
    if (!brushing_enabled) {
      return true;
    }
    vec2 source_commonspace = project_position(position);
    vec2 target_commonspace = project_position(brushing_mousePos);
    float distance = length((target_commonspace - source_commonspace) / project_uCommonUnitsPerMeter.xy);

    return distance <= brushing_radius;
  }

  bool brushing_arePointsInRange(vec2 sourcePos, vec2 targetPos) {
    return brushing_isPointInRange(sourcePos) || brushing_isPointInRange(targetPos);
  }

  void brushing_setVisible(bool visible) {
    brushing_isVisible = float(visible);
  }
`;
  var fs = `
  uniform bool brushing_enabled;
  varying float brushing_isVisible;
`;
  var TARGET = {
    source: 0,
    target: 1,
    custom: 2,
    source_target: 3
  };
  var inject = {
    "vs:DECKGL_FILTER_GL_POSITION": `
    vec2 brushingTarget;
    vec2 brushingSource;
    if (brushing_target == 3) {
      brushingTarget = geometry.worldPositionAlt.xy;
      brushingSource = geometry.worldPosition.xy;
    } else if (brushing_target == 0) {
      brushingTarget = geometry.worldPosition.xy;
    } else if (brushing_target == 1) {
      brushingTarget = geometry.worldPositionAlt.xy;
    } else {
      #ifdef NON_INSTANCED_MODEL
      brushingTarget = brushingTargets;
      #else
      brushingTarget = instanceBrushingTargets;
      #endif
    }
    bool visible;
    if (brushing_target == 3) {
      visible = brushing_arePointsInRange(brushingSource, brushingTarget);
    } else {
      visible = brushing_isPointInRange(brushingTarget);
    }
    brushing_setVisible(visible);
  `,
    "fs:DECKGL_FILTER_COLOR": `
    if (brushing_enabled && brushing_isVisible < 0.5) {
      discard;
    }
  `
  };
  var shader_module_default = {
    name: "brushing",
    dependencies: [import_core2.project],
    vs,
    fs,
    inject,
    getUniforms: (opts) => {
      if (!opts || !("viewport" in opts)) {
        return {};
      }
      const {
        brushingEnabled = true,
        brushingRadius = 1e4,
        brushingTarget = "source",
        mousePosition,
        viewport
      } = opts;
      return {
        brushing_enabled: Boolean(brushingEnabled && mousePosition && viewport.containsPixel(mousePosition)),
        brushing_radius: brushingRadius,
        brushing_target: TARGET[brushingTarget] || 0,
        brushing_mousePos: mousePosition ? viewport.unproject([mousePosition.x - viewport.x, mousePosition.y - viewport.y]) : [0, 0]
      };
    }
  };

  // src/brushing/brushing-extension.ts
  var defaultProps = {
    getBrushingTarget: {
      type: "accessor",
      value: [0, 0]
    },
    brushingTarget: "source",
    brushingEnabled: true,
    brushingRadius: 1e4
  };
  var BrushingExtension = class extends import_core3.LayerExtension {
    getShaders() {
      return {
        modules: [shader_module_default]
      };
    }
    initializeState(context, extension) {
      const attributeManager = this.getAttributeManager();
      if (attributeManager) {
        attributeManager.add({
          brushingTargets: {
            size: 2,
            accessor: "getBrushingTarget",
            shaderAttributes: {
              brushingTargets: {
                divisor: 0
              },
              instanceBrushingTargets: {
                divisor: 1
              }
            }
          }
        });
      }
      this.state.onMouseMove = () => {
        this.getCurrentLayer()?.setNeedsRedraw();
      };
      if (context.deck) {
        context.deck.eventManager.on({
          pointermove: this.state.onMouseMove,
          pointerleave: this.state.onMouseMove
        });
      }
    }
    finalizeState(context, extension) {
      if (context.deck) {
        context.deck.eventManager.off({
          pointermove: this.state.onMouseMove,
          pointerleave: this.state.onMouseMove
        });
      }
    }
  };
  __publicField(BrushingExtension, "defaultProps", defaultProps);
  __publicField(BrushingExtension, "extensionName", "BrushingExtension");

  // src/data-filter/data-filter-extension.ts
  var import_core5 = __toESM(require_core());

  // src/data-filter/shader-module.ts
  var vs2 = `
uniform DATAFILTER_TYPE filter_min;
uniform DATAFILTER_TYPE filter_softMin;
uniform DATAFILTER_TYPE filter_softMax;
uniform DATAFILTER_TYPE filter_max;
uniform bool filter_useSoftMargin;
uniform bool filter_enabled;
uniform bool filter_transformSize;

#ifdef NON_INSTANCED_MODEL
  #define DATAFILTER_ATTRIB filterValues
  #define DATAFILTER_ATTRIB_64LOW filterValues64Low
#else
  #define DATAFILTER_ATTRIB instanceFilterValues
  #define DATAFILTER_ATTRIB_64LOW instanceFilterValues64Low
#endif

attribute DATAFILTER_TYPE DATAFILTER_ATTRIB;
#ifdef DATAFILTER_DOUBLE
  attribute DATAFILTER_TYPE DATAFILTER_ATTRIB_64LOW;

  uniform DATAFILTER_TYPE filter_min64High;
  uniform DATAFILTER_TYPE filter_max64High;
#endif

varying float dataFilter_value;

float dataFilter_reduceValue(float value) {
  return value;
}
float dataFilter_reduceValue(vec2 value) {
  return min(value.x, value.y);
}
float dataFilter_reduceValue(vec3 value) {
  return min(min(value.x, value.y), value.z);
}
float dataFilter_reduceValue(vec4 value) {
  return min(min(value.x, value.y), min(value.z, value.w));
}
void dataFilter_setValue(DATAFILTER_TYPE valueFromMin, DATAFILTER_TYPE valueFromMax) {
  if (filter_enabled) {
    if (filter_useSoftMargin) {
      dataFilter_value = dataFilter_reduceValue(
        smoothstep(filter_min, filter_softMin, valueFromMin) *
        (1.0 - smoothstep(filter_softMax, filter_max, valueFromMax))
      );
    } else {
      dataFilter_value = dataFilter_reduceValue(
        step(filter_min, valueFromMin) * step(valueFromMax, filter_max)
      );
    }
  } else {
    dataFilter_value = 1.0;
  }
}
`;
  var fs2 = `
uniform bool filter_transformColor;
varying float dataFilter_value;
`;
  function getUniforms(opts) {
    if (!opts || !("extensions" in opts)) {
      return {};
    }
    const {
      filterRange = [-1, 1],
      filterEnabled = true,
      filterTransformSize = true,
      filterTransformColor = true
    } = opts;
    const filterSoftRange = opts.filterSoftRange || filterRange;
    return {
      ...Number.isFinite(filterRange[0]) ? {
        filter_min: filterRange[0],
        filter_softMin: filterSoftRange[0],
        filter_softMax: filterSoftRange[1],
        filter_max: filterRange[1]
      } : {
        filter_min: filterRange.map((r) => r[0]),
        filter_softMin: filterSoftRange.map((r) => r[0]),
        filter_softMax: filterSoftRange.map((r) => r[1]),
        filter_max: filterRange.map((r) => r[1])
      },
      filter_enabled: filterEnabled,
      filter_useSoftMargin: Boolean(opts.filterSoftRange),
      filter_transformSize: filterEnabled && filterTransformSize,
      filter_transformColor: filterEnabled && filterTransformColor
    };
  }
  function getUniforms64(opts) {
    if (!opts || !("extensions" in opts)) {
      return {};
    }
    const uniforms = getUniforms(opts);
    if (Number.isFinite(uniforms.filter_min)) {
      const min64High = Math.fround(uniforms.filter_min);
      uniforms.filter_min -= min64High;
      uniforms.filter_softMin -= min64High;
      uniforms.filter_min64High = min64High;
      const max64High = Math.fround(uniforms.filter_max);
      uniforms.filter_max -= max64High;
      uniforms.filter_softMax -= max64High;
      uniforms.filter_max64High = max64High;
    } else {
      const min64High = uniforms.filter_min.map(Math.fround);
      uniforms.filter_min = uniforms.filter_min.map((x, i) => x - min64High[i]);
      uniforms.filter_softMin = uniforms.filter_softMin.map((x, i) => x - min64High[i]);
      uniforms.filter_min64High = min64High;
      const max64High = uniforms.filter_max.map(Math.fround);
      uniforms.filter_max = uniforms.filter_max.map((x, i) => x - max64High[i]);
      uniforms.filter_softMax = uniforms.filter_softMax.map((x, i) => x - max64High[i]);
      uniforms.filter_max64High = max64High;
    }
    return uniforms;
  }
  var inject2 = {
    "vs:#main-start": `
    #ifdef DATAFILTER_DOUBLE
      dataFilter_setValue(
        DATAFILTER_ATTRIB - filter_min64High + DATAFILTER_ATTRIB_64LOW,
        DATAFILTER_ATTRIB - filter_max64High + DATAFILTER_ATTRIB_64LOW
      );
    #else
      dataFilter_setValue(DATAFILTER_ATTRIB, DATAFILTER_ATTRIB);
    #endif
  `,
    "vs:#main-end": `
    if (dataFilter_value == 0.0) {
      gl_Position = vec4(0.);
    }
  `,
    "vs:DECKGL_FILTER_SIZE": `
    if (filter_transformSize) {
      size = size * dataFilter_value;
    }
  `,
    "fs:DECKGL_FILTER_COLOR": `
    if (dataFilter_value == 0.0) discard;
    if (filter_transformColor) {
      color.a *= dataFilter_value;
    }
  `
  };
  var shaderModule = {
    name: "data-filter",
    vs: vs2,
    fs: fs2,
    inject: inject2,
    getUniforms
  };
  var shaderModule64 = {
    name: "data-filter-fp64",
    vs: vs2,
    fs: fs2,
    inject: inject2,
    getUniforms: getUniforms64
  };

  // src/data-filter/aggregator.ts
  var import_core4 = __toESM(require_core2());

  // ../../node_modules/@luma.gl/constants/dist/esm/index.js
  var esm_default = {
    DEPTH_BUFFER_BIT: 256,
    STENCIL_BUFFER_BIT: 1024,
    COLOR_BUFFER_BIT: 16384,
    POINTS: 0,
    LINES: 1,
    LINE_LOOP: 2,
    LINE_STRIP: 3,
    TRIANGLES: 4,
    TRIANGLE_STRIP: 5,
    TRIANGLE_FAN: 6,
    ZERO: 0,
    ONE: 1,
    SRC_COLOR: 768,
    ONE_MINUS_SRC_COLOR: 769,
    SRC_ALPHA: 770,
    ONE_MINUS_SRC_ALPHA: 771,
    DST_ALPHA: 772,
    ONE_MINUS_DST_ALPHA: 773,
    DST_COLOR: 774,
    ONE_MINUS_DST_COLOR: 775,
    SRC_ALPHA_SATURATE: 776,
    CONSTANT_COLOR: 32769,
    ONE_MINUS_CONSTANT_COLOR: 32770,
    CONSTANT_ALPHA: 32771,
    ONE_MINUS_CONSTANT_ALPHA: 32772,
    FUNC_ADD: 32774,
    FUNC_SUBTRACT: 32778,
    FUNC_REVERSE_SUBTRACT: 32779,
    BLEND_EQUATION: 32777,
    BLEND_EQUATION_RGB: 32777,
    BLEND_EQUATION_ALPHA: 34877,
    BLEND_DST_RGB: 32968,
    BLEND_SRC_RGB: 32969,
    BLEND_DST_ALPHA: 32970,
    BLEND_SRC_ALPHA: 32971,
    BLEND_COLOR: 32773,
    ARRAY_BUFFER_BINDING: 34964,
    ELEMENT_ARRAY_BUFFER_BINDING: 34965,
    LINE_WIDTH: 2849,
    ALIASED_POINT_SIZE_RANGE: 33901,
    ALIASED_LINE_WIDTH_RANGE: 33902,
    CULL_FACE_MODE: 2885,
    FRONT_FACE: 2886,
    DEPTH_RANGE: 2928,
    DEPTH_WRITEMASK: 2930,
    DEPTH_CLEAR_VALUE: 2931,
    DEPTH_FUNC: 2932,
    STENCIL_CLEAR_VALUE: 2961,
    STENCIL_FUNC: 2962,
    STENCIL_FAIL: 2964,
    STENCIL_PASS_DEPTH_FAIL: 2965,
    STENCIL_PASS_DEPTH_PASS: 2966,
    STENCIL_REF: 2967,
    STENCIL_VALUE_MASK: 2963,
    STENCIL_WRITEMASK: 2968,
    STENCIL_BACK_FUNC: 34816,
    STENCIL_BACK_FAIL: 34817,
    STENCIL_BACK_PASS_DEPTH_FAIL: 34818,
    STENCIL_BACK_PASS_DEPTH_PASS: 34819,
    STENCIL_BACK_REF: 36003,
    STENCIL_BACK_VALUE_MASK: 36004,
    STENCIL_BACK_WRITEMASK: 36005,
    VIEWPORT: 2978,
    SCISSOR_BOX: 3088,
    COLOR_CLEAR_VALUE: 3106,
    COLOR_WRITEMASK: 3107,
    UNPACK_ALIGNMENT: 3317,
    PACK_ALIGNMENT: 3333,
    MAX_TEXTURE_SIZE: 3379,
    MAX_VIEWPORT_DIMS: 3386,
    SUBPIXEL_BITS: 3408,
    RED_BITS: 3410,
    GREEN_BITS: 3411,
    BLUE_BITS: 3412,
    ALPHA_BITS: 3413,
    DEPTH_BITS: 3414,
    STENCIL_BITS: 3415,
    POLYGON_OFFSET_UNITS: 10752,
    POLYGON_OFFSET_FACTOR: 32824,
    TEXTURE_BINDING_2D: 32873,
    SAMPLE_BUFFERS: 32936,
    SAMPLES: 32937,
    SAMPLE_COVERAGE_VALUE: 32938,
    SAMPLE_COVERAGE_INVERT: 32939,
    COMPRESSED_TEXTURE_FORMATS: 34467,
    VENDOR: 7936,
    RENDERER: 7937,
    VERSION: 7938,
    IMPLEMENTATION_COLOR_READ_TYPE: 35738,
    IMPLEMENTATION_COLOR_READ_FORMAT: 35739,
    BROWSER_DEFAULT_WEBGL: 37444,
    STATIC_DRAW: 35044,
    STREAM_DRAW: 35040,
    DYNAMIC_DRAW: 35048,
    ARRAY_BUFFER: 34962,
    ELEMENT_ARRAY_BUFFER: 34963,
    BUFFER_SIZE: 34660,
    BUFFER_USAGE: 34661,
    CURRENT_VERTEX_ATTRIB: 34342,
    VERTEX_ATTRIB_ARRAY_ENABLED: 34338,
    VERTEX_ATTRIB_ARRAY_SIZE: 34339,
    VERTEX_ATTRIB_ARRAY_STRIDE: 34340,
    VERTEX_ATTRIB_ARRAY_TYPE: 34341,
    VERTEX_ATTRIB_ARRAY_NORMALIZED: 34922,
    VERTEX_ATTRIB_ARRAY_POINTER: 34373,
    VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: 34975,
    CULL_FACE: 2884,
    FRONT: 1028,
    BACK: 1029,
    FRONT_AND_BACK: 1032,
    BLEND: 3042,
    DEPTH_TEST: 2929,
    DITHER: 3024,
    POLYGON_OFFSET_FILL: 32823,
    SAMPLE_ALPHA_TO_COVERAGE: 32926,
    SAMPLE_COVERAGE: 32928,
    SCISSOR_TEST: 3089,
    STENCIL_TEST: 2960,
    NO_ERROR: 0,
    INVALID_ENUM: 1280,
    INVALID_VALUE: 1281,
    INVALID_OPERATION: 1282,
    OUT_OF_MEMORY: 1285,
    CONTEXT_LOST_WEBGL: 37442,
    CW: 2304,
    CCW: 2305,
    DONT_CARE: 4352,
    FASTEST: 4353,
    NICEST: 4354,
    GENERATE_MIPMAP_HINT: 33170,
    BYTE: 5120,
    UNSIGNED_BYTE: 5121,
    SHORT: 5122,
    UNSIGNED_SHORT: 5123,
    INT: 5124,
    UNSIGNED_INT: 5125,
    FLOAT: 5126,
    DOUBLE: 5130,
    DEPTH_COMPONENT: 6402,
    ALPHA: 6406,
    RGB: 6407,
    RGBA: 6408,
    LUMINANCE: 6409,
    LUMINANCE_ALPHA: 6410,
    UNSIGNED_SHORT_4_4_4_4: 32819,
    UNSIGNED_SHORT_5_5_5_1: 32820,
    UNSIGNED_SHORT_5_6_5: 33635,
    FRAGMENT_SHADER: 35632,
    VERTEX_SHADER: 35633,
    COMPILE_STATUS: 35713,
    DELETE_STATUS: 35712,
    LINK_STATUS: 35714,
    VALIDATE_STATUS: 35715,
    ATTACHED_SHADERS: 35717,
    ACTIVE_ATTRIBUTES: 35721,
    ACTIVE_UNIFORMS: 35718,
    MAX_VERTEX_ATTRIBS: 34921,
    MAX_VERTEX_UNIFORM_VECTORS: 36347,
    MAX_VARYING_VECTORS: 36348,
    MAX_COMBINED_TEXTURE_IMAGE_UNITS: 35661,
    MAX_VERTEX_TEXTURE_IMAGE_UNITS: 35660,
    MAX_TEXTURE_IMAGE_UNITS: 34930,
    MAX_FRAGMENT_UNIFORM_VECTORS: 36349,
    SHADER_TYPE: 35663,
    SHADING_LANGUAGE_VERSION: 35724,
    CURRENT_PROGRAM: 35725,
    NEVER: 512,
    ALWAYS: 519,
    LESS: 513,
    EQUAL: 514,
    LEQUAL: 515,
    GREATER: 516,
    GEQUAL: 518,
    NOTEQUAL: 517,
    KEEP: 7680,
    REPLACE: 7681,
    INCR: 7682,
    DECR: 7683,
    INVERT: 5386,
    INCR_WRAP: 34055,
    DECR_WRAP: 34056,
    NEAREST: 9728,
    LINEAR: 9729,
    NEAREST_MIPMAP_NEAREST: 9984,
    LINEAR_MIPMAP_NEAREST: 9985,
    NEAREST_MIPMAP_LINEAR: 9986,
    LINEAR_MIPMAP_LINEAR: 9987,
    TEXTURE_MAG_FILTER: 10240,
    TEXTURE_MIN_FILTER: 10241,
    TEXTURE_WRAP_S: 10242,
    TEXTURE_WRAP_T: 10243,
    TEXTURE_2D: 3553,
    TEXTURE: 5890,
    TEXTURE_CUBE_MAP: 34067,
    TEXTURE_BINDING_CUBE_MAP: 34068,
    TEXTURE_CUBE_MAP_POSITIVE_X: 34069,
    TEXTURE_CUBE_MAP_NEGATIVE_X: 34070,
    TEXTURE_CUBE_MAP_POSITIVE_Y: 34071,
    TEXTURE_CUBE_MAP_NEGATIVE_Y: 34072,
    TEXTURE_CUBE_MAP_POSITIVE_Z: 34073,
    TEXTURE_CUBE_MAP_NEGATIVE_Z: 34074,
    MAX_CUBE_MAP_TEXTURE_SIZE: 34076,
    TEXTURE0: 33984,
    ACTIVE_TEXTURE: 34016,
    REPEAT: 10497,
    CLAMP_TO_EDGE: 33071,
    MIRRORED_REPEAT: 33648,
    TEXTURE_WIDTH: 4096,
    TEXTURE_HEIGHT: 4097,
    FLOAT_VEC2: 35664,
    FLOAT_VEC3: 35665,
    FLOAT_VEC4: 35666,
    INT_VEC2: 35667,
    INT_VEC3: 35668,
    INT_VEC4: 35669,
    BOOL: 35670,
    BOOL_VEC2: 35671,
    BOOL_VEC3: 35672,
    BOOL_VEC4: 35673,
    FLOAT_MAT2: 35674,
    FLOAT_MAT3: 35675,
    FLOAT_MAT4: 35676,
    SAMPLER_2D: 35678,
    SAMPLER_CUBE: 35680,
    LOW_FLOAT: 36336,
    MEDIUM_FLOAT: 36337,
    HIGH_FLOAT: 36338,
    LOW_INT: 36339,
    MEDIUM_INT: 36340,
    HIGH_INT: 36341,
    FRAMEBUFFER: 36160,
    RENDERBUFFER: 36161,
    RGBA4: 32854,
    RGB5_A1: 32855,
    RGB565: 36194,
    DEPTH_COMPONENT16: 33189,
    STENCIL_INDEX: 6401,
    STENCIL_INDEX8: 36168,
    DEPTH_STENCIL: 34041,
    RENDERBUFFER_WIDTH: 36162,
    RENDERBUFFER_HEIGHT: 36163,
    RENDERBUFFER_INTERNAL_FORMAT: 36164,
    RENDERBUFFER_RED_SIZE: 36176,
    RENDERBUFFER_GREEN_SIZE: 36177,
    RENDERBUFFER_BLUE_SIZE: 36178,
    RENDERBUFFER_ALPHA_SIZE: 36179,
    RENDERBUFFER_DEPTH_SIZE: 36180,
    RENDERBUFFER_STENCIL_SIZE: 36181,
    FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: 36048,
    FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: 36049,
    FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: 36050,
    FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: 36051,
    COLOR_ATTACHMENT0: 36064,
    DEPTH_ATTACHMENT: 36096,
    STENCIL_ATTACHMENT: 36128,
    DEPTH_STENCIL_ATTACHMENT: 33306,
    NONE: 0,
    FRAMEBUFFER_COMPLETE: 36053,
    FRAMEBUFFER_INCOMPLETE_ATTACHMENT: 36054,
    FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: 36055,
    FRAMEBUFFER_INCOMPLETE_DIMENSIONS: 36057,
    FRAMEBUFFER_UNSUPPORTED: 36061,
    FRAMEBUFFER_BINDING: 36006,
    RENDERBUFFER_BINDING: 36007,
    READ_FRAMEBUFFER: 36008,
    DRAW_FRAMEBUFFER: 36009,
    MAX_RENDERBUFFER_SIZE: 34024,
    INVALID_FRAMEBUFFER_OPERATION: 1286,
    UNPACK_FLIP_Y_WEBGL: 37440,
    UNPACK_PREMULTIPLY_ALPHA_WEBGL: 37441,
    UNPACK_COLORSPACE_CONVERSION_WEBGL: 37443,
    READ_BUFFER: 3074,
    UNPACK_ROW_LENGTH: 3314,
    UNPACK_SKIP_ROWS: 3315,
    UNPACK_SKIP_PIXELS: 3316,
    PACK_ROW_LENGTH: 3330,
    PACK_SKIP_ROWS: 3331,
    PACK_SKIP_PIXELS: 3332,
    TEXTURE_BINDING_3D: 32874,
    UNPACK_SKIP_IMAGES: 32877,
    UNPACK_IMAGE_HEIGHT: 32878,
    MAX_3D_TEXTURE_SIZE: 32883,
    MAX_ELEMENTS_VERTICES: 33e3,
    MAX_ELEMENTS_INDICES: 33001,
    MAX_TEXTURE_LOD_BIAS: 34045,
    MAX_FRAGMENT_UNIFORM_COMPONENTS: 35657,
    MAX_VERTEX_UNIFORM_COMPONENTS: 35658,
    MAX_ARRAY_TEXTURE_LAYERS: 35071,
    MIN_PROGRAM_TEXEL_OFFSET: 35076,
    MAX_PROGRAM_TEXEL_OFFSET: 35077,
    MAX_VARYING_COMPONENTS: 35659,
    FRAGMENT_SHADER_DERIVATIVE_HINT: 35723,
    RASTERIZER_DISCARD: 35977,
    VERTEX_ARRAY_BINDING: 34229,
    MAX_VERTEX_OUTPUT_COMPONENTS: 37154,
    MAX_FRAGMENT_INPUT_COMPONENTS: 37157,
    MAX_SERVER_WAIT_TIMEOUT: 37137,
    MAX_ELEMENT_INDEX: 36203,
    RED: 6403,
    RGB8: 32849,
    RGBA8: 32856,
    RGB10_A2: 32857,
    TEXTURE_3D: 32879,
    TEXTURE_WRAP_R: 32882,
    TEXTURE_MIN_LOD: 33082,
    TEXTURE_MAX_LOD: 33083,
    TEXTURE_BASE_LEVEL: 33084,
    TEXTURE_MAX_LEVEL: 33085,
    TEXTURE_COMPARE_MODE: 34892,
    TEXTURE_COMPARE_FUNC: 34893,
    SRGB: 35904,
    SRGB8: 35905,
    SRGB8_ALPHA8: 35907,
    COMPARE_REF_TO_TEXTURE: 34894,
    RGBA32F: 34836,
    RGB32F: 34837,
    RGBA16F: 34842,
    RGB16F: 34843,
    TEXTURE_2D_ARRAY: 35866,
    TEXTURE_BINDING_2D_ARRAY: 35869,
    R11F_G11F_B10F: 35898,
    RGB9_E5: 35901,
    RGBA32UI: 36208,
    RGB32UI: 36209,
    RGBA16UI: 36214,
    RGB16UI: 36215,
    RGBA8UI: 36220,
    RGB8UI: 36221,
    RGBA32I: 36226,
    RGB32I: 36227,
    RGBA16I: 36232,
    RGB16I: 36233,
    RGBA8I: 36238,
    RGB8I: 36239,
    RED_INTEGER: 36244,
    RGB_INTEGER: 36248,
    RGBA_INTEGER: 36249,
    R8: 33321,
    RG8: 33323,
    R16F: 33325,
    R32F: 33326,
    RG16F: 33327,
    RG32F: 33328,
    R8I: 33329,
    R8UI: 33330,
    R16I: 33331,
    R16UI: 33332,
    R32I: 33333,
    R32UI: 33334,
    RG8I: 33335,
    RG8UI: 33336,
    RG16I: 33337,
    RG16UI: 33338,
    RG32I: 33339,
    RG32UI: 33340,
    R8_SNORM: 36756,
    RG8_SNORM: 36757,
    RGB8_SNORM: 36758,
    RGBA8_SNORM: 36759,
    RGB10_A2UI: 36975,
    TEXTURE_IMMUTABLE_FORMAT: 37167,
    TEXTURE_IMMUTABLE_LEVELS: 33503,
    UNSIGNED_INT_2_10_10_10_REV: 33640,
    UNSIGNED_INT_10F_11F_11F_REV: 35899,
    UNSIGNED_INT_5_9_9_9_REV: 35902,
    FLOAT_32_UNSIGNED_INT_24_8_REV: 36269,
    UNSIGNED_INT_24_8: 34042,
    HALF_FLOAT: 5131,
    RG: 33319,
    RG_INTEGER: 33320,
    INT_2_10_10_10_REV: 36255,
    CURRENT_QUERY: 34917,
    QUERY_RESULT: 34918,
    QUERY_RESULT_AVAILABLE: 34919,
    ANY_SAMPLES_PASSED: 35887,
    ANY_SAMPLES_PASSED_CONSERVATIVE: 36202,
    MAX_DRAW_BUFFERS: 34852,
    DRAW_BUFFER0: 34853,
    DRAW_BUFFER1: 34854,
    DRAW_BUFFER2: 34855,
    DRAW_BUFFER3: 34856,
    DRAW_BUFFER4: 34857,
    DRAW_BUFFER5: 34858,
    DRAW_BUFFER6: 34859,
    DRAW_BUFFER7: 34860,
    DRAW_BUFFER8: 34861,
    DRAW_BUFFER9: 34862,
    DRAW_BUFFER10: 34863,
    DRAW_BUFFER11: 34864,
    DRAW_BUFFER12: 34865,
    DRAW_BUFFER13: 34866,
    DRAW_BUFFER14: 34867,
    DRAW_BUFFER15: 34868,
    MAX_COLOR_ATTACHMENTS: 36063,
    COLOR_ATTACHMENT1: 36065,
    COLOR_ATTACHMENT2: 36066,
    COLOR_ATTACHMENT3: 36067,
    COLOR_ATTACHMENT4: 36068,
    COLOR_ATTACHMENT5: 36069,
    COLOR_ATTACHMENT6: 36070,
    COLOR_ATTACHMENT7: 36071,
    COLOR_ATTACHMENT8: 36072,
    COLOR_ATTACHMENT9: 36073,
    COLOR_ATTACHMENT10: 36074,
    COLOR_ATTACHMENT11: 36075,
    COLOR_ATTACHMENT12: 36076,
    COLOR_ATTACHMENT13: 36077,
    COLOR_ATTACHMENT14: 36078,
    COLOR_ATTACHMENT15: 36079,
    SAMPLER_3D: 35679,
    SAMPLER_2D_SHADOW: 35682,
    SAMPLER_2D_ARRAY: 36289,
    SAMPLER_2D_ARRAY_SHADOW: 36292,
    SAMPLER_CUBE_SHADOW: 36293,
    INT_SAMPLER_2D: 36298,
    INT_SAMPLER_3D: 36299,
    INT_SAMPLER_CUBE: 36300,
    INT_SAMPLER_2D_ARRAY: 36303,
    UNSIGNED_INT_SAMPLER_2D: 36306,
    UNSIGNED_INT_SAMPLER_3D: 36307,
    UNSIGNED_INT_SAMPLER_CUBE: 36308,
    UNSIGNED_INT_SAMPLER_2D_ARRAY: 36311,
    MAX_SAMPLES: 36183,
    SAMPLER_BINDING: 35097,
    PIXEL_PACK_BUFFER: 35051,
    PIXEL_UNPACK_BUFFER: 35052,
    PIXEL_PACK_BUFFER_BINDING: 35053,
    PIXEL_UNPACK_BUFFER_BINDING: 35055,
    COPY_READ_BUFFER: 36662,
    COPY_WRITE_BUFFER: 36663,
    COPY_READ_BUFFER_BINDING: 36662,
    COPY_WRITE_BUFFER_BINDING: 36663,
    FLOAT_MAT2x3: 35685,
    FLOAT_MAT2x4: 35686,
    FLOAT_MAT3x2: 35687,
    FLOAT_MAT3x4: 35688,
    FLOAT_MAT4x2: 35689,
    FLOAT_MAT4x3: 35690,
    UNSIGNED_INT_VEC2: 36294,
    UNSIGNED_INT_VEC3: 36295,
    UNSIGNED_INT_VEC4: 36296,
    UNSIGNED_NORMALIZED: 35863,
    SIGNED_NORMALIZED: 36764,
    VERTEX_ATTRIB_ARRAY_INTEGER: 35069,
    VERTEX_ATTRIB_ARRAY_DIVISOR: 35070,
    TRANSFORM_FEEDBACK_BUFFER_MODE: 35967,
    MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: 35968,
    TRANSFORM_FEEDBACK_VARYINGS: 35971,
    TRANSFORM_FEEDBACK_BUFFER_START: 35972,
    TRANSFORM_FEEDBACK_BUFFER_SIZE: 35973,
    TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN: 35976,
    MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: 35978,
    MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: 35979,
    INTERLEAVED_ATTRIBS: 35980,
    SEPARATE_ATTRIBS: 35981,
    TRANSFORM_FEEDBACK_BUFFER: 35982,
    TRANSFORM_FEEDBACK_BUFFER_BINDING: 35983,
    TRANSFORM_FEEDBACK: 36386,
    TRANSFORM_FEEDBACK_PAUSED: 36387,
    TRANSFORM_FEEDBACK_ACTIVE: 36388,
    TRANSFORM_FEEDBACK_BINDING: 36389,
    FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING: 33296,
    FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE: 33297,
    FRAMEBUFFER_ATTACHMENT_RED_SIZE: 33298,
    FRAMEBUFFER_ATTACHMENT_GREEN_SIZE: 33299,
    FRAMEBUFFER_ATTACHMENT_BLUE_SIZE: 33300,
    FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE: 33301,
    FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE: 33302,
    FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE: 33303,
    FRAMEBUFFER_DEFAULT: 33304,
    DEPTH24_STENCIL8: 35056,
    DRAW_FRAMEBUFFER_BINDING: 36006,
    READ_FRAMEBUFFER_BINDING: 36010,
    RENDERBUFFER_SAMPLES: 36011,
    FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER: 36052,
    FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: 36182,
    UNIFORM_BUFFER: 35345,
    UNIFORM_BUFFER_BINDING: 35368,
    UNIFORM_BUFFER_START: 35369,
    UNIFORM_BUFFER_SIZE: 35370,
    MAX_VERTEX_UNIFORM_BLOCKS: 35371,
    MAX_FRAGMENT_UNIFORM_BLOCKS: 35373,
    MAX_COMBINED_UNIFORM_BLOCKS: 35374,
    MAX_UNIFORM_BUFFER_BINDINGS: 35375,
    MAX_UNIFORM_BLOCK_SIZE: 35376,
    MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: 35377,
    MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: 35379,
    UNIFORM_BUFFER_OFFSET_ALIGNMENT: 35380,
    ACTIVE_UNIFORM_BLOCKS: 35382,
    UNIFORM_TYPE: 35383,
    UNIFORM_SIZE: 35384,
    UNIFORM_BLOCK_INDEX: 35386,
    UNIFORM_OFFSET: 35387,
    UNIFORM_ARRAY_STRIDE: 35388,
    UNIFORM_MATRIX_STRIDE: 35389,
    UNIFORM_IS_ROW_MAJOR: 35390,
    UNIFORM_BLOCK_BINDING: 35391,
    UNIFORM_BLOCK_DATA_SIZE: 35392,
    UNIFORM_BLOCK_ACTIVE_UNIFORMS: 35394,
    UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES: 35395,
    UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER: 35396,
    UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER: 35398,
    OBJECT_TYPE: 37138,
    SYNC_CONDITION: 37139,
    SYNC_STATUS: 37140,
    SYNC_FLAGS: 37141,
    SYNC_FENCE: 37142,
    SYNC_GPU_COMMANDS_COMPLETE: 37143,
    UNSIGNALED: 37144,
    SIGNALED: 37145,
    ALREADY_SIGNALED: 37146,
    TIMEOUT_EXPIRED: 37147,
    CONDITION_SATISFIED: 37148,
    WAIT_FAILED: 37149,
    SYNC_FLUSH_COMMANDS_BIT: 1,
    COLOR: 6144,
    DEPTH: 6145,
    STENCIL: 6146,
    MIN: 32775,
    MAX: 32776,
    DEPTH_COMPONENT24: 33190,
    STREAM_READ: 35041,
    STREAM_COPY: 35042,
    STATIC_READ: 35045,
    STATIC_COPY: 35046,
    DYNAMIC_READ: 35049,
    DYNAMIC_COPY: 35050,
    DEPTH_COMPONENT32F: 36012,
    DEPTH32F_STENCIL8: 36013,
    INVALID_INDEX: 4294967295,
    TIMEOUT_IGNORED: -1,
    MAX_CLIENT_WAIT_TIMEOUT_WEBGL: 37447,
    VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE: 35070,
    UNMASKED_VENDOR_WEBGL: 37445,
    UNMASKED_RENDERER_WEBGL: 37446,
    MAX_TEXTURE_MAX_ANISOTROPY_EXT: 34047,
    TEXTURE_MAX_ANISOTROPY_EXT: 34046,
    COMPRESSED_RGB_S3TC_DXT1_EXT: 33776,
    COMPRESSED_RGBA_S3TC_DXT1_EXT: 33777,
    COMPRESSED_RGBA_S3TC_DXT3_EXT: 33778,
    COMPRESSED_RGBA_S3TC_DXT5_EXT: 33779,
    COMPRESSED_R11_EAC: 37488,
    COMPRESSED_SIGNED_R11_EAC: 37489,
    COMPRESSED_RG11_EAC: 37490,
    COMPRESSED_SIGNED_RG11_EAC: 37491,
    COMPRESSED_RGB8_ETC2: 37492,
    COMPRESSED_RGBA8_ETC2_EAC: 37493,
    COMPRESSED_SRGB8_ETC2: 37494,
    COMPRESSED_SRGB8_ALPHA8_ETC2_EAC: 37495,
    COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37496,
    COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37497,
    COMPRESSED_RGB_PVRTC_4BPPV1_IMG: 35840,
    COMPRESSED_RGBA_PVRTC_4BPPV1_IMG: 35842,
    COMPRESSED_RGB_PVRTC_2BPPV1_IMG: 35841,
    COMPRESSED_RGBA_PVRTC_2BPPV1_IMG: 35843,
    COMPRESSED_RGB_ETC1_WEBGL: 36196,
    COMPRESSED_RGB_ATC_WEBGL: 35986,
    COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL: 35986,
    COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL: 34798,
    UNSIGNED_INT_24_8_WEBGL: 34042,
    HALF_FLOAT_OES: 36193,
    RGBA32F_EXT: 34836,
    RGB32F_EXT: 34837,
    FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT: 33297,
    UNSIGNED_NORMALIZED_EXT: 35863,
    MIN_EXT: 32775,
    MAX_EXT: 32776,
    SRGB_EXT: 35904,
    SRGB_ALPHA_EXT: 35906,
    SRGB8_ALPHA8_EXT: 35907,
    FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT: 33296,
    FRAGMENT_SHADER_DERIVATIVE_HINT_OES: 35723,
    COLOR_ATTACHMENT0_WEBGL: 36064,
    COLOR_ATTACHMENT1_WEBGL: 36065,
    COLOR_ATTACHMENT2_WEBGL: 36066,
    COLOR_ATTACHMENT3_WEBGL: 36067,
    COLOR_ATTACHMENT4_WEBGL: 36068,
    COLOR_ATTACHMENT5_WEBGL: 36069,
    COLOR_ATTACHMENT6_WEBGL: 36070,
    COLOR_ATTACHMENT7_WEBGL: 36071,
    COLOR_ATTACHMENT8_WEBGL: 36072,
    COLOR_ATTACHMENT9_WEBGL: 36073,
    COLOR_ATTACHMENT10_WEBGL: 36074,
    COLOR_ATTACHMENT11_WEBGL: 36075,
    COLOR_ATTACHMENT12_WEBGL: 36076,
    COLOR_ATTACHMENT13_WEBGL: 36077,
    COLOR_ATTACHMENT14_WEBGL: 36078,
    COLOR_ATTACHMENT15_WEBGL: 36079,
    DRAW_BUFFER0_WEBGL: 34853,
    DRAW_BUFFER1_WEBGL: 34854,
    DRAW_BUFFER2_WEBGL: 34855,
    DRAW_BUFFER3_WEBGL: 34856,
    DRAW_BUFFER4_WEBGL: 34857,
    DRAW_BUFFER5_WEBGL: 34858,
    DRAW_BUFFER6_WEBGL: 34859,
    DRAW_BUFFER7_WEBGL: 34860,
    DRAW_BUFFER8_WEBGL: 34861,
    DRAW_BUFFER9_WEBGL: 34862,
    DRAW_BUFFER10_WEBGL: 34863,
    DRAW_BUFFER11_WEBGL: 34864,
    DRAW_BUFFER12_WEBGL: 34865,
    DRAW_BUFFER13_WEBGL: 34866,
    DRAW_BUFFER14_WEBGL: 34867,
    DRAW_BUFFER15_WEBGL: 34868,
    MAX_COLOR_ATTACHMENTS_WEBGL: 36063,
    MAX_DRAW_BUFFERS_WEBGL: 34852,
    VERTEX_ARRAY_BINDING_OES: 34229,
    QUERY_COUNTER_BITS_EXT: 34916,
    CURRENT_QUERY_EXT: 34917,
    QUERY_RESULT_EXT: 34918,
    QUERY_RESULT_AVAILABLE_EXT: 34919,
    TIME_ELAPSED_EXT: 35007,
    TIMESTAMP_EXT: 36392,
    GPU_DISJOINT_EXT: 36795
  };

  // src/data-filter/aggregator.ts
  var AGGREGATE_VS = `#define SHADER_NAME data-filter-vertex-shader

#ifdef FLOAT_TARGET
  attribute float filterIndices;
  attribute float filterPrevIndices;
#else
  attribute vec2 filterIndices;
  attribute vec2 filterPrevIndices;
#endif

varying vec4 vColor;
const float component = 1.0 / 255.0;

void main() {
  #ifdef FLOAT_TARGET
    dataFilter_value *= float(filterIndices != filterPrevIndices);
    gl_Position = vec4(0.0, 0.0, 0.0, 1.0);
    vColor = vec4(0.0, 0.0, 0.0, 1.0);
  #else
    // Float texture is not supported: pack result into 4 channels x 256 px x 64px
    dataFilter_value *= float(filterIndices.x != filterPrevIndices.x);
    float col = filterIndices.x;
    float row = filterIndices.y * 4.0;
    float channel = floor(row);
    row = fract(row);
    vColor = component * vec4(bvec4(channel == 0.0, channel == 1.0, channel == 2.0, channel == 3.0));
    gl_Position = vec4(col * 2.0 - 1.0, row * 2.0 - 1.0, 0.0, 1.0);
  #endif
  gl_PointSize = 1.0;
}
`;
  var AGGREGATE_FS = `#define SHADER_NAME data-filter-fragment-shader
precision highp float;

varying vec4 vColor;

void main() {
  if (dataFilter_value < 0.5) {
    discard;
  }
  gl_FragColor = vColor;
}
`;
  function supportsFloatTarget(gl) {
    return Boolean(gl.getExtension("EXT_float_blend") && (gl.getExtension("EXT_color_buffer_float") || gl.getExtension("WEBGL_color_buffer_float")));
  }
  function getFramebuffer(gl, useFloatTarget) {
    if (useFloatTarget) {
      return new import_core4.Framebuffer(gl, {
        width: 1,
        height: 1,
        attachments: {
          [esm_default.COLOR_ATTACHMENT0]: new import_core4.Texture2D(gl, {
            format: (0, import_core4.isWebGL2)(gl) ? esm_default.RGBA32F : esm_default.RGBA,
            type: esm_default.FLOAT,
            mipmaps: false
          })
        }
      });
    }
    return new import_core4.Framebuffer(gl, {
      width: 256,
      height: 64,
      depth: false
    });
  }
  function getModel(gl, shaderOptions, useFloatTarget) {
    shaderOptions.defines.NON_INSTANCED_MODEL = 1;
    if (useFloatTarget) {
      shaderOptions.defines.FLOAT_TARGET = 1;
    }
    return new import_core4.Model(gl, {
      id: "data-filter-aggregation-model",
      vertexCount: 1,
      isInstanced: false,
      drawMode: esm_default.POINTS,
      vs: AGGREGATE_VS,
      fs: AGGREGATE_FS,
      ...shaderOptions
    });
  }
  var parameters = {
    blend: true,
    blendFunc: [esm_default.ONE, esm_default.ONE, esm_default.ONE, esm_default.ONE],
    blendEquation: [esm_default.FUNC_ADD, esm_default.FUNC_ADD],
    depthTest: false
  };

  // src/data-filter/data-filter-extension.ts
  var import_core6 = __toESM(require_core2());
  var defaultProps2 = {
    getFilterValue: {
      type: "accessor",
      value: 0
    },
    onFilteredItemsChange: {
      type: "function",
      value: null,
      optional: true
    },
    filterEnabled: true,
    filterRange: [-1, 1],
    filterSoftRange: null,
    filterTransformSize: true,
    filterTransformColor: true
  };
  var DATA_TYPE_FROM_SIZE = {
    1: "float",
    2: "vec2",
    3: "vec3",
    4: "vec4"
  };
  var DataFilterExtension = class extends import_core5.LayerExtension {
    constructor({
      filterSize = 1,
      fp64: fp642 = false,
      countItems = false
    } = {}) {
      if (!DATA_TYPE_FROM_SIZE[filterSize]) {
        throw new Error("filterSize out of range");
      }
      super({
        filterSize,
        fp64: fp642,
        countItems
      });
    }
    getShaders(extension) {
      const {
        filterSize,
        fp64: fp642
      } = extension.opts;
      return {
        modules: [fp642 ? shaderModule64 : shaderModule],
        defines: {
          DATAFILTER_TYPE: DATA_TYPE_FROM_SIZE[filterSize],
          DATAFILTER_DOUBLE: Boolean(fp642)
        }
      };
    }
    initializeState(context, extension) {
      const attributeManager = this.getAttributeManager();
      if (attributeManager) {
        attributeManager.add({
          filterValues: {
            size: extension.opts.filterSize,
            type: extension.opts.fp64 ? esm_default.DOUBLE : esm_default.FLOAT,
            accessor: "getFilterValue",
            shaderAttributes: {
              filterValues: {
                divisor: 0
              },
              instanceFilterValues: {
                divisor: 1
              }
            }
          }
        });
      }
      const {
        gl
      } = this.context;
      if (attributeManager && extension.opts.countItems) {
        const useFloatTarget = supportsFloatTarget(gl);
        attributeManager.add({
          filterIndices: {
            size: useFloatTarget ? 1 : 2,
            vertexOffset: 1,
            type: esm_default.UNSIGNED_BYTE,
            normalized: true,
            accessor: (object, {
              index
            }) => {
              const i = object && object.__source ? object.__source.index : index;
              return useFloatTarget ? (i + 1) % 255 : [(i + 1) % 255, Math.floor(i / 255) % 255];
            },
            shaderAttributes: {
              filterPrevIndices: {
                vertexOffset: 0
              },
              filterIndices: {
                vertexOffset: 1
              }
            }
          }
        });
        const filterFBO = getFramebuffer(gl, useFloatTarget);
        const filterModel = getModel(gl, extension.getShaders.call(this, extension), useFloatTarget);
        this.setState({
          filterFBO,
          filterModel
        });
      }
    }
    updateState({
      props,
      oldProps
    }) {
      if (this.state.filterModel) {
        const attributeManager = this.getAttributeManager();
        const filterNeedsUpdate = attributeManager.attributes.filterValues.needsUpdate() || props.filterEnabled !== oldProps.filterEnabled || props.filterRange !== oldProps.filterRange || props.filterSoftRange !== oldProps.filterSoftRange;
        if (filterNeedsUpdate) {
          this.setState({
            filterNeedsUpdate
          });
        }
      }
    }
    draw(params, extension) {
      const {
        filterFBO,
        filterModel,
        filterNeedsUpdate
      } = this.state;
      const {
        onFilteredItemsChange
      } = this.props;
      if (filterNeedsUpdate && onFilteredItemsChange && filterModel) {
        const {
          attributes: {
            filterValues,
            filterIndices
          }
        } = this.getAttributeManager();
        filterModel.setVertexCount(this.getNumInstances());
        const {
          gl
        } = this.context;
        (0, import_core6.clear)(gl, {
          framebuffer: filterFBO,
          color: [0, 0, 0, 0]
        });
        filterModel.updateModuleSettings(params.moduleParameters).setAttributes({
          ...filterValues.getShaderAttributes(),
          ...filterIndices && filterIndices.getShaderAttributes()
        }).draw({
          framebuffer: filterFBO,
          parameters: {
            ...parameters,
            viewport: [0, 0, filterFBO.width, filterFBO.height]
          }
        });
        const color = (0, import_core6.readPixelsToArray)(filterFBO);
        let count = 0;
        for (let i = 0; i < color.length; i++) {
          count += color[i];
        }
        onFilteredItemsChange({
          id: this.id,
          count
        });
        this.state.filterNeedsUpdate = false;
      }
    }
    finalizeState() {
      const {
        filterFBO,
        filterModel
      } = this.state;
      if (filterFBO) {
        filterFBO.color.delete();
        filterFBO.delete();
        filterModel.delete();
      }
    }
  };
  __publicField(DataFilterExtension, "defaultProps", defaultProps2);
  __publicField(DataFilterExtension, "extensionName", "DataFilterExtension");

  // src/fp64/fp64-extension.ts
  var import_core8 = __toESM(require_core());

  // ../../node_modules/@luma.gl/shadertools/dist/esm/modules/fp64/fp64-utils.js
  function fp64ify(a) {
    let out = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : [];
    let startIndex = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : 0;
    const hiPart = Math.fround(a);
    const loPart = a - hiPart;
    out[startIndex] = hiPart;
    out[startIndex + 1] = loPart;
    return out;
  }
  function fp64LowPart(a) {
    return a - Math.fround(a);
  }
  function fp64ifyMatrix4(matrix) {
    const matrixFP64 = new Float32Array(32);
    for (let i = 0; i < 4; ++i) {
      for (let j = 0; j < 4; ++j) {
        const index = i * 4 + j;
        fp64ify(matrix[j * 4 + i], matrixFP64, index * 2);
      }
    }
    return matrixFP64;
  }

  // ../../node_modules/@luma.gl/shadertools/dist/esm/modules/fp64/fp64-arithmetic.glsl.js
  var fp64_arithmetic_glsl_default = "uniform float ONE;\nvec2 split(float a) {\n  const float SPLIT = 4097.0;\n  float t = a * SPLIT;\n#if defined(LUMA_FP64_CODE_ELIMINATION_WORKAROUND)\n  float a_hi = t * ONE - (t - a);\n  float a_lo = a * ONE - a_hi;\n#else\n  float a_hi = t - (t - a);\n  float a_lo = a - a_hi;\n#endif\n  return vec2(a_hi, a_lo);\n}\nvec2 split2(vec2 a) {\n  vec2 b = split(a.x);\n  b.y += a.y;\n  return b;\n}\nvec2 quickTwoSum(float a, float b) {\n#if defined(LUMA_FP64_CODE_ELIMINATION_WORKAROUND)\n  float sum = (a + b) * ONE;\n  float err = b - (sum - a) * ONE;\n#else\n  float sum = a + b;\n  float err = b - (sum - a);\n#endif\n  return vec2(sum, err);\n}\nvec2 twoSum(float a, float b) {\n  float s = (a + b);\n#if defined(LUMA_FP64_CODE_ELIMINATION_WORKAROUND)\n  float v = (s * ONE - a) * ONE;\n  float err = (a - (s - v) * ONE) * ONE * ONE * ONE + (b - v);\n#else\n  float v = s - a;\n  float err = (a - (s - v)) + (b - v);\n#endif\n  return vec2(s, err);\n}\n\nvec2 twoSub(float a, float b) {\n  float s = (a - b);\n#if defined(LUMA_FP64_CODE_ELIMINATION_WORKAROUND)\n  float v = (s * ONE - a) * ONE;\n  float err = (a - (s - v) * ONE) * ONE * ONE * ONE - (b + v);\n#else\n  float v = s - a;\n  float err = (a - (s - v)) - (b + v);\n#endif\n  return vec2(s, err);\n}\n\nvec2 twoSqr(float a) {\n  float prod = a * a;\n  vec2 a_fp64 = split(a);\n#if defined(LUMA_FP64_CODE_ELIMINATION_WORKAROUND)\n  float err = ((a_fp64.x * a_fp64.x - prod) * ONE + 2.0 * a_fp64.x *\n    a_fp64.y * ONE * ONE) + a_fp64.y * a_fp64.y * ONE * ONE * ONE;\n#else\n  float err = ((a_fp64.x * a_fp64.x - prod) + 2.0 * a_fp64.x * a_fp64.y) + a_fp64.y * a_fp64.y;\n#endif\n  return vec2(prod, err);\n}\n\nvec2 twoProd(float a, float b) {\n  float prod = a * b;\n  vec2 a_fp64 = split(a);\n  vec2 b_fp64 = split(b);\n  float err = ((a_fp64.x * b_fp64.x - prod) + a_fp64.x * b_fp64.y +\n    a_fp64.y * b_fp64.x) + a_fp64.y * b_fp64.y;\n  return vec2(prod, err);\n}\n\nvec2 sum_fp64(vec2 a, vec2 b) {\n  vec2 s, t;\n  s = twoSum(a.x, b.x);\n  t = twoSum(a.y, b.y);\n  s.y += t.x;\n  s = quickTwoSum(s.x, s.y);\n  s.y += t.y;\n  s = quickTwoSum(s.x, s.y);\n  return s;\n}\n\nvec2 sub_fp64(vec2 a, vec2 b) {\n  vec2 s, t;\n  s = twoSub(a.x, b.x);\n  t = twoSub(a.y, b.y);\n  s.y += t.x;\n  s = quickTwoSum(s.x, s.y);\n  s.y += t.y;\n  s = quickTwoSum(s.x, s.y);\n  return s;\n}\n\nvec2 mul_fp64(vec2 a, vec2 b) {\n  vec2 prod = twoProd(a.x, b.x);\n  prod.y += a.x * b.y;\n#if defined(LUMA_FP64_HIGH_BITS_OVERFLOW_WORKAROUND)\n  prod = split2(prod);\n#endif\n  prod = quickTwoSum(prod.x, prod.y);\n  prod.y += a.y * b.x;\n#if defined(LUMA_FP64_HIGH_BITS_OVERFLOW_WORKAROUND)\n  prod = split2(prod);\n#endif\n  prod = quickTwoSum(prod.x, prod.y);\n  return prod;\n}\n\nvec2 div_fp64(vec2 a, vec2 b) {\n  float xn = 1.0 / b.x;\n#if defined(LUMA_FP64_HIGH_BITS_OVERFLOW_WORKAROUND)\n  vec2 yn = mul_fp64(a, vec2(xn, 0));\n#else\n  vec2 yn = a * xn;\n#endif\n  float diff = (sub_fp64(a, mul_fp64(b, yn))).x;\n  vec2 prod = twoProd(xn, diff);\n  return sum_fp64(yn, prod);\n}\n\nvec2 sqrt_fp64(vec2 a) {\n  if (a.x == 0.0 && a.y == 0.0) return vec2(0.0, 0.0);\n  if (a.x < 0.0) return vec2(0.0 / 0.0, 0.0 / 0.0);\n\n  float x = 1.0 / sqrt(a.x);\n  float yn = a.x * x;\n#if defined(LUMA_FP64_CODE_ELIMINATION_WORKAROUND)\n  vec2 yn_sqr = twoSqr(yn) * ONE;\n#else\n  vec2 yn_sqr = twoSqr(yn);\n#endif\n  float diff = sub_fp64(a, yn_sqr).x;\n  vec2 prod = twoProd(x * 0.5, diff);\n#if defined(LUMA_FP64_HIGH_BITS_OVERFLOW_WORKAROUND)\n  return sum_fp64(split(yn), prod);\n#else\n  return sum_fp64(vec2(yn, 0.0), prod);\n#endif\n}\n";

  // ../../node_modules/@luma.gl/shadertools/dist/esm/modules/fp64/fp64-functions.glsl.js
  var fp64_functions_glsl_default = "const vec2 E_FP64 = vec2(2.7182817459106445e+00, 8.254840366817007e-08);\nconst vec2 LOG2_FP64 = vec2(0.6931471824645996e+00, -1.9046542121259336e-09);\nconst vec2 PI_FP64 = vec2(3.1415927410125732, -8.742278012618954e-8);\nconst vec2 TWO_PI_FP64 = vec2(6.2831854820251465, -1.7484556025237907e-7);\nconst vec2 PI_2_FP64 = vec2(1.5707963705062866, -4.371139006309477e-8);\nconst vec2 PI_4_FP64 = vec2(0.7853981852531433, -2.1855695031547384e-8);\nconst vec2 PI_16_FP64 = vec2(0.19634954631328583, -5.463923757886846e-9);\nconst vec2 PI_16_2_FP64 = vec2(0.39269909262657166, -1.0927847515773692e-8);\nconst vec2 PI_16_3_FP64 = vec2(0.5890486240386963, -1.4906100798128818e-9);\nconst vec2 PI_180_FP64 = vec2(0.01745329238474369, 1.3519960498364902e-10);\n\nconst vec2 SIN_TABLE_0_FP64 = vec2(0.19509032368659973, -1.6704714833615242e-9);\nconst vec2 SIN_TABLE_1_FP64 = vec2(0.3826834261417389, 6.22335089017767e-9);\nconst vec2 SIN_TABLE_2_FP64 = vec2(0.5555702447891235, -1.1769521357507529e-8);\nconst vec2 SIN_TABLE_3_FP64 = vec2(0.7071067690849304, 1.2101617041793133e-8);\n\nconst vec2 COS_TABLE_0_FP64 = vec2(0.9807852506637573, 2.9739473106360492e-8);\nconst vec2 COS_TABLE_1_FP64 = vec2(0.9238795042037964, 2.8307490351764386e-8);\nconst vec2 COS_TABLE_2_FP64 = vec2(0.8314695954322815, 1.6870263741530778e-8);\nconst vec2 COS_TABLE_3_FP64 = vec2(0.7071067690849304, 1.2101617152815436e-8);\n\nconst vec2 INVERSE_FACTORIAL_3_FP64 = vec2(1.666666716337204e-01, -4.967053879312289e-09);\nconst vec2 INVERSE_FACTORIAL_4_FP64 = vec2(4.16666679084301e-02, -1.2417634698280722e-09);\nconst vec2 INVERSE_FACTORIAL_5_FP64 = vec2(8.333333767950535e-03, -4.34617203337595e-10);\nconst vec2 INVERSE_FACTORIAL_6_FP64 = vec2(1.3888889225199819e-03, -3.3631094437103215e-11);\nconst vec2 INVERSE_FACTORIAL_7_FP64 = vec2(1.9841270113829523e-04,  -2.725596874933456e-12);\nconst vec2 INVERSE_FACTORIAL_8_FP64 = vec2(2.4801587642286904e-05, -3.406996025904184e-13);\nconst vec2 INVERSE_FACTORIAL_9_FP64 = vec2(2.75573188446287533e-06, 3.7935713937038186e-14);\nconst vec2 INVERSE_FACTORIAL_10_FP64 = vec2(2.755731998149713e-07, -7.575112367869873e-15);\n\nfloat nint(float d) {\n    if (d == floor(d)) return d;\n    return floor(d + 0.5);\n}\n\nvec2 nint_fp64(vec2 a) {\n    float hi = nint(a.x);\n    float lo;\n    vec2 tmp;\n    if (hi == a.x) {\n        lo = nint(a.y);\n        tmp = quickTwoSum(hi, lo);\n    } else {\n        lo = 0.0;\n        if (abs(hi - a.x) == 0.5 && a.y < 0.0) {\n            hi -= 1.0;\n        }\n        tmp = vec2(hi, lo);\n    }\n    return tmp;\n}\n\nvec2 exp_fp64(vec2 a) {\n\n  const int k_power = 4;\n  const float k = 16.0;\n\n  const float inv_k = 1.0 / k;\n\n  if (a.x <= -88.0) return vec2(0.0, 0.0);\n  if (a.x >= 88.0) return vec2(1.0 / 0.0, 1.0 / 0.0);\n  if (a.x == 0.0 && a.y == 0.0) return vec2(1.0, 0.0);\n  if (a.x == 1.0 && a.y == 0.0) return E_FP64;\n\n  float m = floor(a.x / LOG2_FP64.x + 0.5);\n  vec2 r = sub_fp64(a, mul_fp64(LOG2_FP64, vec2(m, 0.0))) * inv_k;\n  vec2 s, t, p;\n\n  p = mul_fp64(r, r);\n  s = sum_fp64(r, p * 0.5);\n  p = mul_fp64(p, r);\n  t = mul_fp64(p, INVERSE_FACTORIAL_3_FP64);\n\n  s = sum_fp64(s, t);\n  p = mul_fp64(p, r);\n  t = mul_fp64(p, INVERSE_FACTORIAL_4_FP64);\n\n  s = sum_fp64(s, t);\n  p = mul_fp64(p, r);\n  t = mul_fp64(p, INVERSE_FACTORIAL_5_FP64);\n\n\n\n\n\n\n  s = sum_fp64(s, t);\n  for (int i = 0; i < k_power; i++) {\n    s = sum_fp64(s * 2.0, mul_fp64(s, s));\n  }\n\n#if defined(NVIDIA_FP64_WORKAROUND) || defined(INTEL_FP64_WORKAROUND)\n  s = sum_fp64(s, vec2(ONE, 0.0));\n#else\n  s = sum_fp64(s, vec2(1.0, 0.0));\n#endif\n\n  return s * pow(2.0, m);\n}\n\nvec2 log_fp64(vec2 a)\n{\n  if (a.x == 1.0 && a.y == 0.0) return vec2(0.0, 0.0);\n  if (a.x <= 0.0) return vec2(0.0 / 0.0, 0.0 / 0.0);\n  vec2 x = vec2(log(a.x), 0.0);\n  vec2 s;\n#if defined(NVIDIA_FP64_WORKAROUND) || defined(INTEL_FP64_WORKAROUND)\n  s = vec2(ONE, 0.0);\n#else\n  s = vec2(1.0, 0.0);\n#endif\n\n  x = sub_fp64(sum_fp64(x, mul_fp64(a, exp_fp64(-x))), s);\n  return x;\n}\n\nvec2 sin_taylor_fp64(vec2 a) {\n  vec2 r, s, t, x;\n\n  if (a.x == 0.0 && a.y == 0.0) {\n    return vec2(0.0, 0.0);\n  }\n\n  x = -mul_fp64(a, a);\n  s = a;\n  r = a;\n\n  r = mul_fp64(r, x);\n  t = mul_fp64(r, INVERSE_FACTORIAL_3_FP64);\n  s = sum_fp64(s, t);\n\n  r = mul_fp64(r, x);\n  t = mul_fp64(r, INVERSE_FACTORIAL_5_FP64);\n  s = sum_fp64(s, t);\n\n\n\n\n\n\n  return s;\n}\n\nvec2 cos_taylor_fp64(vec2 a) {\n  vec2 r, s, t, x;\n\n  if (a.x == 0.0 && a.y == 0.0) {\n    return vec2(1.0, 0.0);\n  }\n\n  x = -mul_fp64(a, a);\n  r = x;\n  s = sum_fp64(vec2(1.0, 0.0), r * 0.5);\n\n  r = mul_fp64(r, x);\n  t = mul_fp64(r, INVERSE_FACTORIAL_4_FP64);\n  s = sum_fp64(s, t);\n\n  r = mul_fp64(r, x);\n  t = mul_fp64(r, INVERSE_FACTORIAL_6_FP64);\n  s = sum_fp64(s, t);\n\n\n\n\n\n\n  return s;\n}\n\nvoid sincos_taylor_fp64(vec2 a, out vec2 sin_t, out vec2 cos_t) {\n  if (a.x == 0.0 && a.y == 0.0) {\n    sin_t = vec2(0.0, 0.0);\n    cos_t = vec2(1.0, 0.0);\n  }\n\n  sin_t = sin_taylor_fp64(a);\n  cos_t = sqrt_fp64(sub_fp64(vec2(1.0, 0.0), mul_fp64(sin_t, sin_t)));\n}\n\nvec2 sin_fp64(vec2 a) {\n    if (a.x == 0.0 && a.y == 0.0) {\n        return vec2(0.0, 0.0);\n    }\n    vec2 z = nint_fp64(div_fp64(a, TWO_PI_FP64));\n    vec2 r = sub_fp64(a, mul_fp64(TWO_PI_FP64, z));\n\n    vec2 t;\n    float q = floor(r.x / PI_2_FP64.x + 0.5);\n    int j = int(q);\n\n    if (j < -2 || j > 2) {\n        return vec2(0.0 / 0.0, 0.0 / 0.0);\n    }\n\n    t = sub_fp64(r, mul_fp64(PI_2_FP64, vec2(q, 0.0)));\n\n    q = floor(t.x / PI_16_FP64.x + 0.5);\n    int k = int(q);\n\n    if (k == 0) {\n        if (j == 0) {\n            return sin_taylor_fp64(t);\n        } else if (j == 1) {\n            return cos_taylor_fp64(t);\n        } else if (j == -1) {\n            return -cos_taylor_fp64(t);\n        } else {\n            return -sin_taylor_fp64(t);\n        }\n    }\n\n    int abs_k = int(abs(float(k)));\n\n    if (abs_k > 4) {\n        return vec2(0.0 / 0.0, 0.0 / 0.0);\n    } else {\n        t = sub_fp64(t, mul_fp64(PI_16_FP64, vec2(q, 0.0)));\n    }\n\n    vec2 u = vec2(0.0, 0.0);\n    vec2 v = vec2(0.0, 0.0);\n\n#if defined(NVIDIA_FP64_WORKAROUND) || defined(INTEL_FP64_WORKAROUND)\n    if (abs(float(abs_k) - 1.0) < 0.5) {\n        u = COS_TABLE_0_FP64;\n        v = SIN_TABLE_0_FP64;\n    } else if (abs(float(abs_k) - 2.0) < 0.5) {\n        u = COS_TABLE_1_FP64;\n        v = SIN_TABLE_1_FP64;\n    } else if (abs(float(abs_k) - 3.0) < 0.5) {\n        u = COS_TABLE_2_FP64;\n        v = SIN_TABLE_2_FP64;\n    } else if (abs(float(abs_k) - 4.0) < 0.5) {\n        u = COS_TABLE_3_FP64;\n        v = SIN_TABLE_3_FP64;\n    }\n#else\n    if (abs_k == 1) {\n        u = COS_TABLE_0_FP64;\n        v = SIN_TABLE_0_FP64;\n    } else if (abs_k == 2) {\n        u = COS_TABLE_1_FP64;\n        v = SIN_TABLE_1_FP64;\n    } else if (abs_k == 3) {\n        u = COS_TABLE_2_FP64;\n        v = SIN_TABLE_2_FP64;\n    } else if (abs_k == 4) {\n        u = COS_TABLE_3_FP64;\n        v = SIN_TABLE_3_FP64;\n    }\n#endif\n\n    vec2 sin_t, cos_t;\n    sincos_taylor_fp64(t, sin_t, cos_t);\n\n\n\n    vec2 result = vec2(0.0, 0.0);\n    if (j == 0) {\n        if (k > 0) {\n            result = sum_fp64(mul_fp64(u, sin_t), mul_fp64(v, cos_t));\n        } else {\n            result = sub_fp64(mul_fp64(u, sin_t), mul_fp64(v, cos_t));\n        }\n    } else if (j == 1) {\n        if (k > 0) {\n            result = sub_fp64(mul_fp64(u, cos_t), mul_fp64(v, sin_t));\n        } else {\n            result = sum_fp64(mul_fp64(u, cos_t), mul_fp64(v, sin_t));\n        }\n    } else if (j == -1) {\n        if (k > 0) {\n            result = sub_fp64(mul_fp64(v, sin_t), mul_fp64(u, cos_t));\n        } else {\n            result = -sum_fp64(mul_fp64(v, sin_t), mul_fp64(u, cos_t));\n        }\n    } else {\n        if (k > 0) {\n            result = -sum_fp64(mul_fp64(u, sin_t), mul_fp64(v, cos_t));\n        } else {\n            result = sub_fp64(mul_fp64(v, cos_t), mul_fp64(u, sin_t));\n        }\n    }\n\n    return result;\n}\n\nvec2 cos_fp64(vec2 a) {\n    if (a.x == 0.0 && a.y == 0.0) {\n        return vec2(1.0, 0.0);\n    }\n    vec2 z = nint_fp64(div_fp64(a, TWO_PI_FP64));\n    vec2 r = sub_fp64(a, mul_fp64(TWO_PI_FP64, z));\n\n    vec2 t;\n    float q = floor(r.x / PI_2_FP64.x + 0.5);\n    int j = int(q);\n\n    if (j < -2 || j > 2) {\n        return vec2(0.0 / 0.0, 0.0 / 0.0);\n    }\n\n    t = sub_fp64(r, mul_fp64(PI_2_FP64, vec2(q, 0.0)));\n\n    q = floor(t.x / PI_16_FP64.x + 0.5);\n    int k = int(q);\n\n    if (k == 0) {\n        if (j == 0) {\n            return cos_taylor_fp64(t);\n        } else if (j == 1) {\n            return -sin_taylor_fp64(t);\n        } else if (j == -1) {\n            return sin_taylor_fp64(t);\n        } else {\n            return -cos_taylor_fp64(t);\n        }\n    }\n\n    int abs_k = int(abs(float(k)));\n\n    if (abs_k > 4) {\n        return vec2(0.0 / 0.0, 0.0 / 0.0);\n    } else {\n        t = sub_fp64(t, mul_fp64(PI_16_FP64, vec2(q, 0.0)));\n    }\n\n    vec2 u = vec2(0.0, 0.0);\n    vec2 v = vec2(0.0, 0.0);\n\n#if defined(NVIDIA_FP64_WORKAROUND) || defined(INTEL_FP64_WORKAROUND)\n    if (abs(float(abs_k) - 1.0) < 0.5) {\n        u = COS_TABLE_0_FP64;\n        v = SIN_TABLE_0_FP64;\n    } else if (abs(float(abs_k) - 2.0) < 0.5) {\n        u = COS_TABLE_1_FP64;\n        v = SIN_TABLE_1_FP64;\n    } else if (abs(float(abs_k) - 3.0) < 0.5) {\n        u = COS_TABLE_2_FP64;\n        v = SIN_TABLE_2_FP64;\n    } else if (abs(float(abs_k) - 4.0) < 0.5) {\n        u = COS_TABLE_3_FP64;\n        v = SIN_TABLE_3_FP64;\n    }\n#else\n    if (abs_k == 1) {\n        u = COS_TABLE_0_FP64;\n        v = SIN_TABLE_0_FP64;\n    } else if (abs_k == 2) {\n        u = COS_TABLE_1_FP64;\n        v = SIN_TABLE_1_FP64;\n    } else if (abs_k == 3) {\n        u = COS_TABLE_2_FP64;\n        v = SIN_TABLE_2_FP64;\n    } else if (abs_k == 4) {\n        u = COS_TABLE_3_FP64;\n        v = SIN_TABLE_3_FP64;\n    }\n#endif\n\n    vec2 sin_t, cos_t;\n    sincos_taylor_fp64(t, sin_t, cos_t);\n\n    vec2 result = vec2(0.0, 0.0);\n    if (j == 0) {\n        if (k > 0) {\n            result = sub_fp64(mul_fp64(u, cos_t), mul_fp64(v, sin_t));\n        } else {\n            result = sum_fp64(mul_fp64(u, cos_t), mul_fp64(v, sin_t));\n        }\n    } else if (j == 1) {\n        if (k > 0) {\n            result = -sum_fp64(mul_fp64(u, sin_t), mul_fp64(v, cos_t));\n        } else {\n            result = sub_fp64(mul_fp64(v, cos_t), mul_fp64(u, sin_t));\n        }\n    } else if (j == -1) {\n        if (k > 0) {\n            result = sum_fp64(mul_fp64(u, sin_t), mul_fp64(v, cos_t));\n        } else {\n            result = sub_fp64(mul_fp64(u, sin_t), mul_fp64(v, cos_t));\n        }\n    } else {\n        if (k > 0) {\n            result = sub_fp64(mul_fp64(v, sin_t), mul_fp64(u, cos_t));\n        } else {\n            result = -sum_fp64(mul_fp64(u, cos_t), mul_fp64(v, sin_t));\n        }\n    }\n\n    return result;\n}\n\nvec2 tan_fp64(vec2 a) {\n    vec2 sin_a;\n    vec2 cos_a;\n\n    if (a.x == 0.0 && a.y == 0.0) {\n        return vec2(0.0, 0.0);\n    }\n    vec2 z = nint_fp64(div_fp64(a, TWO_PI_FP64));\n    vec2 r = sub_fp64(a, mul_fp64(TWO_PI_FP64, z));\n\n    vec2 t;\n    float q = floor(r.x / PI_2_FP64.x + 0.5);\n    int j = int(q);\n\n\n    if (j < -2 || j > 2) {\n        return vec2(0.0 / 0.0, 0.0 / 0.0);\n    }\n\n    t = sub_fp64(r, mul_fp64(PI_2_FP64, vec2(q, 0.0)));\n\n    q = floor(t.x / PI_16_FP64.x + 0.5);\n    int k = int(q);\n    int abs_k = int(abs(float(k)));\n\n    if (abs_k > 4) {\n        return vec2(0.0 / 0.0, 0.0 / 0.0);\n    } else {\n        t = sub_fp64(t, mul_fp64(PI_16_FP64, vec2(q, 0.0)));\n    }\n\n\n    vec2 u = vec2(0.0, 0.0);\n    vec2 v = vec2(0.0, 0.0);\n\n    vec2 sin_t, cos_t;\n    vec2 s, c;\n    sincos_taylor_fp64(t, sin_t, cos_t);\n\n    if (k == 0) {\n        s = sin_t;\n        c = cos_t;\n    } else {\n#if defined(NVIDIA_FP64_WORKAROUND) || defined(INTEL_FP64_WORKAROUND)\n        if (abs(float(abs_k) - 1.0) < 0.5) {\n            u = COS_TABLE_0_FP64;\n            v = SIN_TABLE_0_FP64;\n        } else if (abs(float(abs_k) - 2.0) < 0.5) {\n            u = COS_TABLE_1_FP64;\n            v = SIN_TABLE_1_FP64;\n        } else if (abs(float(abs_k) - 3.0) < 0.5) {\n            u = COS_TABLE_2_FP64;\n            v = SIN_TABLE_2_FP64;\n        } else if (abs(float(abs_k) - 4.0) < 0.5) {\n            u = COS_TABLE_3_FP64;\n            v = SIN_TABLE_3_FP64;\n        }\n#else\n        if (abs_k == 1) {\n            u = COS_TABLE_0_FP64;\n            v = SIN_TABLE_0_FP64;\n        } else if (abs_k == 2) {\n            u = COS_TABLE_1_FP64;\n            v = SIN_TABLE_1_FP64;\n        } else if (abs_k == 3) {\n            u = COS_TABLE_2_FP64;\n            v = SIN_TABLE_2_FP64;\n        } else if (abs_k == 4) {\n            u = COS_TABLE_3_FP64;\n            v = SIN_TABLE_3_FP64;\n        }\n#endif\n        if (k > 0) {\n            s = sum_fp64(mul_fp64(u, sin_t), mul_fp64(v, cos_t));\n            c = sub_fp64(mul_fp64(u, cos_t), mul_fp64(v, sin_t));\n        } else {\n            s = sub_fp64(mul_fp64(u, sin_t), mul_fp64(v, cos_t));\n            c = sum_fp64(mul_fp64(u, cos_t), mul_fp64(v, sin_t));\n        }\n    }\n\n    if (j == 0) {\n        sin_a = s;\n        cos_a = c;\n    } else if (j == 1) {\n        sin_a = c;\n        cos_a = -s;\n    } else if (j == -1) {\n        sin_a = -c;\n        cos_a = s;\n    } else {\n        sin_a = -s;\n        cos_a = -c;\n    }\n    return div_fp64(sin_a, cos_a);\n}\n\nvec2 radians_fp64(vec2 degree) {\n  return mul_fp64(degree, PI_180_FP64);\n}\n\nvec2 mix_fp64(vec2 a, vec2 b, float x) {\n  vec2 range = sub_fp64(b, a);\n  return sum_fp64(a, mul_fp64(range, vec2(x, 0.0)));\n}\n\nvoid vec2_sum_fp64(vec2 a[2], vec2 b[2], out vec2 out_val[2]) {\n    out_val[0] = sum_fp64(a[0], b[0]);\n    out_val[1] = sum_fp64(a[1], b[1]);\n}\n\nvoid vec2_sub_fp64(vec2 a[2], vec2 b[2], out vec2 out_val[2]) {\n    out_val[0] = sub_fp64(a[0], b[0]);\n    out_val[1] = sub_fp64(a[1], b[1]);\n}\n\nvoid vec2_mul_fp64(vec2 a[2], vec2 b[2], out vec2 out_val[2]) {\n    out_val[0] = mul_fp64(a[0], b[0]);\n    out_val[1] = mul_fp64(a[1], b[1]);\n}\n\nvoid vec2_div_fp64(vec2 a[2], vec2 b[2], out vec2 out_val[2]) {\n    out_val[0] = div_fp64(a[0], b[0]);\n    out_val[1] = div_fp64(a[1], b[1]);\n}\n\nvoid vec2_mix_fp64(vec2 x[2], vec2 y[2], float a, out vec2 out_val[2]) {\n  vec2 range[2];\n  vec2_sub_fp64(y, x, range);\n  vec2 portion[2];\n  portion[0] = range[0] * a;\n  portion[1] = range[1] * a;\n  vec2_sum_fp64(x, portion, out_val);\n}\n\nvec2 vec2_length_fp64(vec2 x[2]) {\n  return sqrt_fp64(sum_fp64(mul_fp64(x[0], x[0]), mul_fp64(x[1], x[1])));\n}\n\nvoid vec2_normalize_fp64(vec2 x[2], out vec2 out_val[2]) {\n  vec2 length = vec2_length_fp64(x);\n  vec2 length_vec2[2];\n  length_vec2[0] = length;\n  length_vec2[1] = length;\n\n  vec2_div_fp64(x, length_vec2, out_val);\n}\n\nvec2 vec2_distance_fp64(vec2 x[2], vec2 y[2]) {\n  vec2 diff[2];\n  vec2_sub_fp64(x, y, diff);\n  return vec2_length_fp64(diff);\n}\n\nvec2 vec2_dot_fp64(vec2 a[2], vec2 b[2]) {\n  vec2 v[2];\n\n  v[0] = mul_fp64(a[0], b[0]);\n  v[1] = mul_fp64(a[1], b[1]);\n\n  return sum_fp64(v[0], v[1]);\n}\nvoid vec3_sub_fp64(vec2 a[3], vec2 b[3], out vec2 out_val[3]) {\n  for (int i = 0; i < 3; i++) {\n    out_val[i] = sum_fp64(a[i], b[i]);\n  }\n}\n\nvoid vec3_sum_fp64(vec2 a[3], vec2 b[3], out vec2 out_val[3]) {\n  for (int i = 0; i < 3; i++) {\n    out_val[i] = sum_fp64(a[i], b[i]);\n  }\n}\n\nvec2 vec3_length_fp64(vec2 x[3]) {\n  return sqrt_fp64(sum_fp64(sum_fp64(mul_fp64(x[0], x[0]), mul_fp64(x[1], x[1])),\n    mul_fp64(x[2], x[2])));\n}\n\nvec2 vec3_distance_fp64(vec2 x[3], vec2 y[3]) {\n  vec2 diff[3];\n  vec3_sub_fp64(x, y, diff);\n  return vec3_length_fp64(diff);\n}\nvoid vec4_fp64(vec4 a, out vec2 out_val[4]) {\n  out_val[0].x = a[0];\n  out_val[0].y = 0.0;\n\n  out_val[1].x = a[1];\n  out_val[1].y = 0.0;\n\n  out_val[2].x = a[2];\n  out_val[2].y = 0.0;\n\n  out_val[3].x = a[3];\n  out_val[3].y = 0.0;\n}\n\nvoid vec4_scalar_mul_fp64(vec2 a[4], vec2 b, out vec2 out_val[4]) {\n  out_val[0] = mul_fp64(a[0], b);\n  out_val[1] = mul_fp64(a[1], b);\n  out_val[2] = mul_fp64(a[2], b);\n  out_val[3] = mul_fp64(a[3], b);\n}\n\nvoid vec4_sum_fp64(vec2 a[4], vec2 b[4], out vec2 out_val[4]) {\n  for (int i = 0; i < 4; i++) {\n    out_val[i] = sum_fp64(a[i], b[i]);\n  }\n}\n\nvoid vec4_dot_fp64(vec2 a[4], vec2 b[4], out vec2 out_val) {\n  vec2 v[4];\n\n  v[0] = mul_fp64(a[0], b[0]);\n  v[1] = mul_fp64(a[1], b[1]);\n  v[2] = mul_fp64(a[2], b[2]);\n  v[3] = mul_fp64(a[3], b[3]);\n\n  out_val = sum_fp64(sum_fp64(v[0], v[1]), sum_fp64(v[2], v[3]));\n}\n\nvoid mat4_vec4_mul_fp64(vec2 b[16], vec2 a[4], out vec2 out_val[4]) {\n  vec2 tmp[4];\n\n  for (int i = 0; i < 4; i++)\n  {\n    for (int j = 0; j < 4; j++)\n    {\n      tmp[j] = b[j + i * 4];\n    }\n    vec4_dot_fp64(a, tmp, out_val[i]);\n  }\n}\n";

  // ../../node_modules/@luma.gl/shadertools/dist/esm/modules/fp64/fp64.js
  var CONST_UNIFORMS = {
    ONE: 1
  };
  function getUniforms2() {
    return CONST_UNIFORMS;
  }
  var fp64arithmetic = {
    name: "fp64-arithmetic",
    vs: fp64_arithmetic_glsl_default,
    fs: null,
    getUniforms: getUniforms2,
    fp64ify,
    fp64LowPart,
    fp64ifyMatrix4
  };
  var fp64 = {
    name: "fp64",
    vs: fp64_functions_glsl_default,
    fs: null,
    dependencies: [fp64arithmetic],
    fp64ify,
    fp64LowPart,
    fp64ifyMatrix4
  };

  // ../../node_modules/@math.gl/core/dist/esm/lib/common.js
  var RADIANS_TO_DEGREES = 1 / Math.PI * 180;
  var DEGREES_TO_RADIANS = 1 / 180 * Math.PI;
  var config = {
    EPSILON: 1e-12,
    debug: false,
    precision: 4,
    printTypes: false,
    printDegrees: false,
    printRowMajor: true
  };
  function isArray(value) {
    return Array.isArray(value) || ArrayBuffer.isView(value) && !(value instanceof DataView);
  }
  function equals(a, b, epsilon) {
    const oldEpsilon = config.EPSILON;
    if (epsilon) {
      config.EPSILON = epsilon;
    }
    try {
      if (a === b) {
        return true;
      }
      if (isArray(a) && isArray(b)) {
        if (a.length !== b.length) {
          return false;
        }
        for (let i = 0; i < a.length; ++i) {
          if (!equals(a[i], b[i])) {
            return false;
          }
        }
        return true;
      }
      if (a && a.equals) {
        return a.equals(b);
      }
      if (b && b.equals) {
        return b.equals(a);
      }
      if (typeof a === "number" && typeof b === "number") {
        return Math.abs(a - b) <= config.EPSILON * Math.max(1, Math.abs(a), Math.abs(b));
      }
      return false;
    } finally {
      config.EPSILON = oldEpsilon;
    }
  }

  // ../../node_modules/gl-matrix/esm/common.js
  var ARRAY_TYPE = typeof Float32Array !== "undefined" ? Float32Array : Array;
  var degree = Math.PI / 180;
  if (!Math.hypot)
    Math.hypot = function() {
      var y = 0, i = arguments.length;
      while (i--) {
        y += arguments[i] * arguments[i];
      }
      return Math.sqrt(y);
    };

  // ../../node_modules/gl-matrix/esm/vec3.js
  function create() {
    var out = new ARRAY_TYPE(3);
    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
    }
    return out;
  }
  function distance(a, b) {
    var x = b[0] - a[0];
    var y = b[1] - a[1];
    var z = b[2] - a[2];
    return Math.hypot(x, y, z);
  }
  var dist = distance;
  var forEach = function() {
    var vec = create();
    return function(a, stride, offset, count, fn, arg) {
      var i, l;
      if (!stride) {
        stride = 3;
      }
      if (!offset) {
        offset = 0;
      }
      if (count) {
        l = Math.min(count * stride + offset, a.length);
      } else {
        l = a.length;
      }
      for (i = offset; i < l; i += stride) {
        vec[0] = a[i];
        vec[1] = a[i + 1];
        vec[2] = a[i + 2];
        fn(vec, vec, arg);
        a[i] = vec[0];
        a[i + 1] = vec[1];
        a[i + 2] = vec[2];
      }
      return a;
    };
  }();

  // src/fp64/project64.ts
  var import_core7 = __toESM(require_core());

  // src/fp64/project64.glsl.ts
  var project64_glsl_default = `
const vec2 WORLD_SCALE_FP64 = vec2(81.4873275756836, 0.0000032873668232014097);

uniform vec2 project_uViewProjectionMatrixFP64[16];

// longitude: lnglat_fp64.xy; latitude: lnglat_fp64.zw
void mercatorProject_fp64(vec4 lnglat_fp64, out vec2 out_val[2]) {

#if defined(NVIDIA_FP64_WORKAROUND)
  out_val[0] = sum_fp64(radians_fp64(lnglat_fp64.xy), PI_FP64 * ONE);
#else
  out_val[0] = sum_fp64(radians_fp64(lnglat_fp64.xy), PI_FP64);
#endif
  out_val[1] = sum_fp64(PI_FP64,
    log_fp64(tan_fp64(sum_fp64(PI_4_FP64, radians_fp64(lnglat_fp64.zw) / 2.0))));
  return;
}

void project_position_fp64(vec4 position_fp64, out vec2 out_val[2]) {
  vec2 pos_fp64[2];
  mercatorProject_fp64(position_fp64, pos_fp64);
  out_val[0] = mul_fp64(pos_fp64[0], WORLD_SCALE_FP64);
  out_val[1] = mul_fp64(pos_fp64[1], WORLD_SCALE_FP64);

  return;
}

void project_position_fp64(vec2 position, vec2 position64xyLow, out vec2 out_val[2]) {
  vec4 position64xy = vec4(
    position.x, position64xyLow.x,
    position.y, position64xyLow.y);

  project_position_fp64(position64xy, out_val);
}

vec4 project_common_position_to_clipspace_fp64(vec2 vertex_pos_modelspace[4]) {
  vec2 vertex_pos_clipspace[4];
  mat4_vec4_mul_fp64(project_uViewProjectionMatrixFP64, vertex_pos_modelspace,
    vertex_pos_clipspace);
  return vec4(
    vertex_pos_clipspace[0].x,
    vertex_pos_clipspace[1].x,
    vertex_pos_clipspace[2].x,
    vertex_pos_clipspace[3].x
    );
}

vec4 project_position_to_clipspace(
  vec3 position, vec3 position64xyLow, vec3 offset, out vec4 commonPosition
) {
  // This is the local offset to the instance position
  vec2 offset64[4];
  vec4_fp64(vec4(offset, 0.0), offset64);

  float z = project_size(position.z);

  // Apply web mercator projection (depends on coordinate system imn use)
  vec2 projectedPosition64xy[2];
  project_position_fp64(position.xy, position64xyLow.xy, projectedPosition64xy);

  vec2 commonPosition64[4];
  commonPosition64[0] = sum_fp64(offset64[0], projectedPosition64xy[0]);
  commonPosition64[1] = sum_fp64(offset64[1], projectedPosition64xy[1]);
  commonPosition64[2] = sum_fp64(offset64[2], vec2(z, 0.0));
  commonPosition64[3] = vec2(1.0, 0.0);

  commonPosition = vec4(projectedPosition64xy[0].x, projectedPosition64xy[1].x, z, 1.0);

  return project_common_position_to_clipspace_fp64(commonPosition64);
}

vec4 project_position_to_clipspace(
  vec3 position, vec3 position64xyLow, vec3 offset
) {
  vec4 commonPosition;
  return project_position_to_clipspace(
    position, position64xyLow, offset, commonPosition
  );
}
`;

  // src/fp64/project64.ts
  var {
    fp64ify: fp64ify2,
    fp64ifyMatrix4: fp64ifyMatrix42
  } = fp64;
  var project64_default = {
    name: "project64",
    dependencies: [import_core7.project, fp64],
    vs: project64_glsl_default,
    getUniforms: getUniforms3
  };
  var getMemoizedUniforms = (0, import_core7._memoize)(calculateUniforms);
  function getUniforms3(opts) {
    if (opts && "viewport" in opts) {
      const {
        viewProjectionMatrix,
        scale
      } = opts.viewport;
      return getMemoizedUniforms({
        viewProjectionMatrix,
        scale
      });
    }
    return {};
  }
  function calculateUniforms({
    viewProjectionMatrix,
    scale
  }) {
    const glViewProjectionMatrixFP64 = fp64ifyMatrix42(viewProjectionMatrix);
    const scaleFP64 = fp64ify2(scale);
    return {
      project_uViewProjectionMatrixFP64: glViewProjectionMatrixFP64,
      project64_uViewProjectionMatrix: glViewProjectionMatrixFP64,
      project64_uScale: scaleFP64
    };
  }

  // src/fp64/fp64-extension.ts
  var Fp64Extension = class extends import_core8.LayerExtension {
    getShaders() {
      const {
        coordinateSystem
      } = this.props;
      if (coordinateSystem !== import_core8.COORDINATE_SYSTEM.LNGLAT && coordinateSystem !== import_core8.COORDINATE_SYSTEM.DEFAULT) {
        throw new Error("fp64: coordinateSystem must be LNGLAT");
      }
      return {
        modules: [project64_default]
      };
    }
  };
  __publicField(Fp64Extension, "extensionName", "Fp64Extension");

  // src/path-style/path-style-extension.ts
  var import_core9 = __toESM(require_core());

  // src/path-style/shaders.glsl.ts
  var dashShaders = {
    inject: {
      "vs:#decl": `
attribute vec2 instanceDashArrays;
attribute float instanceDashOffsets;
varying vec2 vDashArray;
varying float vDashOffset;
`,
      "vs:#main-end": `
vDashArray = instanceDashArrays;
vDashOffset = instanceDashOffsets / width.x;
`,
      "fs:#decl": `
uniform float dashAlignMode;
uniform float capType;
uniform bool dashGapPickable;
varying vec2 vDashArray;
varying float vDashOffset;

float round(float x) {
  return floor(x + 0.5);
}
`,
      "fs:#main-start": `
  float solidLength = vDashArray.x;
  float gapLength = vDashArray.y;
  float unitLength = solidLength + gapLength;

  float offset;

  if (unitLength > 0.0) {
    if (dashAlignMode == 0.0) {
      offset = vDashOffset;
    } else {
      unitLength = vPathLength / round(vPathLength / unitLength);
      offset = solidLength / 2.0;
    }

    float unitOffset = mod(vPathPosition.y + offset, unitLength);

    if (gapLength > 0.0 && unitOffset > solidLength) {
      if (capType <= 0.5) {
        if (!(dashGapPickable && picking_uActive)) {
          discard;
        }
      } else {
        // caps are rounded, test the distance to solid ends
        float distToEnd = length(vec2(
          min(unitOffset - solidLength, unitLength - unitOffset),
          vPathPosition.x
        ));
        if (distToEnd > 1.0) {
          if (!(dashGapPickable && picking_uActive)) {
            discard;
          }
        }
      }
    }
  }
`
    }
  };
  var offsetShaders = {
    inject: {
      "vs:#decl": `
attribute float instanceOffsets;
`,
      "vs:DECKGL_FILTER_SIZE": `
  float offsetWidth = abs(instanceOffsets * 2.0) + 1.0;
  size *= offsetWidth;
`,
      "vs:#main-end": `
  float offsetWidth = abs(instanceOffsets * 2.0) + 1.0;
  float offsetDir = sign(instanceOffsets);
  vPathPosition.x = (vPathPosition.x + offsetDir) * offsetWidth - offsetDir;
  vPathPosition.y *= offsetWidth;
  vPathLength *= offsetWidth;
`,
      "fs:#main-start": `
  float isInside;
  isInside = step(-1.0, vPathPosition.x) * step(vPathPosition.x, 1.0);
  if (isInside == 0.0) {
    discard;
  }
`
    }
  };

  // src/path-style/path-style-extension.ts
  var defaultProps3 = {
    getDashArray: {
      type: "accessor",
      value: [0, 0]
    },
    getOffset: {
      type: "accessor",
      value: 0
    },
    dashJustified: false,
    dashGapPickable: false
  };
  var PathStyleExtension = class extends import_core9.LayerExtension {
    constructor({
      dash = false,
      offset = false,
      highPrecisionDash = false
    } = {}) {
      super({
        dash: dash || highPrecisionDash,
        offset,
        highPrecisionDash
      });
    }
    isEnabled(layer) {
      return "pathTesselator" in layer.state;
    }
    getShaders(extension) {
      if (!extension.isEnabled(this)) {
        return null;
      }
      let result = {};
      if (extension.opts.dash) {
        result = (0, import_core9._mergeShaders)(result, dashShaders);
      }
      if (extension.opts.offset) {
        result = (0, import_core9._mergeShaders)(result, offsetShaders);
      }
      return result;
    }
    initializeState(context, extension) {
      const attributeManager = this.getAttributeManager();
      if (!attributeManager || !extension.isEnabled(this)) {
        return;
      }
      if (extension.opts.dash) {
        attributeManager.addInstanced({
          instanceDashArrays: {
            size: 2,
            accessor: "getDashArray"
          }
        });
      }
      if (extension.opts.highPrecisionDash) {
        attributeManager.addInstanced({
          instanceDashOffsets: {
            size: 1,
            accessor: "getPath",
            transform: extension.getDashOffsets.bind(this)
          }
        });
      }
      if (extension.opts.offset) {
        attributeManager.addInstanced({
          instanceOffsets: {
            size: 1,
            accessor: "getOffset"
          }
        });
      }
    }
    updateState(params, extension) {
      if (!extension.isEnabled(this)) {
        return;
      }
      const uniforms = {};
      if (extension.opts.dash) {
        uniforms.dashAlignMode = this.props.dashJustified ? 1 : 0;
        uniforms.dashGapPickable = Boolean(this.props.dashGapPickable);
      }
      this.state.model.setUniforms(uniforms);
    }
    getDashOffsets(path) {
      const result = [0];
      const positionSize = this.props.positionFormat === "XY" ? 2 : 3;
      const isNested = Array.isArray(path[0]);
      const geometrySize = isNested ? path.length : path.length / positionSize;
      let p;
      let prevP;
      for (let i = 0; i < geometrySize - 1; i++) {
        p = isNested ? path[i] : path.slice(i * positionSize, i * positionSize + positionSize);
        p = this.projectPosition(p);
        if (i > 0) {
          result[i] = result[i - 1] + dist(prevP, p);
        }
        prevP = p;
      }
      return result;
    }
  };
  __publicField(PathStyleExtension, "defaultProps", defaultProps3);
  __publicField(PathStyleExtension, "extensionName", "PathStyleExtension");

  // src/fill-style/fill-style-extension.ts
  var import_core11 = __toESM(require_core());
  var import_core12 = __toESM(require_core2());

  // src/fill-style/shaders.glsl.ts
  var import_core10 = __toESM(require_core());
  var patternVs = `
#ifdef NON_INSTANCED_MODEL
  #define FILL_PATTERN_FRAME_ATTRIB fillPatternFrames
  #define FILL_PATTERN_SCALE_ATTRIB fillPatternScales
  #define FILL_PATTERN_OFFSET_ATTRIB fillPatternOffsets
#else
  #define FILL_PATTERN_FRAME_ATTRIB instanceFillPatternFrames
  #define FILL_PATTERN_SCALE_ATTRIB instanceFillPatternScales
  #define FILL_PATTERN_OFFSET_ATTRIB instanceFillPatternOffsets
#endif

attribute vec4 FILL_PATTERN_FRAME_ATTRIB;
attribute float FILL_PATTERN_SCALE_ATTRIB;
attribute vec2 FILL_PATTERN_OFFSET_ATTRIB;

uniform bool fill_patternEnabled;
uniform vec2 fill_patternTextureSize;

varying vec2 fill_uv;
varying vec4 fill_patternBounds;
varying vec4 fill_patternPlacement;
`;
  var patternFs = `
uniform bool fill_patternEnabled;
uniform bool fill_patternMask;
uniform sampler2D fill_patternTexture;
uniform vec2 fill_uvCoordinateOrigin;
uniform vec2 fill_uvCoordinateOrigin64Low;

varying vec4 fill_patternBounds;
varying vec4 fill_patternPlacement;
varying vec2 fill_uv;

const float FILL_UV_SCALE = 512.0 / 40000000.0;
`;
  var inject3 = {
    "vs:DECKGL_FILTER_GL_POSITION": `
    fill_uv = geometry.position.xy;
  `,
    "vs:DECKGL_FILTER_COLOR": `
    if (fill_patternEnabled) {
      fill_patternBounds = FILL_PATTERN_FRAME_ATTRIB / vec4(fill_patternTextureSize, fill_patternTextureSize);
      fill_patternPlacement.xy = FILL_PATTERN_OFFSET_ATTRIB;
      fill_patternPlacement.zw = FILL_PATTERN_SCALE_ATTRIB * FILL_PATTERN_FRAME_ATTRIB.zw;
    }
  `,
    "fs:DECKGL_FILTER_COLOR": `
    if (fill_patternEnabled) {
      vec2 scale = FILL_UV_SCALE * fill_patternPlacement.zw;
      vec2 patternUV = mod(mod(fill_uvCoordinateOrigin, scale) + fill_uvCoordinateOrigin64Low + fill_uv, scale) / scale;
      patternUV = mod(fill_patternPlacement.xy + patternUV, 1.0);

      vec2 texCoords = fill_patternBounds.xy + fill_patternBounds.zw * patternUV;

      vec4 patternColor = texture2D(fill_patternTexture, texCoords);
      color.a *= patternColor.a;
      if (!fill_patternMask) {
        color.rgb = patternColor.rgb;
      }
    }
  `
  };
  function getPatternUniforms(opts, uniforms) {
    if (!opts) {
      return {};
    }
    if ("fillPatternTexture" in opts) {
      const {
        fillPatternTexture
      } = opts;
      return {
        fill_patternTexture: fillPatternTexture,
        fill_patternTextureSize: [fillPatternTexture.width, fillPatternTexture.height]
      };
    }
    if ("viewport" in opts) {
      const {
        fillPatternMask = true,
        fillPatternEnabled = true
      } = opts;
      const {
        project_uCommonOrigin: coordinateOriginCommon
      } = uniforms;
      const coordinateOriginCommon64Low = [(0, import_core10.fp64LowPart)(coordinateOriginCommon[0]), (0, import_core10.fp64LowPart)(coordinateOriginCommon[1])];
      return {
        fill_uvCoordinateOrigin: coordinateOriginCommon.slice(0, 2),
        fill_uvCoordinateOrigin64Low: coordinateOriginCommon64Low,
        fill_patternMask: fillPatternMask,
        fill_patternEnabled: fillPatternEnabled
      };
    }
    return {};
  }
  var patternShaders = {
    name: "fill-pattern",
    vs: patternVs,
    fs: patternFs,
    inject: inject3,
    dependencies: [import_core10.project],
    getUniforms: getPatternUniforms
  };

  // src/fill-style/fill-style-extension.ts
  var defaultProps4 = {
    fillPatternEnabled: true,
    fillPatternAtlas: {
      type: "image",
      value: null,
      async: true,
      parameters: {
        [esm_default.TEXTURE_MIN_FILTER]: esm_default.LINEAR
      }
    },
    fillPatternMapping: {
      type: "object",
      value: {},
      async: true
    },
    fillPatternMask: true,
    getFillPattern: {
      type: "accessor",
      value: (d) => d.pattern
    },
    getFillPatternScale: {
      type: "accessor",
      value: 1
    },
    getFillPatternOffset: {
      type: "accessor",
      value: [0, 0]
    }
  };
  var FillStyleExtension = class extends import_core11.LayerExtension {
    constructor({
      pattern = false
    } = {}) {
      super({
        pattern
      });
    }
    isEnabled(layer) {
      return layer.getAttributeManager() !== null && !("pathTesselator" in layer.state);
    }
    getShaders(extension) {
      if (!extension.isEnabled(this)) {
        return null;
      }
      return {
        modules: [extension.opts.pattern && patternShaders].filter(Boolean)
      };
    }
    initializeState(context, extension) {
      if (!extension.isEnabled(this)) {
        return;
      }
      const attributeManager = this.getAttributeManager();
      if (extension.opts.pattern) {
        attributeManager.add({
          fillPatternFrames: {
            size: 4,
            accessor: "getFillPattern",
            transform: extension.getPatternFrame.bind(this),
            shaderAttributes: {
              fillPatternFrames: {
                divisor: 0
              },
              instanceFillPatternFrames: {
                divisor: 1
              }
            }
          },
          fillPatternScales: {
            size: 1,
            accessor: "getFillPatternScale",
            defaultValue: 1,
            shaderAttributes: {
              fillPatternScales: {
                divisor: 0
              },
              instanceFillPatternScales: {
                divisor: 1
              }
            }
          },
          fillPatternOffsets: {
            size: 2,
            accessor: "getFillPatternOffset",
            shaderAttributes: {
              fillPatternOffsets: {
                divisor: 0
              },
              instanceFillPatternOffsets: {
                divisor: 1
              }
            }
          }
        });
      }
      this.setState({
        emptyTexture: new import_core12.Texture2D(this.context.gl, {
          data: new Uint8Array(4),
          width: 1,
          height: 1
        })
      });
    }
    updateState({
      props,
      oldProps
    }, extension) {
      if (!extension.isEnabled(this)) {
        return;
      }
      if (props.fillPatternMapping && props.fillPatternMapping !== oldProps.fillPatternMapping) {
        this.getAttributeManager().invalidate("getFillPattern");
      }
    }
    draw(params, extension) {
      if (!extension.isEnabled(this)) {
        return;
      }
      const {
        fillPatternAtlas
      } = this.props;
      this.setModuleParameters({
        fillPatternTexture: fillPatternAtlas || this.state.emptyTexture
      });
    }
    finalizeState() {
      const {
        emptyTexture
      } = this.state;
      emptyTexture?.delete();
    }
    getPatternFrame(name) {
      const {
        fillPatternMapping
      } = this.getCurrentLayer().props;
      const def = fillPatternMapping && fillPatternMapping[name];
      return def ? [def.x, def.y, def.width, def.height] : [0, 0, 0, 0];
    }
  };
  __publicField(FillStyleExtension, "defaultProps", defaultProps4);
  __publicField(FillStyleExtension, "extensionName", "FillStyleExtension");

  // src/clip/clip-extension.ts
  var import_core13 = __toESM(require_core());
  var defaultProps5 = {
    clipBounds: [0, 0, 1, 1],
    clipByInstance: void 0
  };
  var shaderFunction = `
uniform vec4 clip_bounds;

bool clip_isInBounds(vec2 position) {
  return position.x >= clip_bounds[0] && position.y >= clip_bounds[1] && position.x < clip_bounds[2] && position.y < clip_bounds[3];
}
`;
  var shaderModuleVs = {
    name: "clip-vs",
    vs: shaderFunction
  };
  var injectionVs = {
    "vs:#decl": `
varying float clip_isVisible;
`,
    "vs:DECKGL_FILTER_GL_POSITION": `
  clip_isVisible = float(clip_isInBounds(geometry.worldPosition.xy));
`,
    "fs:#decl": `
varying float clip_isVisible;
`,
    "fs:DECKGL_FILTER_COLOR": `
  if (clip_isVisible < 0.5) discard;
`
  };
  var shaderModuleFs = {
    name: "clip-fs",
    fs: shaderFunction
  };
  var injectionFs = {
    "vs:#decl": `
varying vec2 clip_commonPosition;
`,
    "vs:DECKGL_FILTER_GL_POSITION": `
  clip_commonPosition = geometry.position.xy;
`,
    "fs:#decl": `
varying vec2 clip_commonPosition;
`,
    "fs:DECKGL_FILTER_COLOR": `
  if (!clip_isInBounds(clip_commonPosition)) discard;
`
  };
  var ClipExtension = class extends import_core13.LayerExtension {
    getShaders() {
      let clipByInstance = "instancePositions" in this.getAttributeManager().attributes;
      if (this.props.clipByInstance !== void 0) {
        clipByInstance = Boolean(this.props.clipByInstance);
      }
      this.state.clipByInstance = clipByInstance;
      return clipByInstance ? {
        modules: [shaderModuleVs],
        inject: injectionVs
      } : {
        modules: [shaderModuleFs],
        inject: injectionFs
      };
    }
    draw({
      uniforms
    }) {
      const {
        clipBounds
      } = this.props;
      if (this.state.clipByInstance) {
        uniforms.clip_bounds = clipBounds;
      } else {
        const corner0 = this.projectPosition([clipBounds[0], clipBounds[1], 0]);
        const corner1 = this.projectPosition([clipBounds[2], clipBounds[3], 0]);
        uniforms.clip_bounds = [Math.min(corner0[0], corner1[0]), Math.min(corner0[1], corner1[1]), Math.max(corner0[0], corner1[0]), Math.max(corner0[1], corner1[1])];
      }
    }
  };
  __publicField(ClipExtension, "defaultProps", defaultProps5);
  __publicField(ClipExtension, "extensionName", "ClipExtension");

  // src/collision-filter/collision-filter-extension.ts
  var import_core26 = __toESM(require_core());

  // src/collision-filter/shader-module.ts
  var import_core14 = __toESM(require_core());
  var vs3 = `
#ifdef NON_INSTANCED_MODEL
attribute float collisionPriorities;
#else
attribute float instanceCollisionPriorities;
#endif

uniform sampler2D collision_texture;
uniform bool collision_sort;
uniform bool collision_enabled;

vec2 collision_getCoords(vec4 position) {
  vec4 collision_clipspace = project_common_position_to_clipspace(position);
  return (1.0 + collision_clipspace.xy / collision_clipspace.w) / 2.0;
}

float collision_match(vec2 tex, vec3 pickingColor) {
  vec4 collision_pickingColor = texture2D(collision_texture, tex);
  float delta = dot(abs(collision_pickingColor.rgb - pickingColor), vec3(1.0));
  float e = 0.001;
  return step(delta, e);
}

float collision_isVisible(vec2 texCoords, vec3 pickingColor) {
  if (!collision_enabled) {
    return 1.0;
  }

  // Visibility test, sample area of 5x5 pixels in order to fade in/out.
  // Due to the locality, the lookups will be cached
  // This reduces the flicker present when objects are shown/hidden
  const int N = 2;
  float accumulator = 0.0;
  vec2 step = vec2(1.0 / project_uViewportSize);

  const float floatN = float(N);
  vec2 delta = -floatN * step;
  for(int i = -N; i <= N; i++) {
    delta.x = -step.x * floatN;
    for(int j = -N; j <= N; j++) {
      accumulator += collision_match(texCoords + delta, pickingColor);
      delta.x += step.x;
    }
    delta.y += step.y;
  }

  float W = 2.0 * floatN + 1.0;
  return pow(accumulator / (W * W), 2.2);
}
`;
  var inject4 = {
    "vs:#decl": `
  float collision_fade = 1.0;
`,
    "vs:DECKGL_FILTER_GL_POSITION": `
  if (collision_sort) {
    #ifdef NON_INSTANCED_MODEL
    float collisionPriority = collisionPriorities;
    #else
    float collisionPriority = instanceCollisionPriorities;
    #endif
    position.z = -0.001 * collisionPriority * position.w; // Support range -1000 -> 1000
  }

  if (collision_enabled) {
    vec4 collision_common_position = project_position(vec4(geometry.worldPosition, 1.0));
    vec2 collision_texCoords = collision_getCoords(collision_common_position);
    collision_fade = collision_isVisible(collision_texCoords, geometry.pickingColor / 255.0);
    if (collision_fade < 0.0001) {
      // Position outside clip space bounds to discard
      position = vec4(0.0, 0.0, 2.0, 1.0);
    }
  }
  `,
    "vs:DECKGL_FILTER_COLOR": `
  color.a *= collision_fade;
  `
  };
  var getCollisionUniforms = (opts, uniforms) => {
    if (!opts || !("dummyCollisionMap" in opts)) {
      return {};
    }
    const {
      collisionFBO,
      drawToCollisionMap,
      dummyCollisionMap
    } = opts;
    return {
      collision_sort: Boolean(drawToCollisionMap),
      collision_texture: !drawToCollisionMap && collisionFBO ? collisionFBO : dummyCollisionMap
    };
  };
  var shader_module_default2 = {
    name: "collision",
    dependencies: [import_core14.project],
    vs: vs3,
    inject: inject4,
    getUniforms: getCollisionUniforms
  };

  // src/collision-filter/collision-filter-effect.ts
  var import_core23 = __toESM(require_core2());
  var import_core25 = __toESM(require_core());

  // src/collision-filter/collision-filter-pass.ts
  var import_core15 = __toESM(require_core2());
  var import_core16 = __toESM(require_core());
  var CollisionFilterPass = class extends import_core16._LayersPass {
    renderCollisionMap(target, options) {
      const gl = this.gl;
      const padding = 1;
      return (0, import_core15.withParameters)(gl, {
        scissorTest: true,
        scissor: [padding, padding, target.width - 2 * padding, target.height - 2 * padding],
        clearColor: [0, 0, 0, 0],
        blend: false,
        depthTest: true,
        depthRange: [0, 1]
      }, () => this.render({
        ...options,
        target,
        pass: "collision"
      }));
    }
    getModuleParameters() {
      return {
        drawToCollisionMap: true,
        pickingActive: 1,
        pickingAttribute: false,
        lightSources: {}
      };
    }
  };

  // src/mask/mask-effect.ts
  var import_core20 = __toESM(require_core());
  var import_core21 = __toESM(require_core2());

  // src/mask/mask-pass.ts
  var import_core17 = __toESM(require_core2());
  var import_core18 = __toESM(require_core());
  var MaskPass = class extends import_core18._LayersPass {
    constructor(gl, props) {
      super(gl, props);
      const {
        mapSize = 2048
      } = props;
      this.maskMap = new import_core17.Texture2D(gl, {
        width: mapSize,
        height: mapSize,
        parameters: {
          [gl.TEXTURE_MIN_FILTER]: gl.LINEAR,
          [gl.TEXTURE_MAG_FILTER]: gl.LINEAR,
          [gl.TEXTURE_WRAP_S]: gl.CLAMP_TO_EDGE,
          [gl.TEXTURE_WRAP_T]: gl.CLAMP_TO_EDGE
        }
      });
      this.fbo = new import_core17.Framebuffer(gl, {
        id: "maskmap",
        width: mapSize,
        height: mapSize,
        attachments: {
          [gl.COLOR_ATTACHMENT0]: this.maskMap
        }
      });
    }
    render(options) {
      const gl = this.gl;
      const colorMask = [false, false, false, false];
      colorMask[options.channel] = true;
      return (0, import_core17.withParameters)(gl, {
        clearColor: [255, 255, 255, 255],
        blend: true,
        blendFunc: [gl.ZERO, gl.ONE],
        blendEquation: gl.FUNC_SUBTRACT,
        colorMask,
        depthTest: false
      }, () => super.render({
        ...options,
        target: this.fbo,
        pass: "mask"
      }));
    }
    shouldDrawLayer(layer) {
      return layer.props.operation.includes("mask");
    }
    delete() {
      this.fbo.delete();
      this.maskMap.delete();
    }
  };

  // src/utils/projection-utils.ts
  var import_core19 = __toESM(require_core());
  function joinLayerBounds(layers, viewport) {
    const bounds = [Infinity, Infinity, -Infinity, -Infinity];
    for (const layer of layers) {
      const layerBounds = layer.getBounds();
      if (layerBounds) {
        const bottomLeftCommon = layer.projectPosition(layerBounds[0], {
          viewport,
          autoOffset: false
        });
        const topRightCommon = layer.projectPosition(layerBounds[1], {
          viewport,
          autoOffset: false
        });
        bounds[0] = Math.min(bounds[0], bottomLeftCommon[0]);
        bounds[1] = Math.min(bounds[1], bottomLeftCommon[1]);
        bounds[2] = Math.max(bounds[2], topRightCommon[0]);
        bounds[3] = Math.max(bounds[3], topRightCommon[1]);
      }
    }
    if (Number.isFinite(bounds[0])) {
      return bounds;
    }
    return null;
  }
  var MAX_VIEWPORT_SIZE = 2048;
  function makeViewport(opts) {
    const {
      bounds,
      viewport,
      border = 0
    } = opts;
    const {
      isGeospatial
    } = viewport;
    if (bounds[2] <= bounds[0] || bounds[3] <= bounds[1]) {
      return null;
    }
    const centerWorld = viewport.unprojectPosition([(bounds[0] + bounds[2]) / 2, (bounds[1] + bounds[3]) / 2, 0]);
    let {
      width,
      height,
      zoom
    } = opts;
    if (zoom === void 0) {
      width = width - border * 2;
      height = height - border * 2;
      const scale = Math.min(width / (bounds[2] - bounds[0]), height / (bounds[3] - bounds[1]));
      zoom = Math.min(Math.log2(scale), 20);
    } else if (!width || !height) {
      const scale = 2 ** zoom;
      width = Math.round(Math.abs(bounds[2] - bounds[0]) * scale);
      height = Math.round(Math.abs(bounds[3] - bounds[1]) * scale);
      const maxSize = MAX_VIEWPORT_SIZE - border * 2;
      if (width > maxSize || height > maxSize) {
        const r = maxSize / Math.max(width, height);
        width = Math.round(width * r);
        height = Math.round(height * r);
        zoom += Math.log2(r);
      }
    }
    return isGeospatial ? new import_core19.WebMercatorViewport({
      id: viewport.id,
      x: border,
      y: border,
      width,
      height,
      longitude: centerWorld[0],
      latitude: centerWorld[1],
      zoom,
      orthographic: true
    }) : new import_core19.OrthographicViewport({
      id: viewport.id,
      x: border,
      y: border,
      width,
      height,
      target: centerWorld,
      zoom,
      flipY: false
    });
  }
  function getViewportBounds(viewport, zRange) {
    let viewportBoundsWorld;
    if (zRange && zRange.length === 2) {
      const [minZ, maxZ] = zRange;
      const bounds0 = viewport.getBounds({
        z: minZ
      });
      const bounds1 = viewport.getBounds({
        z: maxZ
      });
      viewportBoundsWorld = [Math.min(bounds0[0], bounds1[0]), Math.min(bounds0[1], bounds1[1]), Math.max(bounds0[2], bounds1[2]), Math.max(bounds0[3], bounds1[3])];
    } else {
      viewportBoundsWorld = viewport.getBounds();
    }
    const viewportBottomLeftCommon = viewport.projectPosition(viewportBoundsWorld.slice(0, 2));
    const viewportTopRightCommon = viewport.projectPosition(viewportBoundsWorld.slice(2, 4));
    return [viewportBottomLeftCommon[0], viewportBottomLeftCommon[1], viewportTopRightCommon[0], viewportTopRightCommon[1]];
  }
  function getRenderBounds(layerBounds, viewport, zRange) {
    if (!layerBounds) {
      return [0, 0, 1, 1];
    }
    const viewportBounds = getViewportBounds(viewport, zRange);
    const paddedBounds = doubleBounds(viewportBounds);
    if (layerBounds[2] - layerBounds[0] <= paddedBounds[2] - paddedBounds[0] && layerBounds[3] - layerBounds[1] <= paddedBounds[3] - paddedBounds[1]) {
      return layerBounds;
    }
    return [Math.max(layerBounds[0], paddedBounds[0]), Math.max(layerBounds[1], paddedBounds[1]), Math.min(layerBounds[2], paddedBounds[2]), Math.min(layerBounds[3], paddedBounds[3])];
  }
  function doubleBounds(bounds) {
    const dx = bounds[2] - bounds[0];
    const dy = bounds[3] - bounds[1];
    const centerX = (bounds[0] + bounds[2]) / 2;
    const centerY = (bounds[1] + bounds[3]) / 2;
    return [centerX - dx, centerY - dy, centerX + dx, centerY + dy];
  }

  // src/mask/mask-effect.ts
  var MaskEffect = class {
    id = "mask-effect";
    props = null;
    useInPicking = true;
    order = 0;
    channels = [];
    masks = null;
    preRender(gl, {
      layers,
      layerFilter,
      viewports,
      onViewportActive,
      views,
      isPicking
    }) {
      let didRender = false;
      if (!this.dummyMaskMap) {
        this.dummyMaskMap = new import_core21.Texture2D(gl, {
          width: 1,
          height: 1
        });
      }
      if (isPicking) {
        return {
          didRender
        };
      }
      const maskLayers = layers.filter((l) => l.props.visible && l.props.operation.includes("mask"));
      if (maskLayers.length === 0) {
        this.masks = null;
        this.channels.length = 0;
        return {
          didRender
        };
      }
      this.masks = {};
      if (!this.maskPass) {
        this.maskPass = new MaskPass(gl, {
          id: "default-mask"
        });
        this.maskMap = this.maskPass.maskMap;
      }
      const channelMap = this._sortMaskChannels(maskLayers);
      const viewport = viewports[0];
      const viewportChanged = !this.lastViewport || !this.lastViewport.equals(viewport);
      if (viewport.resolution !== void 0) {
        import_core20.log.warn("MaskExtension is not supported in GlobeView")();
        return {
          didRender
        };
      }
      for (const maskId in channelMap) {
        const result = this._renderChannel(channelMap[maskId], {
          layerFilter,
          onViewportActive,
          views,
          viewport,
          viewportChanged
        });
        didRender ||= result;
      }
      return {
        didRender
      };
    }
    _renderChannel(channelInfo, {
      layerFilter,
      onViewportActive,
      views,
      viewport,
      viewportChanged
    }) {
      let didRender = false;
      const oldChannelInfo = this.channels[channelInfo.index];
      if (!oldChannelInfo) {
        return didRender;
      }
      const maskChanged = channelInfo === oldChannelInfo || channelInfo.layers.length !== oldChannelInfo.layers.length || channelInfo.layers.some((layer, i) => layer !== oldChannelInfo.layers[i] || layer.props.transitions) || channelInfo.layerBounds.some((b, i) => b !== oldChannelInfo.layerBounds[i]);
      channelInfo.bounds = oldChannelInfo.bounds;
      channelInfo.maskBounds = oldChannelInfo.maskBounds;
      this.channels[channelInfo.index] = channelInfo;
      if (maskChanged || viewportChanged) {
        this.lastViewport = viewport;
        const layerBounds = joinLayerBounds(channelInfo.layers, viewport);
        channelInfo.bounds = layerBounds && getRenderBounds(layerBounds, viewport);
        if (maskChanged || !equals(channelInfo.bounds, oldChannelInfo.bounds)) {
          const {
            maskPass,
            maskMap
          } = this;
          const maskViewport = layerBounds && makeViewport({
            bounds: channelInfo.bounds,
            viewport,
            width: maskMap.width,
            height: maskMap.height,
            border: 1
          });
          channelInfo.maskBounds = maskViewport ? maskViewport.getBounds() : [0, 0, 1, 1];
          maskPass.render({
            pass: "mask",
            channel: channelInfo.index,
            layers: channelInfo.layers,
            layerFilter,
            viewports: maskViewport ? [maskViewport] : [],
            onViewportActive,
            views,
            moduleParameters: {
              devicePixelRatio: 1
            }
          });
          didRender = true;
        }
      }
      this.masks[channelInfo.id] = {
        index: channelInfo.index,
        bounds: channelInfo.maskBounds,
        coordinateOrigin: channelInfo.coordinateOrigin,
        coordinateSystem: channelInfo.coordinateSystem
      };
      return didRender;
    }
    _sortMaskChannels(maskLayers) {
      const channelMap = {};
      let channelCount = 0;
      for (const layer of maskLayers) {
        const {
          id
        } = layer.root;
        let channelInfo = channelMap[id];
        if (!channelInfo) {
          if (++channelCount > 4) {
            import_core20.log.warn("Too many mask layers. The max supported is 4")();
            continue;
          }
          channelInfo = {
            id,
            index: this.channels.findIndex((c) => c?.id === id),
            layers: [],
            layerBounds: [],
            coordinateOrigin: layer.root.props.coordinateOrigin,
            coordinateSystem: layer.root.props.coordinateSystem
          };
          channelMap[id] = channelInfo;
        }
        channelInfo.layers.push(layer);
        channelInfo.layerBounds.push(layer.getBounds());
      }
      for (let i = 0; i < 4; i++) {
        const channelInfo = this.channels[i];
        if (!channelInfo || !(channelInfo.id in channelMap)) {
          this.channels[i] = null;
        }
      }
      for (const maskId in channelMap) {
        const channelInfo = channelMap[maskId];
        if (channelInfo.index < 0) {
          channelInfo.index = this.channels.findIndex((c) => !c);
          this.channels[channelInfo.index] = channelInfo;
        }
      }
      return channelMap;
    }
    getModuleParameters() {
      return {
        maskMap: this.masks ? this.maskMap : this.dummyMaskMap,
        maskChannels: this.masks
      };
    }
    cleanup() {
      if (this.dummyMaskMap) {
        this.dummyMaskMap.delete();
        this.dummyMaskMap = void 0;
      }
      if (this.maskPass) {
        this.maskPass.delete();
        this.maskPass = void 0;
        this.maskMap = void 0;
      }
      this.lastViewport = void 0;
      this.masks = null;
      this.channels.length = 0;
    }
  };

  // src/collision-filter/collision-filter-effect.ts
  var DOWNSCALE = 2;
  var CollisionFilterEffect = class {
    id = "collision-filter-effect";
    props = null;
    useInPicking = true;
    order = 1;
    channels = {};
    collisionFBOs = {};
    preRender(gl, {
      effects: allEffects,
      layers,
      layerFilter,
      viewports,
      onViewportActive,
      views,
      isPicking,
      preRenderStats = {}
    }) {
      if (!this.dummyCollisionMap) {
        this.dummyCollisionMap = new import_core23.Texture2D(gl, {
          width: 1,
          height: 1
        });
      }
      if (isPicking) {
        return;
      }
      const collisionLayers = layers.filter(
        ({
          props: {
            visible,
            collisionEnabled
          }
        }) => visible && collisionEnabled
      );
      if (collisionLayers.length === 0) {
        this.channels = {};
        return;
      }
      if (!this.collisionFilterPass) {
        this.collisionFilterPass = new CollisionFilterPass(gl, {
          id: "default-collision-filter"
        });
      }
      const effects = allEffects?.filter((e) => e.constructor === MaskEffect);
      const maskEffectRendered = preRenderStats["mask-effect"]?.didRender;
      const channels = this._groupByCollisionGroup(gl, collisionLayers);
      const viewport = viewports[0];
      const viewportChanged = !this.lastViewport || !this.lastViewport.equals(viewport) || maskEffectRendered;
      for (const collisionGroup in channels) {
        const collisionFBO = this.collisionFBOs[collisionGroup];
        const renderInfo = channels[collisionGroup];
        collisionFBO.resize({
          width: gl.canvas.width / DOWNSCALE,
          height: gl.canvas.height / DOWNSCALE
        });
        this._render(renderInfo, {
          effects,
          layerFilter,
          onViewportActive,
          views,
          viewport,
          viewportChanged
        });
      }
    }
    _render(renderInfo, {
      effects,
      layerFilter,
      onViewportActive,
      views,
      viewport,
      viewportChanged
    }) {
      const {
        collisionGroup
      } = renderInfo;
      const oldRenderInfo = this.channels[collisionGroup];
      if (!oldRenderInfo) {
        return;
      }
      const needsRender = viewportChanged || renderInfo === oldRenderInfo || !(0, import_core25._deepEqual)(oldRenderInfo.layers, renderInfo.layers, 1) || renderInfo.layerBounds.some((b, i) => !equals(b, oldRenderInfo.layerBounds[i])) || renderInfo.allLayersLoaded !== oldRenderInfo.allLayersLoaded || renderInfo.layers.some((layer) => layer.props.transitions);
      this.channels[collisionGroup] = renderInfo;
      if (needsRender) {
        this.lastViewport = viewport;
        const collisionFBO = this.collisionFBOs[collisionGroup];
        this.collisionFilterPass.renderCollisionMap(collisionFBO, {
          pass: "collision-filter",
          isPicking: true,
          layers: renderInfo.layers,
          effects,
          layerFilter,
          viewports: viewport ? [viewport] : [],
          onViewportActive,
          views,
          moduleParameters: {
            dummyCollisionMap: this.dummyCollisionMap,
            devicePixelRatio: (0, import_core23.cssToDeviceRatio)(collisionFBO.gl) / DOWNSCALE
          }
        });
      }
    }
    _groupByCollisionGroup(gl, collisionLayers) {
      const channelMap = {};
      for (const layer of collisionLayers) {
        const {
          collisionGroup
        } = layer.props;
        let channelInfo = channelMap[collisionGroup];
        if (!channelInfo) {
          channelInfo = {
            collisionGroup,
            layers: [],
            layerBounds: [],
            allLayersLoaded: true
          };
          channelMap[collisionGroup] = channelInfo;
        }
        channelInfo.layers.push(layer);
        channelInfo.layerBounds.push(layer.getBounds());
        if (!layer.isLoaded) {
          channelInfo.allLayersLoaded = false;
        }
      }
      for (const collisionGroup of Object.keys(channelMap)) {
        if (!this.collisionFBOs[collisionGroup]) {
          this.createFBO(gl, collisionGroup);
        }
        if (!this.channels[collisionGroup]) {
          this.channels[collisionGroup] = channelMap[collisionGroup];
        }
      }
      for (const collisionGroup of Object.keys(this.collisionFBOs)) {
        if (!channelMap[collisionGroup]) {
          this.destroyFBO(collisionGroup);
        }
      }
      return channelMap;
    }
    getModuleParameters(layer) {
      const {
        collisionGroup
      } = layer.props;
      const {
        collisionFBOs,
        dummyCollisionMap
      } = this;
      return {
        collisionFBO: collisionFBOs[collisionGroup],
        dummyCollisionMap
      };
    }
    cleanup() {
      if (this.dummyCollisionMap) {
        this.dummyCollisionMap.delete();
        this.dummyCollisionMap = void 0;
      }
      this.channels = {};
      for (const collisionGroup of Object.keys(this.collisionFBOs)) {
        this.destroyFBO(collisionGroup);
      }
      this.collisionFBOs = {};
      this.lastViewport = void 0;
    }
    createFBO(gl, collisionGroup) {
      const {
        width,
        height
      } = gl.canvas;
      const collisionMap = new import_core23.Texture2D(gl, {
        width,
        height,
        parameters: {
          [gl.TEXTURE_MIN_FILTER]: gl.NEAREST,
          [gl.TEXTURE_MAG_FILTER]: gl.NEAREST,
          [gl.TEXTURE_WRAP_S]: gl.CLAMP_TO_EDGE,
          [gl.TEXTURE_WRAP_T]: gl.CLAMP_TO_EDGE
        }
      });
      const depthBuffer = new import_core23.Renderbuffer(gl, {
        format: gl.DEPTH_COMPONENT16,
        width,
        height
      });
      this.collisionFBOs[collisionGroup] = new import_core23.Framebuffer(gl, {
        id: `Collision-${collisionGroup}`,
        width,
        height,
        attachments: {
          [gl.COLOR_ATTACHMENT0]: collisionMap,
          [gl.DEPTH_ATTACHMENT]: depthBuffer
        }
      });
    }
    destroyFBO(collisionGroup) {
      const fbo = this.collisionFBOs[collisionGroup];
      for (const attachment of Object.values(fbo.attachments)) {
        attachment.delete();
      }
      fbo.delete();
      delete this.collisionFBOs[collisionGroup];
    }
  };

  // src/collision-filter/collision-filter-extension.ts
  var defaultProps6 = {
    getCollisionPriority: {
      type: "accessor",
      value: 0
    },
    collisionEnabled: true,
    collisionGroup: {
      type: "string",
      value: "default"
    },
    collisionTestProps: {}
  };
  var CollisionFilterExtension = class extends import_core26.LayerExtension {
    getShaders() {
      return {
        modules: [shader_module_default2]
      };
    }
    draw({
      uniforms,
      context,
      moduleParameters
    }) {
      const {
        collisionEnabled
      } = this.props;
      const {
        collisionFBO,
        drawToCollisionMap
      } = moduleParameters;
      const enabled = collisionEnabled && Boolean(collisionFBO);
      uniforms.collision_enabled = enabled;
      if (drawToCollisionMap) {
        this.props = this.clone(this.props.collisionTestProps).props;
      }
    }
    initializeState(context, extension) {
      if (this.getAttributeManager() === null) {
        return;
      }
      this.context.deck?._addDefaultEffect(new CollisionFilterEffect());
      const attributeManager = this.getAttributeManager();
      attributeManager.add({
        collisionPriorities: {
          size: 1,
          accessor: "getCollisionPriority",
          shaderAttributes: {
            collisionPriorities: {
              divisor: 0
            },
            instanceCollisionPriorities: {
              divisor: 1
            }
          }
        }
      });
    }
    getNeedsPickingBuffer() {
      return this.props.collisionEnabled;
    }
  };
  __publicField(CollisionFilterExtension, "defaultProps", defaultProps6);
  __publicField(CollisionFilterExtension, "extensionName", "CollisionFilterExtension");

  // src/mask/mask-extension.ts
  var import_core28 = __toESM(require_core());

  // src/mask/shader-module.ts
  var import_core27 = __toESM(require_core());
  var vs4 = `
uniform vec4 mask_bounds;
uniform bool mask_maskByInstance;
vec2 mask_getCoords(vec4 position) {
  return (position.xy - mask_bounds.xy) / (mask_bounds.zw - mask_bounds.xy);
}
`;
  var fs3 = `
uniform sampler2D mask_texture;
uniform int mask_channel;
uniform bool mask_enabled;
uniform bool mask_inverted;
bool mask_isInBounds(vec2 texCoords) {
  if (!mask_enabled) {
    return true;
  }
  vec4 maskColor = texture2D(mask_texture, texCoords);
  float maskValue = 1.0;
  if (mask_channel == 0) {
    maskValue = maskColor.r;
  } else if (mask_channel == 1) {
    maskValue = maskColor.g;
  } else if (mask_channel == 2) {
    maskValue = maskColor.b;
  } else if (mask_channel == 3) {
    maskValue = maskColor.a;
  }

  if (mask_inverted) {
    return maskValue >= 0.5;
  } else {
    return maskValue < 0.5;
  }
}
`;
  var inject5 = {
    "vs:#decl": `
varying vec2 mask_texCoords;
`,
    "vs:#main-end": `
   vec4 mask_common_position;
   if (mask_maskByInstance) {
     mask_common_position = project_position(vec4(geometry.worldPosition, 1.0));
   } else {
     mask_common_position = geometry.position;
   }
   mask_texCoords = mask_getCoords(mask_common_position);
`,
    "fs:#decl": `
varying vec2 mask_texCoords;
`,
    "fs:#main-start": `
  if (mask_enabled) {
    bool mask = mask_isInBounds(mask_texCoords);

    // Debug: show extent of render target
    // gl_FragColor = vec4(mask_texCoords, 0.0, 1.0);
    gl_FragColor = texture2D(mask_texture, mask_texCoords);

    if (!mask) discard;
  }
`
  };
  var getMaskUniforms = (opts) => {
    if (opts && "maskMap" in opts) {
      return {
        mask_texture: opts.maskMap
      };
    }
    return {};
  };
  var shader_module_default3 = {
    name: "mask",
    dependencies: [import_core27.project],
    vs: vs4,
    fs: fs3,
    inject: inject5,
    getUniforms: getMaskUniforms
  };

  // src/mask/mask-extension.ts
  var defaultProps7 = {
    maskId: "",
    maskByInstance: void 0,
    maskInverted: false
  };
  var MaskExtension = class extends import_core28.LayerExtension {
    initializeState() {
      this.context.deck?._addDefaultEffect(new MaskEffect());
    }
    getShaders() {
      let maskByInstance = "instancePositions" in this.getAttributeManager().attributes;
      if (this.props.maskByInstance !== void 0) {
        maskByInstance = Boolean(this.props.maskByInstance);
      }
      this.state.maskByInstance = maskByInstance;
      return {
        modules: [shader_module_default3]
      };
    }
    draw({
      uniforms,
      context,
      moduleParameters
    }) {
      uniforms.mask_maskByInstance = this.state.maskByInstance;
      const {
        maskId,
        maskInverted
      } = this.props;
      const {
        maskChannels
      } = moduleParameters;
      const {
        viewport
      } = context;
      if (maskChannels && maskChannels[maskId]) {
        const {
          index,
          bounds,
          coordinateOrigin: fromCoordinateOrigin
        } = maskChannels[maskId];
        let {
          coordinateSystem: fromCoordinateSystem
        } = maskChannels[maskId];
        uniforms.mask_enabled = true;
        uniforms.mask_channel = index;
        uniforms.mask_inverted = maskInverted;
        if (fromCoordinateSystem === import_core28.COORDINATE_SYSTEM.DEFAULT) {
          fromCoordinateSystem = viewport.isGeospatial ? import_core28.COORDINATE_SYSTEM.LNGLAT : import_core28.COORDINATE_SYSTEM.CARTESIAN;
        }
        const opts = {
          modelMatrix: null,
          fromCoordinateOrigin,
          fromCoordinateSystem
        };
        const bl = this.projectPosition([bounds[0], bounds[1], 0], opts);
        const tr = this.projectPosition([bounds[2], bounds[3], 0], opts);
        uniforms.mask_bounds = [bl[0], bl[1], tr[0], tr[1]];
      } else {
        if (maskId) {
          import_core28.log.warn(`Could not find a mask layer with id: ${maskId}`)();
        }
        uniforms.mask_enabled = false;
      }
    }
  };
  __publicField(MaskExtension, "defaultProps", defaultProps7);
  __publicField(MaskExtension, "extensionName", "MaskExtension");

  // src/terrain/terrain-extension.ts
  var import_core38 = __toESM(require_core());

  // src/terrain/terrain-effect.ts
  var import_core36 = __toESM(require_core2());
  var import_core37 = __toESM(require_core());

  // src/terrain/shader-module.ts
  var import_core29 = __toESM(require_core());
  var TERRAIN_MODE = {
    NONE: 0,
    WRITE_HEIGHT_MAP: 1,
    USE_HEIGHT_MAP: 2,
    USE_COVER: 3,
    USE_COVER_ONLY: 4,
    SKIP: 5
  };
  var TERRAIN_MODE_CONSTANTS = Object.keys(TERRAIN_MODE).map((key) => `const float TERRAIN_MODE_${key} = ${TERRAIN_MODE[key]}.0;`).join("\n");
  var terrainModule = {
    name: "terrain",
    dependencies: [import_core29.project],
    inject: {
      "vs:#decl": `
uniform float terrain_mode;
uniform sampler2D terrain_map;
uniform vec4 terrain_bounds;
varying vec3 commonPos;
${TERRAIN_MODE_CONSTANTS}
    `,
      "vs:#main-start": `
if (terrain_mode == TERRAIN_MODE_SKIP) {
  gl_Position = vec4(0.0);
  return;
}
`,
      "vs:DECKGL_FILTER_GL_POSITION": `
commonPos = geometry.position.xyz;
if (terrain_mode == TERRAIN_MODE_WRITE_HEIGHT_MAP) {
  vec2 texCoords = (commonPos.xy - terrain_bounds.xy) / terrain_bounds.zw;
  position = vec4(texCoords * 2.0 - 1.0, 0.0, 1.0);
  commonPos.z += project_uCommonOrigin.z;
}
if (terrain_mode == TERRAIN_MODE_USE_HEIGHT_MAP) {
  vec3 anchor = geometry.worldPosition;
  anchor.z = 0.0;
  vec3 anchorCommon = project_position(anchor);
  vec2 texCoords = (anchorCommon.xy - terrain_bounds.xy) / terrain_bounds.zw;
  if (texCoords.x >= 0.0 && texCoords.y >= 0.0 && texCoords.x <= 1.0 && texCoords.y <= 1.0) {
    float terrainZ = texture2D(terrain_map, texCoords).r;
    geometry.position.z += terrainZ;
    position = project_common_position_to_clipspace(geometry.position);
  }
}
    `,
      "fs:#decl": `
uniform float terrain_mode;
uniform sampler2D terrain_map;
uniform vec4 terrain_bounds;
varying vec3 commonPos;
${TERRAIN_MODE_CONSTANTS}
    `,
      "fs:#main-start": `
if (terrain_mode == TERRAIN_MODE_WRITE_HEIGHT_MAP) {
  gl_FragColor = vec4(commonPos.z, 0.0, 0.0, 1.0);
  return;
}
    `,
      "fs:DECKGL_FILTER_COLOR": `
if ((terrain_mode == TERRAIN_MODE_USE_COVER) || (terrain_mode == TERRAIN_MODE_USE_COVER_ONLY)) {
  vec2 texCoords = (commonPos.xy - terrain_bounds.xy) / terrain_bounds.zw;
  vec4 pixel = texture2D(terrain_map, texCoords);
  if (terrain_mode == TERRAIN_MODE_USE_COVER_ONLY) {
    color = pixel;
  } else {
    // pixel is premultiplied
    color = pixel + color * (1.0 - pixel.a);
  }
  return;
}
    `
    },
    getUniforms: (opts = {}, uniforms) => {
      if ("dummyHeightMap" in opts) {
        const {
          drawToTerrainHeightMap,
          heightMap,
          heightMapBounds,
          dummyHeightMap,
          terrainCover,
          useTerrainHeightMap,
          terrainSkipRender
        } = opts;
        const {
          project_uCommonOrigin
        } = uniforms;
        let mode = terrainSkipRender ? TERRAIN_MODE.SKIP : TERRAIN_MODE.NONE;
        let sampler = dummyHeightMap;
        let bounds = null;
        if (drawToTerrainHeightMap) {
          mode = TERRAIN_MODE.WRITE_HEIGHT_MAP;
          bounds = heightMapBounds;
        } else if (useTerrainHeightMap && heightMap) {
          mode = TERRAIN_MODE.USE_HEIGHT_MAP;
          sampler = heightMap;
          bounds = heightMapBounds;
        } else if (terrainCover) {
          const isPicking = opts.pickingActive;
          sampler = isPicking ? terrainCover.getPickingFramebuffer() : terrainCover.getRenderFramebuffer();
          if (isPicking) {
            mode = TERRAIN_MODE.SKIP;
          }
          if (sampler) {
            mode = mode === TERRAIN_MODE.SKIP ? TERRAIN_MODE.USE_COVER_ONLY : TERRAIN_MODE.USE_COVER;
            bounds = terrainCover.bounds;
          } else {
            sampler = dummyHeightMap;
          }
        }
        return {
          terrain_mode: mode,
          terrain_map: sampler,
          terrain_bounds: bounds ? [bounds[0] - project_uCommonOrigin[0], bounds[1] - project_uCommonOrigin[1], bounds[2] - bounds[0], bounds[3] - bounds[1]] : [0, 0, 0, 0]
        };
      }
      return null;
    }
  };

  // src/terrain/utils.ts
  var import_core30 = __toESM(require_core2());
  function createRenderTarget(gl, opts) {
    return new import_core30.Framebuffer(gl, {
      id: opts.id,
      attachments: {
        [gl.COLOR_ATTACHMENT0]: new import_core30.Texture2D(gl, {
          ...opts.float && {
            format: (0, import_core30.isWebGL2)(gl) ? esm_default.RGBA32F : esm_default.RGBA,
            type: esm_default.FLOAT
          },
          mipmaps: false,
          parameters: {
            [gl.TEXTURE_MIN_FILTER]: gl.LINEAR,
            [gl.TEXTURE_MAG_FILTER]: gl.LINEAR,
            [gl.TEXTURE_WRAP_S]: gl.CLAMP_TO_EDGE,
            [gl.TEXTURE_WRAP_T]: gl.CLAMP_TO_EDGE
          }
        })
      }
    });
  }

  // src/terrain/terrain-cover.ts
  var TerrainCover = class {
    isDirty = true;
    renderViewport = null;
    bounds = null;
    layers = [];
    targetBounds = null;
    targetBoundsCommon = null;
    constructor(targetLayer) {
      this.targetLayer = targetLayer;
      this.tile = getTile(targetLayer);
    }
    get id() {
      return this.targetLayer.id;
    }
    get isActive() {
      return Boolean(this.targetLayer.getCurrentLayer());
    }
    shouldUpdate({
      targetLayer,
      viewport,
      layers,
      layerNeedsRedraw
    }) {
      if (targetLayer) {
        this.targetLayer = targetLayer;
      }
      const sizeChanged = viewport ? this._updateViewport(viewport) : false;
      let layersChanged = layers ? this._updateLayers(layers) : false;
      if (layerNeedsRedraw) {
        for (const id of this.layers) {
          if (layerNeedsRedraw[id]) {
            layersChanged = true;
            break;
          }
        }
      }
      return layersChanged || sizeChanged;
    }
    _updateLayers(layers) {
      let needsRedraw = false;
      layers = this.tile ? getIntersectingLayers(this.tile, layers) : layers;
      if (layers.length !== this.layers.length) {
        needsRedraw = true;
      } else {
        for (let i = 0; i < layers.length; i++) {
          const id = layers[i].id;
          if (id !== this.layers[i]) {
            needsRedraw = true;
            break;
          }
        }
      }
      if (needsRedraw) {
        this.layers = layers.map((layer) => layer.id);
      }
      return needsRedraw;
    }
    _updateViewport(viewport) {
      const targetLayer = this.targetLayer;
      let shouldRedraw = false;
      if (this.tile && "boundingBox" in this.tile) {
        if (!this.targetBounds) {
          shouldRedraw = true;
          this.targetBounds = this.tile.boundingBox;
          const bottomLeftCommon = viewport.projectPosition(this.targetBounds[0]);
          const topRightCommon = viewport.projectPosition(this.targetBounds[1]);
          this.targetBoundsCommon = [bottomLeftCommon[0], bottomLeftCommon[1], topRightCommon[0], topRightCommon[1]];
        }
      } else if (this.targetBounds !== targetLayer.getBounds()) {
        shouldRedraw = true;
        this.targetBounds = targetLayer.getBounds();
        this.targetBoundsCommon = joinLayerBounds([targetLayer], viewport);
      }
      if (!this.targetBoundsCommon) {
        return false;
      }
      const newZoom = Math.ceil(viewport.zoom + 0.5);
      if (this.tile) {
        this.bounds = this.targetBoundsCommon;
      } else {
        const oldZoom = this.renderViewport?.zoom;
        shouldRedraw = shouldRedraw || newZoom !== oldZoom;
        const newBounds = getRenderBounds(this.targetBoundsCommon, viewport);
        const oldBounds = this.bounds;
        shouldRedraw = shouldRedraw || !oldBounds || newBounds.some((x, i) => x !== oldBounds[i]);
        this.bounds = newBounds;
      }
      if (shouldRedraw) {
        this.renderViewport = makeViewport({
          bounds: this.bounds,
          zoom: newZoom,
          viewport
        });
      }
      return shouldRedraw;
    }
    getRenderFramebuffer() {
      if (!this.renderViewport || this.layers.length === 0) {
        return null;
      }
      if (!this.fbo) {
        this.fbo = createRenderTarget(this.targetLayer.context.gl, {
          id: this.id
        });
      }
      return this.fbo;
    }
    getPickingFramebuffer() {
      if (!this.renderViewport || this.layers.length === 0 && !this.targetLayer.props.pickable) {
        return null;
      }
      if (!this.pickingFbo) {
        this.pickingFbo = createRenderTarget(this.targetLayer.context.gl, {
          id: `${this.id}-picking`
        });
      }
      return this.pickingFbo;
    }
    filterLayers(layers) {
      return layers.filter(({
        id
      }) => this.layers.includes(id));
    }
    delete() {
      const {
        fbo,
        pickingFbo
      } = this;
      if (fbo) {
        fbo.texture.delete();
        fbo.delete();
      }
      if (pickingFbo) {
        pickingFbo.texture.delete();
        pickingFbo.delete();
      }
    }
  };
  function getIntersectingLayers(sourceTile, layers) {
    return layers.filter((layer) => {
      const tile = getTile(layer);
      if (tile) {
        return intersect(sourceTile.boundingBox, tile.boundingBox);
      }
      return true;
    });
  }
  function getTile(layer) {
    while (layer) {
      const {
        tile
      } = layer.props;
      if (tile) {
        return tile;
      }
      layer = layer.parent;
    }
    return null;
  }
  function intersect(b1, b2) {
    if (b1 && b2) {
      return b1[0][0] < b2[1][0] && b2[0][0] < b1[1][0] && b1[0][1] < b2[1][1] && b2[0][1] < b1[1][1];
    }
    return false;
  }

  // src/terrain/terrain-pass.ts
  var import_core31 = __toESM(require_core2());
  var import_core32 = __toESM(require_core());
  var TerrainPass = class extends import_core32._LayersPass {
    getRenderableLayers(viewport, opts) {
      const {
        layers
      } = opts;
      const result = [];
      const drawParamsByIndex = this._getDrawLayerParams(viewport, opts, true);
      for (let i = 0; i < layers.length; i++) {
        const layer = layers[i];
        if (!layer.isComposite && drawParamsByIndex[i].shouldDrawLayer) {
          result.push(layer);
        }
      }
      return result;
    }
    renderHeightMap(heightMap, opts) {
      const target = heightMap.getRenderFramebuffer();
      const viewport = heightMap.renderViewport;
      if (!target || !viewport) {
        return;
      }
      target.resize(viewport);
      (0, import_core31.withParameters)(this.gl, {
        clearColor: [0, 0, 0, 0],
        blend: true,
        blendFunc: [esm_default.ONE, esm_default.ONE],
        blendEquation: esm_default.MAX,
        depthTest: false
      }, () => this.render({
        ...opts,
        target,
        pass: "terrain-height-map",
        layers: opts.layers,
        viewports: [viewport],
        effects: []
      }));
    }
    renderTerrainCover(terrainCover, opts) {
      const target = terrainCover.getRenderFramebuffer();
      const viewport = terrainCover.renderViewport;
      if (!target || !viewport) {
        return;
      }
      const layers = terrainCover.filterLayers(opts.layers);
      target.resize(viewport);
      (0, import_core31.withParameters)(this.gl, {
        clearColor: [0, 0, 0, 0],
        depthTest: false
      }, () => this.render({
        ...opts,
        target,
        pass: `terrain-cover-${terrainCover.id}`,
        layers,
        effects: [],
        viewports: [viewport]
      }));
    }
  };

  // src/terrain/terrain-picking-pass.ts
  var import_core33 = __toESM(require_core());
  var import_core34 = __toESM(require_core2());
  var TerrainPickingPass = class extends import_core33._PickLayersPass {
    drawParameters = {};
    getRenderableLayers(viewport, opts) {
      const {
        layers
      } = opts;
      const result = [];
      this.drawParameters = {};
      this._resetColorEncoder(opts.pickZ);
      const drawParamsByIndex = this._getDrawLayerParams(viewport, opts);
      for (let i = 0; i < layers.length; i++) {
        const layer = layers[i];
        if (!layer.isComposite && drawParamsByIndex[i].shouldDrawLayer) {
          result.push(layer);
          this.drawParameters[layer.id] = drawParamsByIndex[i].layerParameters;
        }
      }
      return result;
    }
    renderTerrainCover(terrainCover, opts) {
      const target = terrainCover.getPickingFramebuffer();
      const viewport = terrainCover.renderViewport;
      if (!target || !viewport) {
        return;
      }
      const layers = terrainCover.filterLayers(opts.layers);
      const terrainLayer = terrainCover.targetLayer;
      if (terrainLayer.props.pickable) {
        layers.unshift(terrainLayer);
      }
      target.resize(viewport);
      (0, import_core34.withParameters)(this.gl, {
        depthTest: false
      }, () => this.render({
        ...opts,
        pickingFBO: target,
        pass: `terrain-cover-picking-${terrainCover.id}`,
        layers,
        effects: [],
        viewports: [viewport],
        cullRect: void 0,
        deviceRect: viewport,
        pickZ: false
      }));
    }
    getLayerParameters(layer, layerIndex, viewport) {
      if (this.drawParameters[layer.id]) {
        return this.drawParameters[layer.id];
      }
      const parameters2 = super.getLayerParameters(layer, layerIndex, viewport);
      parameters2.blend = true;
      return parameters2;
    }
  };

  // src/terrain/height-map-builder.ts
  var import_core35 = __toESM(require_core2());
  var MAP_MAX_SIZE = 2048;
  var HeightMapBuilder = class {
    renderViewport = null;
    bounds = null;
    layers = [];
    layersBounds = [];
    layersBoundsCommon = null;
    lastViewport = null;
    static isSupported(gl) {
      return import_core35.Framebuffer.isSupported(gl, {
        colorBufferFloat: true
      });
    }
    constructor(gl) {
      this.gl = gl;
    }
    getRenderFramebuffer() {
      if (!this.renderViewport) {
        return null;
      }
      if (!this.fbo) {
        this.fbo = createRenderTarget(this.gl, {
          id: "height-map",
          float: true
        });
      }
      return this.fbo;
    }
    shouldUpdate({
      layers,
      viewport
    }) {
      const layersChanged = layers.length !== this.layers.length || layers.some((layer, i) => layer !== this.layers[i] || layer.props.transitions || layer.getBounds() !== this.layersBounds[i]);
      if (layersChanged) {
        this.layers = layers;
        this.layersBounds = layers.map((layer) => layer.getBounds());
        this.layersBoundsCommon = joinLayerBounds(layers, viewport);
      }
      const viewportChanged = !this.lastViewport || !viewport.equals(this.lastViewport);
      if (!this.layersBoundsCommon) {
        this.renderViewport = null;
      } else if (layersChanged || viewportChanged) {
        const bounds = getRenderBounds(this.layersBoundsCommon, viewport);
        if (bounds[2] <= bounds[0] || bounds[3] <= bounds[1]) {
          this.renderViewport = null;
          return false;
        }
        this.bounds = bounds;
        this.lastViewport = viewport;
        const scale = viewport.scale;
        const pixelWidth = (bounds[2] - bounds[0]) * scale;
        const pixelHeight = (bounds[3] - bounds[1]) * scale;
        this.renderViewport = pixelWidth > 0 || pixelHeight > 0 ? makeViewport({
          bounds: [viewport.center[0] - 1, viewport.center[1] - 1, viewport.center[0] + 1, viewport.center[1] + 1],
          zoom: viewport.zoom,
          width: Math.min(pixelWidth, MAP_MAX_SIZE),
          height: Math.min(pixelHeight, MAP_MAX_SIZE),
          viewport
        }) : null;
        return true;
      }
      return false;
    }
    delete() {
      if (this.fbo) {
        this.fbo.color.delete();
        this.fbo.delete();
      }
    }
  };

  // src/terrain/terrain-effect.ts
  var TerrainEffect = class {
    id = "terrain-effect";
    props = null;
    useInPicking = true;
    isPicking = false;
    isDrapingEnabled = false;
    terrainCovers = /* @__PURE__ */ new Map();
    initialize(gl) {
      this.dummyHeightMap = new import_core36.Texture2D(gl, {
        width: 1,
        height: 1,
        data: new Uint8Array([0, 0, 0, 0])
      });
      this.terrainPass = new TerrainPass(gl, {
        id: "terrain"
      });
      this.terrainPickingPass = new TerrainPickingPass(gl, {
        id: "terrain-picking"
      });
      if (HeightMapBuilder.isSupported(gl)) {
        this.heightMap = new HeightMapBuilder(gl);
      } else {
        import_core37.log.warn("Terrain offset mode is not supported by this browser")();
      }
      import_core36.ProgramManager.getDefaultProgramManager(gl).addDefaultModule(terrainModule);
    }
    preRender(gl, opts) {
      if (!this.dummyHeightMap) {
        this.initialize(gl);
        for (const layer of opts.layers) {
          if (layer.props.operation.includes("terrain")) {
            layer.setChangeFlags({
              extensionsChanged: true
            });
          }
        }
      }
      if (opts.pickZ) {
        this.isDrapingEnabled = false;
        return;
      }
      const {
        viewports
      } = opts;
      const isPicking = opts.pass.startsWith("picking");
      this.isPicking = isPicking;
      this.isDrapingEnabled = true;
      const viewport = viewports[0];
      const layers = (isPicking ? this.terrainPickingPass : this.terrainPass).getRenderableLayers(viewport, opts);
      const terrainLayers = layers.filter((l) => l.props.operation.includes("terrain"));
      if (terrainLayers.length === 0) {
        return;
      }
      if (!isPicking) {
        const offsetLayers = layers.filter((l) => l.state.terrainDrawMode === "offset");
        if (offsetLayers.length > 0) {
          this._updateHeightMap(terrainLayers, viewport, opts);
        }
      }
      const drapeLayers = layers.filter((l) => l.state.terrainDrawMode === "drape");
      this._updateTerrainCovers(terrainLayers, drapeLayers, viewport, opts);
    }
    getModuleParameters(layer) {
      const {
        terrainDrawMode
      } = layer.state;
      return {
        heightMap: this.heightMap?.getRenderFramebuffer(),
        heightMapBounds: this.heightMap?.bounds,
        dummyHeightMap: this.dummyHeightMap,
        terrainCover: this.isDrapingEnabled ? this.terrainCovers.get(layer.id) : null,
        useTerrainHeightMap: terrainDrawMode === "offset",
        terrainSkipRender: terrainDrawMode === "drape" || !layer.props.operation.includes("draw")
      };
    }
    cleanup() {
      if (this.dummyHeightMap) {
        this.dummyHeightMap.delete();
        this.dummyHeightMap = void 0;
      }
      if (this.heightMap) {
        this.heightMap.delete();
        this.heightMap = void 0;
      }
      for (const terrainCover of this.terrainCovers.values()) {
        terrainCover.delete();
      }
      this.terrainCovers.clear();
    }
    _updateHeightMap(terrainLayers, viewport, opts) {
      if (!this.heightMap) {
        return;
      }
      const shouldUpdate = this.heightMap.shouldUpdate({
        layers: terrainLayers,
        viewport
      });
      if (!shouldUpdate) {
        return;
      }
      this.terrainPass.renderHeightMap(this.heightMap, {
        ...opts,
        layers: terrainLayers,
        moduleParameters: {
          heightMapBounds: this.heightMap.bounds,
          dummyHeightMap: this.dummyHeightMap,
          devicePixelRatio: 1,
          drawToTerrainHeightMap: true
        }
      });
    }
    _updateTerrainCovers(terrainLayers, drapeLayers, viewport, opts) {
      const layerNeedsRedraw = {};
      for (const layer of drapeLayers) {
        if (layer.state.terrainCoverNeedsRedraw) {
          layerNeedsRedraw[layer.id] = true;
          layer.state.terrainCoverNeedsRedraw = false;
        }
      }
      for (const terrainCover of this.terrainCovers.values()) {
        terrainCover.isDirty = terrainCover.isDirty || terrainCover.shouldUpdate({
          layerNeedsRedraw
        });
      }
      for (const layer of terrainLayers) {
        this._updateTerrainCover(layer, drapeLayers, viewport, opts);
      }
      if (!this.isPicking) {
        this._pruneTerrainCovers();
      }
    }
    _updateTerrainCover(terrainLayer, drapeLayers, viewport, opts) {
      const renderPass = this.isPicking ? this.terrainPickingPass : this.terrainPass;
      let terrainCover = this.terrainCovers.get(terrainLayer.id);
      if (!terrainCover) {
        terrainCover = new TerrainCover(terrainLayer);
        this.terrainCovers.set(terrainLayer.id, terrainCover);
      }
      try {
        const isDirty = terrainCover.shouldUpdate({
          targetLayer: terrainLayer,
          viewport,
          layers: drapeLayers
        });
        if (this.isPicking || terrainCover.isDirty || isDirty) {
          renderPass.renderTerrainCover(terrainCover, {
            ...opts,
            layers: drapeLayers,
            moduleParameters: {
              dummyHeightMap: this.dummyHeightMap,
              terrainSkipRender: false,
              devicePixelRatio: 1
            }
          });
          if (!this.isPicking) {
            terrainCover.isDirty = false;
          }
        }
      } catch (err) {
        terrainLayer.raiseError(err, `Error rendering terrain cover ${terrainCover.id}`);
      }
    }
    _pruneTerrainCovers() {
      const idsToRemove = [];
      for (const [id, terrainCover] of this.terrainCovers) {
        if (!terrainCover.isActive) {
          idsToRemove.push(id);
        }
      }
      for (const id of idsToRemove) {
        this.terrainCovers.delete(id);
      }
    }
  };

  // src/terrain/terrain-extension.ts
  var defaultProps8 = {
    terrainDrawMode: void 0
  };
  var TerrainExtension = class extends import_core38.LayerExtension {
    getShaders() {
      return {
        modules: [terrainModule]
      };
    }
    initializeState() {
      this.context.deck?._addDefaultEffect(new TerrainEffect());
    }
    updateState(params) {
      const {
        props,
        oldProps
      } = params;
      if (this.state.terrainDrawMode && props.terrainDrawMode === oldProps.terrainDrawMode && props.extruded === oldProps.extruded) {
        return;
      }
      let {
        terrainDrawMode
      } = props;
      if (!terrainDrawMode) {
        const is3d = this.props.extruded;
        const attributes = this.getAttributeManager()?.attributes;
        const hasAnchor = attributes && "instancePositions" in attributes;
        terrainDrawMode = is3d || hasAnchor ? "offset" : "drape";
      }
      this.setState({
        terrainDrawMode
      });
    }
    onNeedsRedraw() {
      const state = this.state;
      if (state.terrainDrawMode === "drape") {
        state.terrainCoverNeedsRedraw = true;
      }
    }
  };
  __publicField(TerrainExtension, "defaultProps", defaultProps8);
  __publicField(TerrainExtension, "extensionName", "TerrainExtension");
  return __toCommonJS(bundle_exports);
})();
      return __exports__;
      });
