"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _shaderModule = _interopRequireDefault(require("./shader-module"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var defaultProps = {
  getBrushingTarget: {
    type: 'accessor',
    value: [0, 0]
  },
  brushingTarget: 'source',
  brushingEnabled: true,
  brushingRadius: 10000
};

var BrushingExtension = function (_LayerExtension) {
  (0, _inherits2.default)(BrushingExtension, _LayerExtension);

  var _super = _createSuper(BrushingExtension);

  function BrushingExtension() {
    (0, _classCallCheck2.default)(this, BrushingExtension);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(BrushingExtension, [{
    key: "getShaders",
    value: function getShaders() {
      return {
        modules: [_shaderModule.default]
      };
    }
  }, {
    key: "initializeState",
    value: function initializeState(context, extension) {
      var _this = this;

      var attributeManager = this.getAttributeManager();

      if (attributeManager) {
        attributeManager.add({
          brushingTargets: {
            size: 2,
            accessor: 'getBrushingTarget',
            shaderAttributes: {
              brushingTargets: {
                divisor: 0
              },
              instanceBrushingTargets: {
                divisor: 1
              }
            }
          }
        });
      }

      this.state.onMouseMove = function () {
        var _this$getCurrentLayer;

        (_this$getCurrentLayer = _this.getCurrentLayer()) === null || _this$getCurrentLayer === void 0 ? void 0 : _this$getCurrentLayer.setNeedsRedraw();
      };

      if (context.deck) {
        context.deck.eventManager.on({
          pointermove: this.state.onMouseMove,
          pointerleave: this.state.onMouseMove
        });
      }
    }
  }, {
    key: "finalizeState",
    value: function finalizeState(context, extension) {
      if (context.deck) {
        context.deck.eventManager.off({
          pointermove: this.state.onMouseMove,
          pointerleave: this.state.onMouseMove
        });
      }
    }
  }]);
  return BrushingExtension;
}(_core.LayerExtension);

exports.default = BrushingExtension;
(0, _defineProperty2.default)(BrushingExtension, "defaultProps", defaultProps);
(0, _defineProperty2.default)(BrushingExtension, "extensionName", 'BrushingExtension');
//# sourceMappingURL=brushing-extension.js.map