"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@deck.gl/core");

var vs = "\n  uniform bool brushing_enabled;\n  uniform int brushing_target;\n  uniform vec2 brushing_mousePos;\n  uniform float brushing_radius;\n\n  #ifdef NON_INSTANCED_MODEL\n  attribute vec2 brushingTargets;\n  #else\n  attribute vec2 instanceBrushingTargets;\n  #endif\n\n  varying float brushing_isVisible;\n\n  bool brushing_isPointInRange(vec2 position) {\n    if (!brushing_enabled) {\n      return true;\n    }\n    vec2 source_commonspace = project_position(position);\n    vec2 target_commonspace = project_position(brushing_mousePos);\n    float distance = length((target_commonspace - source_commonspace) / project_uCommonUnitsPerMeter.xy);\n\n    return distance <= brushing_radius;\n  }\n\n  bool brushing_arePointsInRange(vec2 sourcePos, vec2 targetPos) {\n    return brushing_isPointInRange(sourcePos) || brushing_isPointInRange(targetPos);\n  }\n\n  void brushing_setVisible(bool visible) {\n    brushing_isVisible = float(visible);\n  }\n";
var fs = "\n  uniform bool brushing_enabled;\n  varying float brushing_isVisible;\n";
var TARGET = {
  source: 0,
  target: 1,
  custom: 2,
  source_target: 3
};
var inject = {
  'vs:DECKGL_FILTER_GL_POSITION': "\n    vec2 brushingTarget;\n    vec2 brushingSource;\n    if (brushing_target == 3) {\n      brushingTarget = geometry.worldPositionAlt.xy;\n      brushingSource = geometry.worldPosition.xy;\n    } else if (brushing_target == 0) {\n      brushingTarget = geometry.worldPosition.xy;\n    } else if (brushing_target == 1) {\n      brushingTarget = geometry.worldPositionAlt.xy;\n    } else {\n      #ifdef NON_INSTANCED_MODEL\n      brushingTarget = brushingTargets;\n      #else\n      brushingTarget = instanceBrushingTargets;\n      #endif\n    }\n    bool visible;\n    if (brushing_target == 3) {\n      visible = brushing_arePointsInRange(brushingSource, brushingTarget);\n    } else {\n      visible = brushing_isPointInRange(brushingTarget);\n    }\n    brushing_setVisible(visible);\n  ",
  'fs:DECKGL_FILTER_COLOR': "\n    if (brushing_enabled && brushing_isVisible < 0.5) {\n      discard;\n    }\n  "
};
var _default = {
  name: 'brushing',
  dependencies: [_core.project],
  vs: vs,
  fs: fs,
  inject: inject,
  getUniforms: function getUniforms(opts) {
    if (!opts || !('viewport' in opts)) {
      return {};
    }

    var _opts$brushingEnabled = opts.brushingEnabled,
        brushingEnabled = _opts$brushingEnabled === void 0 ? true : _opts$brushingEnabled,
        _opts$brushingRadius = opts.brushingRadius,
        brushingRadius = _opts$brushingRadius === void 0 ? 10000 : _opts$brushingRadius,
        _opts$brushingTarget = opts.brushingTarget,
        brushingTarget = _opts$brushingTarget === void 0 ? 'source' : _opts$brushingTarget,
        mousePosition = opts.mousePosition,
        viewport = opts.viewport;
    return {
      brushing_enabled: Boolean(brushingEnabled && mousePosition && viewport.containsPixel(mousePosition)),
      brushing_radius: brushingRadius,
      brushing_target: TARGET[brushingTarget] || 0,
      brushing_mousePos: mousePosition ? viewport.unproject([mousePosition.x - viewport.x, mousePosition.y - viewport.y]) : [0, 0]
    };
  }
};
exports.default = _default;
//# sourceMappingURL=shader-module.js.map