"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@luma.gl/core");

var _core2 = require("@math.gl/core");

var _core3 = require("@deck.gl/core");

var _collisionFilterPass = _interopRequireDefault(require("./collision-filter-pass"));

var _maskEffect = _interopRequireDefault(require("../mask/mask-effect"));

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var DOWNSCALE = 2;

var CollisionFilterEffect = function () {
  function CollisionFilterEffect() {
    (0, _classCallCheck2.default)(this, CollisionFilterEffect);
    (0, _defineProperty2.default)(this, "id", 'collision-filter-effect');
    (0, _defineProperty2.default)(this, "props", null);
    (0, _defineProperty2.default)(this, "useInPicking", true);
    (0, _defineProperty2.default)(this, "order", 1);
    (0, _defineProperty2.default)(this, "channels", {});
    (0, _defineProperty2.default)(this, "collisionFilterPass", void 0);
    (0, _defineProperty2.default)(this, "collisionFBOs", {});
    (0, _defineProperty2.default)(this, "dummyCollisionMap", void 0);
    (0, _defineProperty2.default)(this, "lastViewport", void 0);
  }

  (0, _createClass2.default)(CollisionFilterEffect, [{
    key: "preRender",
    value: function preRender(gl, _ref) {
      var _preRenderStats$mask;

      var allEffects = _ref.effects,
          layers = _ref.layers,
          layerFilter = _ref.layerFilter,
          viewports = _ref.viewports,
          onViewportActive = _ref.onViewportActive,
          views = _ref.views,
          isPicking = _ref.isPicking,
          _ref$preRenderStats = _ref.preRenderStats,
          preRenderStats = _ref$preRenderStats === void 0 ? {} : _ref$preRenderStats;

      if (!this.dummyCollisionMap) {
        this.dummyCollisionMap = new _core.Texture2D(gl, {
          width: 1,
          height: 1
        });
      }

      if (isPicking) {
        return;
      }

      var collisionLayers = layers.filter(function (_ref2) {
        var _ref2$props = _ref2.props,
            visible = _ref2$props.visible,
            collisionEnabled = _ref2$props.collisionEnabled;
        return visible && collisionEnabled;
      });

      if (collisionLayers.length === 0) {
        this.channels = {};
        return;
      }

      if (!this.collisionFilterPass) {
        this.collisionFilterPass = new _collisionFilterPass.default(gl, {
          id: 'default-collision-filter'
        });
      }

      var effects = allEffects === null || allEffects === void 0 ? void 0 : allEffects.filter(function (e) {
        return e.constructor === _maskEffect.default;
      });
      var maskEffectRendered = (_preRenderStats$mask = preRenderStats['mask-effect']) === null || _preRenderStats$mask === void 0 ? void 0 : _preRenderStats$mask.didRender;

      var channels = this._groupByCollisionGroup(gl, collisionLayers);

      var viewport = viewports[0];
      var viewportChanged = !this.lastViewport || !this.lastViewport.equals(viewport) || maskEffectRendered;

      for (var collisionGroup in channels) {
        var collisionFBO = this.collisionFBOs[collisionGroup];
        var renderInfo = channels[collisionGroup];
        collisionFBO.resize({
          width: gl.canvas.width / DOWNSCALE,
          height: gl.canvas.height / DOWNSCALE
        });

        this._render(renderInfo, {
          effects: effects,
          layerFilter: layerFilter,
          onViewportActive: onViewportActive,
          views: views,
          viewport: viewport,
          viewportChanged: viewportChanged
        });
      }
    }
  }, {
    key: "_render",
    value: function _render(renderInfo, _ref3) {
      var effects = _ref3.effects,
          layerFilter = _ref3.layerFilter,
          onViewportActive = _ref3.onViewportActive,
          views = _ref3.views,
          viewport = _ref3.viewport,
          viewportChanged = _ref3.viewportChanged;
      var collisionGroup = renderInfo.collisionGroup;
      var oldRenderInfo = this.channels[collisionGroup];

      if (!oldRenderInfo) {
        return;
      }

      var needsRender = viewportChanged || renderInfo === oldRenderInfo || !(0, _core3._deepEqual)(oldRenderInfo.layers, renderInfo.layers, 1) || renderInfo.layerBounds.some(function (b, i) {
        return !(0, _core2.equals)(b, oldRenderInfo.layerBounds[i]);
      }) || renderInfo.allLayersLoaded !== oldRenderInfo.allLayersLoaded || renderInfo.layers.some(function (layer) {
        return layer.props.transitions;
      });
      this.channels[collisionGroup] = renderInfo;

      if (needsRender) {
        this.lastViewport = viewport;
        var collisionFBO = this.collisionFBOs[collisionGroup];
        this.collisionFilterPass.renderCollisionMap(collisionFBO, {
          pass: 'collision-filter',
          isPicking: true,
          layers: renderInfo.layers,
          effects: effects,
          layerFilter: layerFilter,
          viewports: viewport ? [viewport] : [],
          onViewportActive: onViewportActive,
          views: views,
          moduleParameters: {
            dummyCollisionMap: this.dummyCollisionMap,
            devicePixelRatio: (0, _core.cssToDeviceRatio)(collisionFBO.gl) / DOWNSCALE
          }
        });
      }
    }
  }, {
    key: "_groupByCollisionGroup",
    value: function _groupByCollisionGroup(gl, collisionLayers) {
      var channelMap = {};

      var _iterator = _createForOfIteratorHelper(collisionLayers),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var layer = _step.value;
          var _collisionGroup2 = layer.props.collisionGroup;
          var channelInfo = channelMap[_collisionGroup2];

          if (!channelInfo) {
            channelInfo = {
              collisionGroup: _collisionGroup2,
              layers: [],
              layerBounds: [],
              allLayersLoaded: true
            };
            channelMap[_collisionGroup2] = channelInfo;
          }

          channelInfo.layers.push(layer);
          channelInfo.layerBounds.push(layer.getBounds());

          if (!layer.isLoaded) {
            channelInfo.allLayersLoaded = false;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      for (var _i = 0, _Object$keys = Object.keys(channelMap); _i < _Object$keys.length; _i++) {
        var collisionGroup = _Object$keys[_i];

        if (!this.collisionFBOs[collisionGroup]) {
          this.createFBO(gl, collisionGroup);
        }

        if (!this.channels[collisionGroup]) {
          this.channels[collisionGroup] = channelMap[collisionGroup];
        }
      }

      for (var _i2 = 0, _Object$keys2 = Object.keys(this.collisionFBOs); _i2 < _Object$keys2.length; _i2++) {
        var _collisionGroup = _Object$keys2[_i2];

        if (!channelMap[_collisionGroup]) {
          this.destroyFBO(_collisionGroup);
        }
      }

      return channelMap;
    }
  }, {
    key: "getModuleParameters",
    value: function getModuleParameters(layer) {
      var collisionGroup = layer.props.collisionGroup;
      var collisionFBOs = this.collisionFBOs,
          dummyCollisionMap = this.dummyCollisionMap;
      return {
        collisionFBO: collisionFBOs[collisionGroup],
        dummyCollisionMap: dummyCollisionMap
      };
    }
  }, {
    key: "cleanup",
    value: function cleanup() {
      if (this.dummyCollisionMap) {
        this.dummyCollisionMap.delete();
        this.dummyCollisionMap = undefined;
      }

      this.channels = {};

      for (var _i3 = 0, _Object$keys3 = Object.keys(this.collisionFBOs); _i3 < _Object$keys3.length; _i3++) {
        var collisionGroup = _Object$keys3[_i3];
        this.destroyFBO(collisionGroup);
      }

      this.collisionFBOs = {};
      this.lastViewport = undefined;
    }
  }, {
    key: "createFBO",
    value: function createFBO(gl, collisionGroup) {
      var _parameters, _attachments;

      var _gl$canvas = gl.canvas,
          width = _gl$canvas.width,
          height = _gl$canvas.height;
      var collisionMap = new _core.Texture2D(gl, {
        width: width,
        height: height,
        parameters: (_parameters = {}, (0, _defineProperty2.default)(_parameters, 10241, 9728), (0, _defineProperty2.default)(_parameters, 10240, 9728), (0, _defineProperty2.default)(_parameters, 10242, 33071), (0, _defineProperty2.default)(_parameters, 10243, 33071), _parameters)
      });
      var depthBuffer = new _core.Renderbuffer(gl, {
        format: 33189,
        width: width,
        height: height
      });
      this.collisionFBOs[collisionGroup] = new _core.Framebuffer(gl, {
        id: "Collision-".concat(collisionGroup),
        width: width,
        height: height,
        attachments: (_attachments = {}, (0, _defineProperty2.default)(_attachments, 36064, collisionMap), (0, _defineProperty2.default)(_attachments, 36096, depthBuffer), _attachments)
      });
    }
  }, {
    key: "destroyFBO",
    value: function destroyFBO(collisionGroup) {
      var fbo = this.collisionFBOs[collisionGroup];

      for (var _i4 = 0, _Object$values = Object.values(fbo.attachments); _i4 < _Object$values.length; _i4++) {
        var attachment = _Object$values[_i4];
        attachment.delete();
      }

      fbo.delete();
      delete this.collisionFBOs[collisionGroup];
    }
  }]);
  return CollisionFilterEffect;
}();

exports.default = CollisionFilterEffect;
//# sourceMappingURL=collision-filter-effect.js.map