"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _shaderModule = _interopRequireDefault(require("./shader-module"));

var _collisionFilterEffect = _interopRequireDefault(require("./collision-filter-effect"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var defaultProps = {
  getCollisionPriority: {
    type: 'accessor',
    value: 0
  },
  collisionEnabled: true,
  collisionGroup: {
    type: 'string',
    value: 'default'
  },
  collisionTestProps: {}
};

var CollisionFilterExtension = function (_LayerExtension) {
  (0, _inherits2.default)(CollisionFilterExtension, _LayerExtension);

  var _super = _createSuper(CollisionFilterExtension);

  function CollisionFilterExtension() {
    (0, _classCallCheck2.default)(this, CollisionFilterExtension);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(CollisionFilterExtension, [{
    key: "getShaders",
    value: function getShaders() {
      return {
        modules: [_shaderModule.default]
      };
    }
  }, {
    key: "draw",
    value: function draw(_ref) {
      var uniforms = _ref.uniforms,
          context = _ref.context,
          moduleParameters = _ref.moduleParameters;
      var collisionEnabled = this.props.collisionEnabled;
      var collisionFBO = moduleParameters.collisionFBO,
          drawToCollisionMap = moduleParameters.drawToCollisionMap;
      var enabled = collisionEnabled && Boolean(collisionFBO);
      uniforms.collision_enabled = enabled;

      if (drawToCollisionMap) {
        this.props = this.clone(this.props.collisionTestProps).props;
      }
    }
  }, {
    key: "initializeState",
    value: function initializeState(context, extension) {
      var _this$context$deck;

      if (this.getAttributeManager() === null) {
        return;
      }

      (_this$context$deck = this.context.deck) === null || _this$context$deck === void 0 ? void 0 : _this$context$deck._addDefaultEffect(new _collisionFilterEffect.default());
      var attributeManager = this.getAttributeManager();
      attributeManager.add({
        collisionPriorities: {
          size: 1,
          accessor: 'getCollisionPriority',
          shaderAttributes: {
            collisionPriorities: {
              divisor: 0
            },
            instanceCollisionPriorities: {
              divisor: 1
            }
          }
        }
      });
    }
  }, {
    key: "getNeedsPickingBuffer",
    value: function getNeedsPickingBuffer() {
      return this.props.collisionEnabled;
    }
  }]);
  return CollisionFilterExtension;
}(_core.LayerExtension);

exports.default = CollisionFilterExtension;
(0, _defineProperty2.default)(CollisionFilterExtension, "defaultProps", defaultProps);
(0, _defineProperty2.default)(CollisionFilterExtension, "extensionName", 'CollisionFilterExtension');
//# sourceMappingURL=collision-filter-extension.js.map