"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.supportsFloatTarget = supportsFloatTarget;
exports.getFramebuffer = getFramebuffer;
exports.getModel = getModel;
exports.parameters = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@luma.gl/core");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var AGGREGATE_VS = "#define SHADER_NAME data-filter-vertex-shader\n\n#ifdef FLOAT_TARGET\n  attribute float filterIndices;\n  attribute float filterPrevIndices;\n#else\n  attribute vec2 filterIndices;\n  attribute vec2 filterPrevIndices;\n#endif\n\nvarying vec4 vColor;\nconst float component = 1.0 / 255.0;\n\nvoid main() {\n  #ifdef FLOAT_TARGET\n    dataFilter_value *= float(filterIndices != filterPrevIndices);\n    gl_Position = vec4(0.0, 0.0, 0.0, 1.0);\n    vColor = vec4(0.0, 0.0, 0.0, 1.0);\n  #else\n    // Float texture is not supported: pack result into 4 channels x 256 px x 64px\n    dataFilter_value *= float(filterIndices.x != filterPrevIndices.x);\n    float col = filterIndices.x;\n    float row = filterIndices.y * 4.0;\n    float channel = floor(row);\n    row = fract(row);\n    vColor = component * vec4(bvec4(channel == 0.0, channel == 1.0, channel == 2.0, channel == 3.0));\n    gl_Position = vec4(col * 2.0 - 1.0, row * 2.0 - 1.0, 0.0, 1.0);\n  #endif\n  gl_PointSize = 1.0;\n}\n";
var AGGREGATE_FS = "#define SHADER_NAME data-filter-fragment-shader\nprecision highp float;\n\nvarying vec4 vColor;\n\nvoid main() {\n  if (dataFilter_value < 0.5) {\n    discard;\n  }\n  gl_FragColor = vColor;\n}\n";

function supportsFloatTarget(gl) {
  return Boolean(gl.getExtension('EXT_float_blend') && (gl.getExtension('EXT_color_buffer_float') || gl.getExtension('WEBGL_color_buffer_float')));
}

function getFramebuffer(gl, useFloatTarget) {
  if (useFloatTarget) {
    return new _core.Framebuffer(gl, {
      width: 1,
      height: 1,
      attachments: (0, _defineProperty2.default)({}, 36064, new _core.Texture2D(gl, {
        format: (0, _core.isWebGL2)(gl) ? 34836 : 6408,
        type: 5126,
        mipmaps: false
      }))
    });
  }

  return new _core.Framebuffer(gl, {
    width: 256,
    height: 64,
    depth: false
  });
}

function getModel(gl, shaderOptions, useFloatTarget) {
  shaderOptions.defines.NON_INSTANCED_MODEL = 1;

  if (useFloatTarget) {
    shaderOptions.defines.FLOAT_TARGET = 1;
  }

  return new _core.Model(gl, _objectSpread({
    id: 'data-filter-aggregation-model',
    vertexCount: 1,
    isInstanced: false,
    drawMode: 0,
    vs: AGGREGATE_VS,
    fs: AGGREGATE_FS
  }, shaderOptions));
}

var parameters = {
  blend: true,
  blendFunc: [1, 1, 1, 1],
  blendEquation: [32774, 32774],
  depthTest: false
};
exports.parameters = parameters;
//# sourceMappingURL=aggregator.js.map