"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _shaderModule = require("./shader-module");

var aggregator = _interopRequireWildcard(require("./aggregator"));

var _core2 = require("@luma.gl/core");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var defaultProps = {
  getFilterValue: {
    type: 'accessor',
    value: 0
  },
  onFilteredItemsChange: {
    type: 'function',
    value: null,
    optional: true
  },
  filterEnabled: true,
  filterRange: [-1, 1],
  filterSoftRange: null,
  filterTransformSize: true,
  filterTransformColor: true
};
var DATA_TYPE_FROM_SIZE = {
  1: 'float',
  2: 'vec2',
  3: 'vec3',
  4: 'vec4'
};

var DataFilterExtension = function (_LayerExtension) {
  (0, _inherits2.default)(DataFilterExtension, _LayerExtension);

  var _super = _createSuper(DataFilterExtension);

  function DataFilterExtension() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$filterSize = _ref.filterSize,
        filterSize = _ref$filterSize === void 0 ? 1 : _ref$filterSize,
        _ref$fp = _ref.fp64,
        fp64 = _ref$fp === void 0 ? false : _ref$fp,
        _ref$countItems = _ref.countItems,
        countItems = _ref$countItems === void 0 ? false : _ref$countItems;

    (0, _classCallCheck2.default)(this, DataFilterExtension);

    if (!DATA_TYPE_FROM_SIZE[filterSize]) {
      throw new Error('filterSize out of range');
    }

    return _super.call(this, {
      filterSize: filterSize,
      fp64: fp64,
      countItems: countItems
    });
  }

  (0, _createClass2.default)(DataFilterExtension, [{
    key: "getShaders",
    value: function getShaders(extension) {
      var _extension$opts = extension.opts,
          filterSize = _extension$opts.filterSize,
          fp64 = _extension$opts.fp64;
      return {
        modules: [fp64 ? _shaderModule.shaderModule64 : _shaderModule.shaderModule],
        defines: {
          DATAFILTER_TYPE: DATA_TYPE_FROM_SIZE[filterSize],
          DATAFILTER_DOUBLE: Boolean(fp64)
        }
      };
    }
  }, {
    key: "initializeState",
    value: function initializeState(context, extension) {
      var attributeManager = this.getAttributeManager();

      if (attributeManager) {
        attributeManager.add({
          filterValues: {
            size: extension.opts.filterSize,
            type: extension.opts.fp64 ? 5130 : 5126,
            accessor: 'getFilterValue',
            shaderAttributes: {
              filterValues: {
                divisor: 0
              },
              instanceFilterValues: {
                divisor: 1
              }
            }
          }
        });
      }

      var gl = this.context.gl;

      if (attributeManager && extension.opts.countItems) {
        var useFloatTarget = aggregator.supportsFloatTarget(gl);
        attributeManager.add({
          filterIndices: {
            size: useFloatTarget ? 1 : 2,
            vertexOffset: 1,
            type: 5121,
            normalized: true,
            accessor: function accessor(object, _ref2) {
              var index = _ref2.index;
              var i = object && object.__source ? object.__source.index : index;
              return useFloatTarget ? (i + 1) % 255 : [(i + 1) % 255, Math.floor(i / 255) % 255];
            },
            shaderAttributes: {
              filterPrevIndices: {
                vertexOffset: 0
              },
              filterIndices: {
                vertexOffset: 1
              }
            }
          }
        });
        var filterFBO = aggregator.getFramebuffer(gl, useFloatTarget);
        var filterModel = aggregator.getModel(gl, extension.getShaders.call(this, extension), useFloatTarget);
        this.setState({
          filterFBO: filterFBO,
          filterModel: filterModel
        });
      }
    }
  }, {
    key: "updateState",
    value: function updateState(_ref3) {
      var props = _ref3.props,
          oldProps = _ref3.oldProps;

      if (this.state.filterModel) {
        var attributeManager = this.getAttributeManager();
        var filterNeedsUpdate = attributeManager.attributes.filterValues.needsUpdate() || props.filterEnabled !== oldProps.filterEnabled || props.filterRange !== oldProps.filterRange || props.filterSoftRange !== oldProps.filterSoftRange;

        if (filterNeedsUpdate) {
          this.setState({
            filterNeedsUpdate: filterNeedsUpdate
          });
        }
      }
    }
  }, {
    key: "draw",
    value: function draw(params, extension) {
      var _this$state = this.state,
          filterFBO = _this$state.filterFBO,
          filterModel = _this$state.filterModel,
          filterNeedsUpdate = _this$state.filterNeedsUpdate;
      var onFilteredItemsChange = this.props.onFilteredItemsChange;

      if (filterNeedsUpdate && onFilteredItemsChange && filterModel) {
        var _ref4 = this.getAttributeManager(),
            _ref4$attributes = _ref4.attributes,
            filterValues = _ref4$attributes.filterValues,
            filterIndices = _ref4$attributes.filterIndices;

        filterModel.setVertexCount(this.getNumInstances());
        var gl = this.context.gl;
        (0, _core2.clear)(gl, {
          framebuffer: filterFBO,
          color: [0, 0, 0, 0]
        });
        filterModel.updateModuleSettings(params.moduleParameters).setAttributes(_objectSpread(_objectSpread({}, filterValues.getShaderAttributes()), filterIndices && filterIndices.getShaderAttributes())).draw({
          framebuffer: filterFBO,
          parameters: _objectSpread(_objectSpread({}, aggregator.parameters), {}, {
            viewport: [0, 0, filterFBO.width, filterFBO.height]
          })
        });
        var color = (0, _core2.readPixelsToArray)(filterFBO);
        var count = 0;

        for (var i = 0; i < color.length; i++) {
          count += color[i];
        }

        onFilteredItemsChange({
          id: this.id,
          count: count
        });
        this.state.filterNeedsUpdate = false;
      }
    }
  }, {
    key: "finalizeState",
    value: function finalizeState() {
      var _this$state2 = this.state,
          filterFBO = _this$state2.filterFBO,
          filterModel = _this$state2.filterModel;

      if (filterFBO) {
        filterFBO.color.delete();
        filterFBO.delete();
        filterModel.delete();
      }
    }
  }]);
  return DataFilterExtension;
}(_core.LayerExtension);

exports.default = DataFilterExtension;
(0, _defineProperty2.default)(DataFilterExtension, "defaultProps", defaultProps);
(0, _defineProperty2.default)(DataFilterExtension, "extensionName", 'DataFilterExtension');
//# sourceMappingURL=data-filter-extension.js.map