"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shaderModule64 = exports.shaderModule = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var vs = "\nuniform DATAFILTER_TYPE filter_min;\nuniform DATAFILTER_TYPE filter_softMin;\nuniform DATAFILTER_TYPE filter_softMax;\nuniform DATAFILTER_TYPE filter_max;\nuniform bool filter_useSoftMargin;\nuniform bool filter_enabled;\nuniform bool filter_transformSize;\n\n#ifdef NON_INSTANCED_MODEL\n  #define DATAFILTER_ATTRIB filterValues\n  #define DATAFILTER_ATTRIB_64LOW filterValues64Low\n#else\n  #define DATAFILTER_ATTRIB instanceFilterValues\n  #define DATAFILTER_ATTRIB_64LOW instanceFilterValues64Low\n#endif\n\nattribute DATAFILTER_TYPE DATAFILTER_ATTRIB;\n#ifdef DATAFILTER_DOUBLE\n  attribute DATAFILTER_TYPE DATAFILTER_ATTRIB_64LOW;\n\n  uniform DATAFILTER_TYPE filter_min64High;\n  uniform DATAFILTER_TYPE filter_max64High;\n#endif\n\nvarying float dataFilter_value;\n\nfloat dataFilter_reduceValue(float value) {\n  return value;\n}\nfloat dataFilter_reduceValue(vec2 value) {\n  return min(value.x, value.y);\n}\nfloat dataFilter_reduceValue(vec3 value) {\n  return min(min(value.x, value.y), value.z);\n}\nfloat dataFilter_reduceValue(vec4 value) {\n  return min(min(value.x, value.y), min(value.z, value.w));\n}\nvoid dataFilter_setValue(DATAFILTER_TYPE valueFromMin, DATAFILTER_TYPE valueFromMax) {\n  if (filter_enabled) {\n    if (filter_useSoftMargin) {\n      dataFilter_value = dataFilter_reduceValue(\n        smoothstep(filter_min, filter_softMin, valueFromMin) *\n        (1.0 - smoothstep(filter_softMax, filter_max, valueFromMax))\n      );\n    } else {\n      dataFilter_value = dataFilter_reduceValue(\n        step(filter_min, valueFromMin) * step(valueFromMax, filter_max)\n      );\n    }\n  } else {\n    dataFilter_value = 1.0;\n  }\n}\n";
var fs = "\nuniform bool filter_transformColor;\nvarying float dataFilter_value;\n";

function getUniforms(opts) {
  if (!opts || !('extensions' in opts)) {
    return {};
  }

  var _opts$filterRange = opts.filterRange,
      filterRange = _opts$filterRange === void 0 ? [-1, 1] : _opts$filterRange,
      _opts$filterEnabled = opts.filterEnabled,
      filterEnabled = _opts$filterEnabled === void 0 ? true : _opts$filterEnabled,
      _opts$filterTransform = opts.filterTransformSize,
      filterTransformSize = _opts$filterTransform === void 0 ? true : _opts$filterTransform,
      _opts$filterTransform2 = opts.filterTransformColor,
      filterTransformColor = _opts$filterTransform2 === void 0 ? true : _opts$filterTransform2;
  var filterSoftRange = opts.filterSoftRange || filterRange;
  return _objectSpread(_objectSpread({}, Number.isFinite(filterRange[0]) ? {
    filter_min: filterRange[0],
    filter_softMin: filterSoftRange[0],
    filter_softMax: filterSoftRange[1],
    filter_max: filterRange[1]
  } : {
    filter_min: filterRange.map(function (r) {
      return r[0];
    }),
    filter_softMin: filterSoftRange.map(function (r) {
      return r[0];
    }),
    filter_softMax: filterSoftRange.map(function (r) {
      return r[1];
    }),
    filter_max: filterRange.map(function (r) {
      return r[1];
    })
  }), {}, {
    filter_enabled: filterEnabled,
    filter_useSoftMargin: Boolean(opts.filterSoftRange),
    filter_transformSize: filterEnabled && filterTransformSize,
    filter_transformColor: filterEnabled && filterTransformColor
  });
}

function getUniforms64(opts) {
  if (!opts || !('extensions' in opts)) {
    return {};
  }

  var uniforms = getUniforms(opts);

  if (Number.isFinite(uniforms.filter_min)) {
    var min64High = Math.fround(uniforms.filter_min);
    uniforms.filter_min -= min64High;
    uniforms.filter_softMin -= min64High;
    uniforms.filter_min64High = min64High;
    var max64High = Math.fround(uniforms.filter_max);
    uniforms.filter_max -= max64High;
    uniforms.filter_softMax -= max64High;
    uniforms.filter_max64High = max64High;
  } else {
    var _min64High = uniforms.filter_min.map(Math.fround);

    uniforms.filter_min = uniforms.filter_min.map(function (x, i) {
      return x - _min64High[i];
    });
    uniforms.filter_softMin = uniforms.filter_softMin.map(function (x, i) {
      return x - _min64High[i];
    });
    uniforms.filter_min64High = _min64High;

    var _max64High = uniforms.filter_max.map(Math.fround);

    uniforms.filter_max = uniforms.filter_max.map(function (x, i) {
      return x - _max64High[i];
    });
    uniforms.filter_softMax = uniforms.filter_softMax.map(function (x, i) {
      return x - _max64High[i];
    });
    uniforms.filter_max64High = _max64High;
  }

  return uniforms;
}

var inject = {
  'vs:#main-start': "\n    #ifdef DATAFILTER_DOUBLE\n      dataFilter_setValue(\n        DATAFILTER_ATTRIB - filter_min64High + DATAFILTER_ATTRIB_64LOW,\n        DATAFILTER_ATTRIB - filter_max64High + DATAFILTER_ATTRIB_64LOW\n      );\n    #else\n      dataFilter_setValue(DATAFILTER_ATTRIB, DATAFILTER_ATTRIB);\n    #endif\n  ",
  'vs:#main-end': "\n    if (dataFilter_value == 0.0) {\n      gl_Position = vec4(0.);\n    }\n  ",
  'vs:DECKGL_FILTER_SIZE': "\n    if (filter_transformSize) {\n      size = size * dataFilter_value;\n    }\n  ",
  'fs:DECKGL_FILTER_COLOR': "\n    if (dataFilter_value == 0.0) discard;\n    if (filter_transformColor) {\n      color.a *= dataFilter_value;\n    }\n  "
};
var shaderModule = {
  name: 'data-filter',
  vs: vs,
  fs: fs,
  inject: inject,
  getUniforms: getUniforms
};
exports.shaderModule = shaderModule;
var shaderModule64 = {
  name: 'data-filter-fp64',
  vs: vs,
  fs: fs,
  inject: inject,
  getUniforms: getUniforms64
};
exports.shaderModule64 = shaderModule64;
//# sourceMappingURL=shader-module.js.map