"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _core2 = require("@luma.gl/core");

var _shaders = require("./shaders.glsl");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var defaultProps = {
  fillPatternEnabled: true,
  fillPatternAtlas: {
    type: 'image',
    value: null,
    async: true,
    parameters: (0, _defineProperty2.default)({}, 10241, 9729)
  },
  fillPatternMapping: {
    type: 'object',
    value: {},
    async: true
  },
  fillPatternMask: true,
  getFillPattern: {
    type: 'accessor',
    value: function value(d) {
      return d.pattern;
    }
  },
  getFillPatternScale: {
    type: 'accessor',
    value: 1
  },
  getFillPatternOffset: {
    type: 'accessor',
    value: [0, 0]
  }
};

var FillStyleExtension = function (_LayerExtension) {
  (0, _inherits2.default)(FillStyleExtension, _LayerExtension);

  var _super = _createSuper(FillStyleExtension);

  function FillStyleExtension() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$pattern = _ref.pattern,
        pattern = _ref$pattern === void 0 ? false : _ref$pattern;

    (0, _classCallCheck2.default)(this, FillStyleExtension);
    return _super.call(this, {
      pattern: pattern
    });
  }

  (0, _createClass2.default)(FillStyleExtension, [{
    key: "isEnabled",
    value: function isEnabled(layer) {
      return layer.getAttributeManager() !== null && !('pathTesselator' in layer.state);
    }
  }, {
    key: "getShaders",
    value: function getShaders(extension) {
      if (!extension.isEnabled(this)) {
        return null;
      }

      return {
        modules: [extension.opts.pattern && _shaders.patternShaders].filter(Boolean)
      };
    }
  }, {
    key: "initializeState",
    value: function initializeState(context, extension) {
      if (!extension.isEnabled(this)) {
        return;
      }

      var attributeManager = this.getAttributeManager();

      if (extension.opts.pattern) {
        attributeManager.add({
          fillPatternFrames: {
            size: 4,
            accessor: 'getFillPattern',
            transform: extension.getPatternFrame.bind(this),
            shaderAttributes: {
              fillPatternFrames: {
                divisor: 0
              },
              instanceFillPatternFrames: {
                divisor: 1
              }
            }
          },
          fillPatternScales: {
            size: 1,
            accessor: 'getFillPatternScale',
            defaultValue: 1,
            shaderAttributes: {
              fillPatternScales: {
                divisor: 0
              },
              instanceFillPatternScales: {
                divisor: 1
              }
            }
          },
          fillPatternOffsets: {
            size: 2,
            accessor: 'getFillPatternOffset',
            shaderAttributes: {
              fillPatternOffsets: {
                divisor: 0
              },
              instanceFillPatternOffsets: {
                divisor: 1
              }
            }
          }
        });
      }

      this.setState({
        emptyTexture: new _core2.Texture2D(this.context.gl, {
          data: new Uint8Array(4),
          width: 1,
          height: 1
        })
      });
    }
  }, {
    key: "updateState",
    value: function updateState(_ref2, extension) {
      var props = _ref2.props,
          oldProps = _ref2.oldProps;

      if (!extension.isEnabled(this)) {
        return;
      }

      if (props.fillPatternMapping && props.fillPatternMapping !== oldProps.fillPatternMapping) {
        this.getAttributeManager().invalidate('getFillPattern');
      }
    }
  }, {
    key: "draw",
    value: function draw(params, extension) {
      if (!extension.isEnabled(this)) {
        return;
      }

      var fillPatternAtlas = this.props.fillPatternAtlas;
      this.setModuleParameters({
        fillPatternTexture: fillPatternAtlas || this.state.emptyTexture
      });
    }
  }, {
    key: "finalizeState",
    value: function finalizeState() {
      var emptyTexture = this.state.emptyTexture;
      emptyTexture === null || emptyTexture === void 0 ? void 0 : emptyTexture.delete();
    }
  }, {
    key: "getPatternFrame",
    value: function getPatternFrame(name) {
      var fillPatternMapping = this.getCurrentLayer().props.fillPatternMapping;
      var def = fillPatternMapping && fillPatternMapping[name];
      return def ? [def.x, def.y, def.width, def.height] : [0, 0, 0, 0];
    }
  }]);
  return FillStyleExtension;
}(_core.LayerExtension);

exports.default = FillStyleExtension;
(0, _defineProperty2.default)(FillStyleExtension, "defaultProps", defaultProps);
(0, _defineProperty2.default)(FillStyleExtension, "extensionName", 'FillStyleExtension');
//# sourceMappingURL=fill-style-extension.js.map