"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _shadertools = require("@luma.gl/shadertools");

var _core = require("@deck.gl/core");

var _project = _interopRequireDefault(require("./project64.glsl"));

var fp64ify = _shadertools.fp64.fp64ify,
    fp64ifyMatrix4 = _shadertools.fp64.fp64ifyMatrix4;
var _default = {
  name: 'project64',
  dependencies: [_core.project, _shadertools.fp64],
  vs: _project.default,
  getUniforms: getUniforms
};
exports.default = _default;
var getMemoizedUniforms = (0, _core._memoize)(calculateUniforms);

function getUniforms(opts) {
  if (opts && 'viewport' in opts) {
    var _opts$viewport = opts.viewport,
        viewProjectionMatrix = _opts$viewport.viewProjectionMatrix,
        scale = _opts$viewport.scale;
    return getMemoizedUniforms({
      viewProjectionMatrix: viewProjectionMatrix,
      scale: scale
    });
  }

  return {};
}

function calculateUniforms(_ref) {
  var viewProjectionMatrix = _ref.viewProjectionMatrix,
      scale = _ref.scale;
  var glViewProjectionMatrixFP64 = fp64ifyMatrix4(viewProjectionMatrix);
  var scaleFP64 = fp64ify(scale);
  return {
    project_uViewProjectionMatrixFP64: glViewProjectionMatrixFP64,
    project64_uViewProjectionMatrix: glViewProjectionMatrixFP64,
    project64_uScale: scaleFP64
  };
}
//# sourceMappingURL=project64.js.map