"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _core2 = require("@luma.gl/core");

var _core3 = require("@math.gl/core");

var _maskPass = _interopRequireDefault(require("./mask-pass"));

var _projectionUtils = require("../utils/projection-utils");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var MaskEffect = function () {
  function MaskEffect() {
    (0, _classCallCheck2.default)(this, MaskEffect);
    (0, _defineProperty2.default)(this, "id", 'mask-effect');
    (0, _defineProperty2.default)(this, "props", null);
    (0, _defineProperty2.default)(this, "useInPicking", true);
    (0, _defineProperty2.default)(this, "order", 0);
    (0, _defineProperty2.default)(this, "dummyMaskMap", void 0);
    (0, _defineProperty2.default)(this, "channels", []);
    (0, _defineProperty2.default)(this, "masks", null);
    (0, _defineProperty2.default)(this, "maskPass", void 0);
    (0, _defineProperty2.default)(this, "maskMap", void 0);
    (0, _defineProperty2.default)(this, "lastViewport", void 0);
  }

  (0, _createClass2.default)(MaskEffect, [{
    key: "preRender",
    value: function preRender(gl, _ref) {
      var layers = _ref.layers,
          layerFilter = _ref.layerFilter,
          viewports = _ref.viewports,
          onViewportActive = _ref.onViewportActive,
          views = _ref.views,
          isPicking = _ref.isPicking;
      var didRender = false;

      if (!this.dummyMaskMap) {
        this.dummyMaskMap = new _core2.Texture2D(gl, {
          width: 1,
          height: 1
        });
      }

      if (isPicking) {
        return {
          didRender: didRender
        };
      }

      var maskLayers = layers.filter(function (l) {
        return l.props.visible && l.props.operation.includes('mask');
      });

      if (maskLayers.length === 0) {
        this.masks = null;
        this.channels.length = 0;
        return {
          didRender: didRender
        };
      }

      this.masks = {};

      if (!this.maskPass) {
        this.maskPass = new _maskPass.default(gl, {
          id: 'default-mask'
        });
        this.maskMap = this.maskPass.maskMap;
      }

      var channelMap = this._sortMaskChannels(maskLayers);

      var viewport = viewports[0];
      var viewportChanged = !this.lastViewport || !this.lastViewport.equals(viewport);

      if (viewport.resolution !== undefined) {
        _core.log.warn('MaskExtension is not supported in GlobeView')();

        return {
          didRender: didRender
        };
      }

      for (var maskId in channelMap) {
        var result = this._renderChannel(channelMap[maskId], {
          layerFilter: layerFilter,
          onViewportActive: onViewportActive,
          views: views,
          viewport: viewport,
          viewportChanged: viewportChanged
        });

        didRender || (didRender = result);
      }

      return {
        didRender: didRender
      };
    }
  }, {
    key: "_renderChannel",
    value: function _renderChannel(channelInfo, _ref2) {
      var layerFilter = _ref2.layerFilter,
          onViewportActive = _ref2.onViewportActive,
          views = _ref2.views,
          viewport = _ref2.viewport,
          viewportChanged = _ref2.viewportChanged;
      var didRender = false;
      var oldChannelInfo = this.channels[channelInfo.index];

      if (!oldChannelInfo) {
        return didRender;
      }

      var maskChanged = channelInfo === oldChannelInfo || channelInfo.layers.length !== oldChannelInfo.layers.length || channelInfo.layers.some(function (layer, i) {
        return layer !== oldChannelInfo.layers[i] || layer.props.transitions;
      }) || channelInfo.layerBounds.some(function (b, i) {
        return b !== oldChannelInfo.layerBounds[i];
      });
      channelInfo.bounds = oldChannelInfo.bounds;
      channelInfo.maskBounds = oldChannelInfo.maskBounds;
      this.channels[channelInfo.index] = channelInfo;

      if (maskChanged || viewportChanged) {
        this.lastViewport = viewport;
        var layerBounds = (0, _projectionUtils.joinLayerBounds)(channelInfo.layers, viewport);
        channelInfo.bounds = layerBounds && (0, _projectionUtils.getRenderBounds)(layerBounds, viewport);

        if (maskChanged || !(0, _core3.equals)(channelInfo.bounds, oldChannelInfo.bounds)) {
          var maskPass = this.maskPass,
              maskMap = this.maskMap;
          var maskViewport = layerBounds && (0, _projectionUtils.makeViewport)({
            bounds: channelInfo.bounds,
            viewport: viewport,
            width: maskMap.width,
            height: maskMap.height,
            border: 1
          });
          channelInfo.maskBounds = maskViewport ? maskViewport.getBounds() : [0, 0, 1, 1];
          maskPass.render({
            pass: 'mask',
            channel: channelInfo.index,
            layers: channelInfo.layers,
            layerFilter: layerFilter,
            viewports: maskViewport ? [maskViewport] : [],
            onViewportActive: onViewportActive,
            views: views,
            moduleParameters: {
              devicePixelRatio: 1
            }
          });
          didRender = true;
        }
      }

      this.masks[channelInfo.id] = {
        index: channelInfo.index,
        bounds: channelInfo.maskBounds,
        coordinateOrigin: channelInfo.coordinateOrigin,
        coordinateSystem: channelInfo.coordinateSystem
      };
      return didRender;
    }
  }, {
    key: "_sortMaskChannels",
    value: function _sortMaskChannels(maskLayers) {
      var _this = this;

      var channelMap = {};
      var channelCount = 0;

      var _iterator = _createForOfIteratorHelper(maskLayers),
          _step;

      try {
        var _loop = function _loop() {
          var layer = _step.value;
          var id = layer.root.id;
          var channelInfo = channelMap[id];

          if (!channelInfo) {
            if (++channelCount > 4) {
              _core.log.warn('Too many mask layers. The max supported is 4')();

              return "continue";
            }

            channelInfo = {
              id: id,
              index: _this.channels.findIndex(function (c) {
                return (c === null || c === void 0 ? void 0 : c.id) === id;
              }),
              layers: [],
              layerBounds: [],
              coordinateOrigin: layer.root.props.coordinateOrigin,
              coordinateSystem: layer.root.props.coordinateSystem
            };
            channelMap[id] = channelInfo;
          }

          channelInfo.layers.push(layer);
          channelInfo.layerBounds.push(layer.getBounds());
        };

        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _ret = _loop();

          if (_ret === "continue") continue;
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      for (var i = 0; i < 4; i++) {
        var channelInfo = this.channels[i];

        if (!channelInfo || !(channelInfo.id in channelMap)) {
          this.channels[i] = null;
        }
      }

      for (var maskId in channelMap) {
        var _channelInfo = channelMap[maskId];

        if (_channelInfo.index < 0) {
          _channelInfo.index = this.channels.findIndex(function (c) {
            return !c;
          });
          this.channels[_channelInfo.index] = _channelInfo;
        }
      }

      return channelMap;
    }
  }, {
    key: "getModuleParameters",
    value: function getModuleParameters() {
      return {
        maskMap: this.masks ? this.maskMap : this.dummyMaskMap,
        maskChannels: this.masks
      };
    }
  }, {
    key: "cleanup",
    value: function cleanup() {
      if (this.dummyMaskMap) {
        this.dummyMaskMap.delete();
        this.dummyMaskMap = undefined;
      }

      if (this.maskPass) {
        this.maskPass.delete();
        this.maskPass = undefined;
        this.maskMap = undefined;
      }

      this.lastViewport = undefined;
      this.masks = null;
      this.channels.length = 0;
    }
  }]);
  return MaskEffect;
}();

exports.default = MaskEffect;
//# sourceMappingURL=mask-effect.js.map