"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _shaderModule = _interopRequireDefault(require("./shader-module"));

var _maskEffect = _interopRequireDefault(require("./mask-effect"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var defaultProps = {
  maskId: '',
  maskByInstance: undefined,
  maskInverted: false
};

var MaskExtension = function (_LayerExtension) {
  (0, _inherits2.default)(MaskExtension, _LayerExtension);

  var _super = _createSuper(MaskExtension);

  function MaskExtension() {
    (0, _classCallCheck2.default)(this, MaskExtension);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(MaskExtension, [{
    key: "initializeState",
    value: function initializeState() {
      var _this$context$deck;

      (_this$context$deck = this.context.deck) === null || _this$context$deck === void 0 ? void 0 : _this$context$deck._addDefaultEffect(new _maskEffect.default());
    }
  }, {
    key: "getShaders",
    value: function getShaders() {
      var maskByInstance = ('instancePositions' in this.getAttributeManager().attributes);

      if (this.props.maskByInstance !== undefined) {
        maskByInstance = Boolean(this.props.maskByInstance);
      }

      this.state.maskByInstance = maskByInstance;
      return {
        modules: [_shaderModule.default]
      };
    }
  }, {
    key: "draw",
    value: function draw(_ref) {
      var uniforms = _ref.uniforms,
          context = _ref.context,
          moduleParameters = _ref.moduleParameters;
      uniforms.mask_maskByInstance = this.state.maskByInstance;
      var _this$props = this.props,
          maskId = _this$props.maskId,
          maskInverted = _this$props.maskInverted;
      var maskChannels = moduleParameters.maskChannels;
      var viewport = context.viewport;

      if (maskChannels && maskChannels[maskId]) {
        var _maskChannels$maskId = maskChannels[maskId],
            index = _maskChannels$maskId.index,
            bounds = _maskChannels$maskId.bounds,
            fromCoordinateOrigin = _maskChannels$maskId.coordinateOrigin;
        var fromCoordinateSystem = maskChannels[maskId].coordinateSystem;
        uniforms.mask_enabled = true;
        uniforms.mask_channel = index;
        uniforms.mask_inverted = maskInverted;

        if (fromCoordinateSystem === _core.COORDINATE_SYSTEM.DEFAULT) {
          fromCoordinateSystem = viewport.isGeospatial ? _core.COORDINATE_SYSTEM.LNGLAT : _core.COORDINATE_SYSTEM.CARTESIAN;
        }

        var opts = {
          modelMatrix: null,
          fromCoordinateOrigin: fromCoordinateOrigin,
          fromCoordinateSystem: fromCoordinateSystem
        };
        var bl = this.projectPosition([bounds[0], bounds[1], 0], opts);
        var tr = this.projectPosition([bounds[2], bounds[3], 0], opts);
        uniforms.mask_bounds = [bl[0], bl[1], tr[0], tr[1]];
      } else {
        if (maskId) {
          _core.log.warn("Could not find a mask layer with id: ".concat(maskId))();
        }

        uniforms.mask_enabled = false;
      }
    }
  }]);
  return MaskExtension;
}(_core.LayerExtension);

exports.default = MaskExtension;
(0, _defineProperty2.default)(MaskExtension, "defaultProps", defaultProps);
(0, _defineProperty2.default)(MaskExtension, "extensionName", 'MaskExtension');
//# sourceMappingURL=mask-extension.js.map